/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.publish.Publisher;
import com.pageseeder.uri.URIUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class URIUpdateLabels
implements Action<URI> {
    private @Nullable Group group = null;
    private @Nullable LabelUpdater updater = null;
    private final boolean addLabels;

    protected URIUpdateLabels(boolean add) {
        this.addLabels = add;
    }

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        if (URIs.isExternal((URI)uri)) {
            return new EditAllURLsCheck();
        }
        return new EditURICheck(uri);
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        String groupNameOrID = parent.getGroupName();
        try {
            this.group = GroupRule.getGroup((Database)db, (String)groupNameOrID);
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + groupNameOrID + ": " + e.getMessage());
        }
        if (this.group == null) {
            throw new ActionException("Invalid group " + groupNameOrID);
        }
        String labelsList = parent.getParameter("labels");
        if (labelsList == null) {
            throw new ActionException("labels parameter is missing", true);
        }
        if (!URIUtils.checkLabels(null, labelsList)) {
            throw new ActionException("labels parameter invalid", true);
        }
        String[] labels = Strings.split((String)labelsList, (char)',');
        this.updater = new LabelUpdater(parent.getMemberUsername(), this.group, labels, this.addLabels);
        ChangesManager.getInstance().startBatch(db, this.updater.batch);
        return this.updater;
    }

    @Override
    public void addObject(URI uri, Database db) {
        this.updater.addURI(uri);
    }

    @Override
    public Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    static class LabelUpdater
    extends ProcessThread {
        private final boolean add;
        private final String[] labels;
        private final ChangesBatch batch;
        private final String username;
        private final List<Long> uriids = new ArrayList<Long>();
        private int currentProgress = 0;

        LabelUpdater(String username, Group group, String[] labels, boolean add) {
            super(username, add ? "Adding labels to documents" : "Removing labels from documents", group);
            this.add = add;
            this.labels = labels;
            this.username = username;
            this.batch = new ChangesBatch(this.getName());
        }

        private void addURI(URI uri) {
            this.uriids.add(uri.getId());
        }

        public void process() {
            Member author;
            Transaction tr;
            Database db;
            String labelsString = this.labels.length == 1 ? "1 label" : this.labels.length + " labels";
            try {
                db = Database.open();
                tr = new Transaction(db);
            }
            catch (OpenDatabaseException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database");
                return;
            }
            try {
                author = DatabaseQuery.getMemberByUsername((Database)db, (String)this.username);
            }
            catch (QueryFailedException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to load author");
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, (this.add ? "Adding " + labelsString + " to " : "Removing " + labelsString + " from ") + this.uriids.size() + " documents");
            for (Long uriid : this.uriids) {
                try {
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                    ++this.currentProgress;
                    if (this.add) {
                        Labels.addLabels((URI)uri, (String[])this.labels);
                    } else {
                        Labels.removeLabels((URI)uri, (String[])this.labels);
                    }
                    URIRule.addURIHistoryXLink((URI)uri, (Member)author, (Database)db);
                    uri.setLastModified(new Date());
                    if (this.wasCancelled()) {
                        ChangesManager.getInstance().completeBatch(db, this.batch);
                        tr.abort();
                        return;
                    }
                    this.updateStatus(ProcessStage.Status.INPROGRESS, (this.add ? "Added " + labelsString + " to " : "Removed " + labelsString + " from ") + " document " + uri.getDecodedPath());
                    tr.commitAndStart();
                    Publications.updateURI((URI)uri);
                    ChangesManager.getInstance().modifyURI(db, this.batch, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
                }
                catch (DatabaseException ex) {
                    this.updateStatus(ProcessStage.Status.ERROR, "Failed to update URI " + uriid + ": " + ex.getMessage());
                }
            }
            this.currentProgress = this.uriids.size();
            ChangesManager.getInstance().completeBatch(db, this.batch);
            this.complete("Successfully " + (this.add ? "added " + labelsString + " to " : "removed " + labelsString + " from ") + this.uriids.size() + " documents");
        }

        public void writeThreadElements(OutputPrinter out) {
            out.startObject("progress");
            out.field("total", (long)this.uriids.size());
            out.field("current", (long)this.currentProgress);
            out.endObject();
        }
    }
}

