/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.action.URIAddVersion;
import com.pageseeder.action.URIAddWorkflow;
import com.pageseeder.action.URIArchive;
import com.pageseeder.action.URIArchiveURL;
import com.pageseeder.action.URIMove;
import com.pageseeder.action.URIPublish;
import com.pageseeder.action.URIUpdateLabels;
import com.pageseeder.action.URIUsageReport;
import com.pageseeder.action.URIUsageSchema;
import com.pageseeder.action.URIValidate;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class URIActionProcessor
extends ActionProcessor<URI> {
    public URIActionProcessor(String name, Map<String, String> params, Member member, String gname, UserDetails details, String token, Database db, Transaction tr) {
        super(name, params, member, gname, details, token, db, tr);
    }

    @Override
    public Action<URI> createAction(String name) {
        switch (URIActionName.valueOf(name)) {
            case addlabel: {
                return new URIUpdateLabels(true);
            }
            case removelabel: {
                return new URIUpdateLabels(false);
            }
            case addversion: {
                return new URIAddVersion();
            }
            case addworkflow: {
                return new URIAddWorkflow();
            }
            case move: {
                return new URIMove();
            }
            case archive: {
                return new URIArchive();
            }
            case archiveurl: {
                return new URIArchiveURL();
            }
            case usageschema: {
                return new URIUsageSchema();
            }
            case usagereport: {
                return new URIUsageReport();
            }
            case validate: {
                return new URIValidate();
            }
            case publish: {
                return new URIPublish();
            }
        }
        throw new IllegalArgumentException("'" + name + " is not a valid batch action for a URI.");
    }

    @Override
    public @Nullable URI loadObject(Database database, Long id) throws ActionException {
        try {
            return DatabaseQuery.getURIById((Database)database, (Long)id);
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load URI with ID " + id, e);
        }
    }

    private static enum URIActionName {
        addlabel,
        removelabel,
        addversion,
        addworkflow,
        move,
        archive,
        archiveurl,
        usageschema,
        usagereport,
        validate,
        publish;

    }
}

