/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.action.ActionUtils;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.DBObject;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;

@Requires(member=true, group=true, parameters={"object", "action", "ids"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class RunBatchAction
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewGroupCheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        ActionProcessor.ActionResult result;
        String object = req.getParameter((Parameter)StandardParameters.object);
        String action = req.getParameter((Parameter)StandardParameters.action);
        String idsAsString = req.getParameter((Parameter)StandardParameters.ids);
        assert (object != null && action != null && idsAsString != null);
        String[] idsStr = Strings.split((String)idsAsString, (char)',');
        Long[] ids = new Long[idsStr.length];
        for (int i = 0; i < ids.length; ++i) {
            try {
                ids[i] = Long.parseLong(idsStr[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Invalid ids parameter: invalid ID " + idsStr[i]);
                return;
            }
        }
        if (ids.length == 0) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid ids parameter is empty");
            return;
        }
        ActionProcessor<? extends DBObject> processor = ActionUtils.createProcessor(req, res);
        if (processor == null) {
            return;
        }
        try {
            result = processor.execute(ids);
        }
        catch (ActionException ex) {
            res.setError(ex.isClientError() ? GeneratorStatus.BAD_REQUEST : GeneratorStatus.SERVER_ERROR, ex.getMessage());
            return;
        }
        Collection<Long> forbidden = result.getDisallowed();
        if (!forbidden.isEmpty()) {
            String msg = "Forbidden for " + forbidden.size() + " object" + (forbidden.size() == 1 ? "" : "s") + ": " + forbidden.stream().map(Object::toString).collect(Collectors.joining(", "));
            res.setError(GeneratorStatus.FORBIDDEN, msg);
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("batch-action");
        out.field("name", action);
        out.field("object", object);
        out.field("ids", idsAsString);
        if (result.getPublisherResponse() != null) {
            out.field("publisherxml", result.getPublisherResponse(), OutputPrinter.FieldOption.XML_COPY);
        } else if (result.getThread() != null) {
            result.getThread().print((OutputPrinter)out);
        }
        out.endObject();
        out.flush();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

