/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Member;
import com.pageseeder.publish.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionProcessor<T extends DBObject> {
    private final Action<T> action;
    private final Database db;
    private final Transaction tr;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String groupName;
    private final String memberUsername;
    private final Long memberId;
    private final UserDetails userDetails;
    private final String userToken;
    private int totalIds = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionProcessor.class);

    public ActionProcessor(String name, @Nullable Map<String, String> params, Member member, String groupName, UserDetails details, String userToken, Database db, Transaction tr) {
        this.action = this.createAction(name);
        if (params != null) {
            this.parameters.putAll(params);
        }
        this.memberUsername = member.getUsername();
        this.memberId = member.getId();
        this.userDetails = details;
        this.userToken = userToken;
        this.groupName = groupName;
        this.db = db;
        this.tr = tr;
    }

    public final String getMemberUsername() {
        return this.memberUsername;
    }

    public final Long getMemberID() {
        return this.memberId;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public final int getTotalIDs() {
        return this.totalIds;
    }

    protected final @Nullable String getParameter(String name) {
        return this.parameters.get(name);
    }

    protected final Map<String, String> getParametersPrefix(String prefix) {
        HashMap<String, String> prefixed = new HashMap<String, String>();
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            String name = parameter.getKey();
            if (!name.startsWith(prefix)) continue;
            prefixed.put(name.substring(prefix.length()), parameter.getValue());
        }
        return prefixed;
    }

    public final ActionResult execute(Long[] ids) throws ActionException {
        this.totalIds = ids.length;
        Permissions perm = new Permissions();
        ProcessThread thread = null;
        Publisher publisher = null;
        if (this.action.isProcess()) {
            thread = this.action.initThread(this, this.db, this.tr);
        } else {
            publisher = this.action.initPublisher(this, this.db, this.tr);
        }
        ActionResult result = new ActionResult();
        for (Long id : ids) {
            T o = this.loadObject(this.db, id);
            if (o == null) continue;
            PermissionCheck check = this.action.permissionCheck(o);
            if (!PermissionManager.check((Long)this.memberId, (UserDetails)this.userDetails, (Database)this.db, (Permissions)perm, (PermissionCheck)check)) {
                result.disallowed.add(id);
                if (result.disallowed.size() <= 10) continue;
                break;
            }
            this.action.addObject(o, this.db);
        }
        if (!result.disallowed.isEmpty()) {
            return result;
        }
        if (thread != null) {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start(thread);
            result.thread = thread;
        } else if (publisher != null) {
            try {
                publisher.run();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to run batch action publisher", (Throwable)ex);
                throw new ActionException("Failed to run publisher: " + ex.getMessage() + ".", ex);
            }
            result.publisherResponse = publisher.getResponse();
        } else {
            throw new ActionException("Invalid state with no thread or publisher.");
        }
        return result;
    }

    protected abstract Action<T> createAction(String var1);

    protected abstract @Nullable T loadObject(Database var1, Long var2) throws ActionException;

    protected static class ActionResult {
        private final Collection<Long> disallowed = new ArrayList<Long>();
        private @Nullable ProcessThread thread = null;
        private @Nullable String publisherResponse = null;

        protected ActionResult() {
        }

        public Collection<Long> getDisallowed() {
            return this.disallowed;
        }

        public @Nullable ProcessThread getThread() {
            return this.thread;
        }

        public @Nullable String getPublisherResponse() {
            return this.publisherResponse;
        }
    }
}

