/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationThread.class);
    public static int[] notifyDailyTime = new int[]{23, 59};
    public static Calendar nextNotify = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] ndt = RuleUtils.delimitedToArray((String)GlobalSettings.getString((String)"notifyDailyTime", (String)"23:59"), (String)":");
        NotificationThread.notifyDailyTime[0] = Integer.parseInt(ndt[0]);
        NotificationThread.notifyDailyTime[1] = Integer.parseInt(ndt[1]);
        GregorianCalendar current = new GregorianCalendar();
        nextNotify = new GregorianCalendar(current.get(1), current.get(2), current.get(5), notifyDailyTime[0], notifyDailyTime[1]);
        if (current.after(nextNotify)) {
            nextNotify.add(5, 1);
        }
        LOGGER.info("Notification Thread Started");
        while (true) {
            if (current.after(nextNotify)) {
                Calendar lastNotify = (Calendar)nextNotify.clone();
                lastNotify.add(5, -1);
                nextNotify.add(5, 1);
                Calendar lastWeeklyNotify = (Calendar)nextNotify.clone();
                lastWeeklyNotify.add(5, -7);
                Iterator grpni = null;
                Database db = null;
                try {
                    db = Database.open();
                }
                catch (OpenDatabaseException ex) {
                    LOGGER.error("Unable to open database", (Throwable)ex);
                    db = null;
                    return;
                }
                Transaction tr = new Transaction(db);
                try {
                    tr.begin();
                    Collection grpc = DatabaseQuery.getAllNonArchivedGroupsCol((Database)db);
                    ArrayList<String> grpnc = new ArrayList<String>();
                    for (Group grp : grpc) {
                        if ("admin".equals(grp.getName()) || "public".equals(grp.getName())) continue;
                        grpnc.add(grp.getName());
                    }
                    grpni = grpnc.iterator();
                    tr.commit();
                }
                catch (StartTransactionException ex) {
                    LOGGER.error("Unable to start transaction", (Throwable)ex);
                }
                catch (DatabaseException ex) {
                    LOGGER.error("Database error", (Throwable)ex);
                    tr.abort();
                }
                finally {
                    db.close();
                    db = null;
                }
                boolean stopped = false;
                while (grpni != null && grpni.hasNext() && !stopped) {
                    String grp_name = (String)grpni.next();
                    try {
                        db = Database.open();
                    }
                    catch (OpenDatabaseException ex) {
                        LOGGER.error("Unable to open database", (Throwable)ex);
                        db = null;
                        return;
                    }
                    try {
                        tr = new Transaction(db);
                        tr.begin();
                        Group grp = DatabaseQuery.getGroupByName((Database)db, (String)grp_name);
                        if (grp != null) {
                            Collection xls;
                            Collection mems = DatabaseQuery.getMembersByGroupIdNotification((Database)db, (Long)grp.getId(), (String)"Daily");
                            if (mems != null && !mems.isEmpty() && (xls = DatabaseQuery.getCommentsByGroupIdDateAfter((Database)db, (Long)grp.getId(), (Date)lastNotify.getTime())) != null && !xls.isEmpty()) {
                                Emails.sendCommentDigest((Database)db, (Group)grp, (String)"daily", (Collection)xls, (Collection)mems);
                            }
                            if (NotificationThread.isWeeklyNotificationDay(current) && (mems = DatabaseQuery.getMembersByGroupIdNotification((Database)db, (Long)grp.getId(), (String)"Weekly")) != null && !mems.isEmpty() && (xls = DatabaseQuery.getCommentsByGroupIdDateAfter((Database)db, (Long)grp.getId(), (Date)lastWeeklyNotify.getTime())) != null && !xls.isEmpty()) {
                                Emails.sendCommentDigest((Database)db, (Group)grp, (String)"weekly", (Collection)xls, (Collection)mems);
                            }
                        }
                        tr.commit();
                    }
                    catch (StartTransactionException ex) {
                        LOGGER.error("Unable to start transaction", (Throwable)ex);
                    }
                    catch (EmailException ex) {
                        tr.abort();
                        LOGGER.error("Unable to send email", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        tr.abort();
                        LOGGER.error("Unexpected error", (Throwable)ex);
                    }
                    finally {
                        db.close();
                        db = null;
                    }
                    if (!Thread.interrupted()) continue;
                    stopped = true;
                }
                if (stopped) break;
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ex) {
                break;
            }
            current = new GregorianCalendar();
        }
        LOGGER.info("Notification Thread Stopped");
    }

    private static boolean isWeeklyNotificationDay(Calendar current) {
        String day_name = GlobalSettings.getString((String)"notifyWeeklyDay", (String)"sunday");
        LocalDateTime ldt = LocalDateTime.ofInstant(current.toInstant(), ZoneId.systemDefault());
        DayOfWeek day = DayOfWeek.from(ldt);
        return day_name.equalsIgnoreCase(day.toString());
    }
}

