/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.Initialize;
import com.pageseeder.UpdateConfigs;
import com.pageseeder.base.logback.XLogConfigurator;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.properties.DatabaseSettings;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.member.ProfilePictureServlet;
import com.pageseeder.publication.RepairPublicationsThread;
import com.pageseeder.publisher.utils.FilesCleanerThread;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.webhook.manager.WebhookManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializeThread
extends ProcessThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializeThread.class);
    private static final Pattern ERROR_MESSAGE_PATTERN = Pattern.compile("<error\\s+message=\"(.*?)\"");
    public static final String CURRENT_DB_VERSION = "6.20";
    private final ServletContext context;
    private int total = 0;
    private int currentProgress = 0;

    public InitializeThread(ServletContext cont) {
        super(null, "Initializing PageSeeder", null);
        this.context = cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            File documentsPath;
            boolean updateDB;
            String dburl;
            Database.setError((String)"Initializing PageSeeder");
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Initializing settings");
            File update = new File(Settings.getContextPath() + "WEB-INF" + File.separator + "sysconfig" + File.separator + "update.txt");
            if (update.exists()) {
                try {
                    UpdateConfigs.moveLogFiles();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            XLogConfigurator.reload((String)"logback-pageseeder.xml");
            String password = DatabaseSettings.get((String)"LoginPassword");
            if (password != null) {
                DatabaseSettings.setPassword((String)password);
                Settings.remove((SettingsFile)SettingsFile.DATABASE, (String)"LoginPassword");
                Settings.save((SettingsFile)SettingsFile.DATABASE);
                Settings.removeBackupDatabaseSettings();
            }
            Settings.mergeTemplateWithGlobalSettings();
            if (update.exists()) {
                File jdo = new File(this.context.getRealPath("/"), "WEB-INF/classes/com/pageseeder/db/model/package.jdo");
                if (jdo.exists() && !jdo.delete()) {
                    throw new RuntimeException("package.jdo in classes folder could not be deleted");
                }
                jdo = new File(this.context.getRealPath("/"), "WEB-INF/classes/com/pageseeder/db/oauth/package.jdo");
                if (jdo.exists() && !jdo.delete()) {
                    throw new RuntimeException("oauth package.jdo in classes folder could not be deleted");
                }
            }
            if (!Strings.isEmpty((String)(dburl = DatabaseSettings.get((String)"DBURL")))) {
                String database_type = DatabaseSettings.get((String)"DatabaseType");
                Initialize.checkForJDOPackageFile(database_type, "/com/pageseeder/db/model", this.context);
                Initialize.checkForJDOPackageFile(database_type, "/com/pageseeder/db/oauth", this.context);
                Database.closeAll();
                Database.reloadConfig();
            }
            if (updateDB = update.exists()) {
                try {
                    this.runScripts();
                    InitializeThread.reportToLicenseServer();
                    if (!update.delete()) {
                        throw new RuntimeException("update.txt in sysconfig folder could not be deleted");
                    }
                }
                catch (IOException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            Initialize.deleteIndexLockFiles(this.context);
            IndexMaster.initialise((File)new File(this.context.getRealPath("/")));
            Database.setError(null);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Starting processes");
            if (Strings.isEmpty((String)dburl)) {
                WebhookManager manager = WebhookManager.getInstance();
                manager.start();
            } else {
                Database db;
                try {
                    db = Database.open();
                }
                catch (OpenDatabaseException ex) {
                    throw new RuntimeException("Failed to open database: " + ex.getMessage(), ex);
                }
                Transaction tr = new Transaction(db);
                try {
                    Group grp = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
                    if (grp == null) {
                        throw new RuntimeException("Admin group not found");
                    }
                    WebhookManager manager = WebhookManager.getInstance();
                    manager.start(db);
                    manager.serverStart();
                    tr.commit();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to start webhooks: " + ex.getMessage(), ex);
                }
                finally {
                    db.close();
                    db = null;
                }
            }
            OrganizationManager.instance().load();
            Initialize.initMail();
            Initialize.startBackgroundThreads(this.context);
            Initialize.schedulePersistentTokenPurgeThread();
            SecurityUtils.loadPasswordConfig();
            LOGGER.info("Publisher: Starting file cleaners");
            FilesCleanerThread.startSessionFilesCleaner();
            FilesCleanerThread.startWorkingFilesCleaner();
            if (updateDB) {
                Initialize.updateHelpIndex();
            }
            if (!(documentsPath = new File(Settings.getDocumentPath())).exists()) {
                documentsPath.mkdirs();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to initialize PageSeeder", (Throwable)e);
            this.fail("Initialization failed, see general log for details.");
            Database.setError((String)("Failed to initialize PageSeeder: " + e.getMessage()));
        }
        finally {
            this.complete("Initialization successful");
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.total);
        out.field("current", (long)this.currentProgress);
        out.endObject();
    }

    private void runScripts() throws SQLException, IOException {
        String dbUrl = DatabaseSettings.get((String)"DBURL");
        if (dbUrl == null || dbUrl.isEmpty()) {
            return;
        }
        LOGGER.info("Running Database Update");
        InitializeThread.loadDriver();
        try (Connection con = DriverManager.getConnection(dbUrl, DatabaseSettings.get((String)"LoginName"), DatabaseSettings.getPassword());){
            LOGGER.info("Connected to database");
            ArrayList<String> previousVersions = new ArrayList<String>();
            boolean resolvePublications = false;
            while (true) {
                String version = InitializeThread.getDBVersion(con);
                LOGGER.info("Found database version {}", (Object)version);
                if (CURRENT_DB_VERSION.equals(version)) break;
                if (previousVersions.contains(version)) {
                    throw new SQLException("Script did not update version correctly");
                }
                previousVersions.add(version);
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Updating database");
                if ("5.71".equals(version)) {
                    InitializeThread.updateVersion571(con);
                } else if ("5.81".equals(version)) {
                    LOGGER.warn("PS Standard documents have not been resolved so edits on them will be lost.");
                } else if ("5.82".equals(version)) {
                    version = "5.81";
                } else if ("5.83".equals(version)) {
                    InitializeThread.updateVersion583();
                } else {
                    if ("5.90".equals(version)) {
                        InitializeThread.updateVersion590(con);
                        continue;
                    }
                    if ("5.95".equals(version)) {
                        InitializeThread.updateVersion595(con);
                        continue;
                    }
                    if ("5.96".equals(version)) {
                        InitializeThread.updateVersion596();
                    } else if ("5.97".equals(version)) {
                        InitializeThread.updateVersion597();
                        resolvePublications = true;
                    } else if ("5.981".equals(version)) {
                        InitializeThread.updateVersion5981(con);
                    } else if ("5.99".equals(version)) {
                        InitializeThread.updateVersion599();
                    } else if ("6.00".equals(version)) {
                        InitializeThread.updateVersion600(con);
                    }
                }
                File script = InitializeThread.findScript(version);
                this.execScript(con, script);
            }
            LOGGER.info("Database is up to date");
            if (resolvePublications) {
                InitializeThread.repairPublications();
            }
        }
    }

    public static void reportToLicenseServer() {
        block12: {
            String hostname = GlobalSettings.getString((String)"webSiteAddress", (String)"");
            if (!"localhost".equals(hostname) && !hostname.endsWith(".localhost")) {
                try {
                    String service = "https://license.pageseeder.com/public/api/report.xml?hostname=" + hostname + "&version=" + Settings.getPageSeederVersion();
                    LOGGER.debug("License server request: {}", (Object)service);
                    HttpURLConnection con = (HttpURLConnection)new URL(service).openConnection();
                    con.setRequestMethod("POST");
                    int code = con.getResponseCode();
                    if (code == 200) break block12;
                    try (InputStream in = con.getErrorStream();){
                        int c;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                        StringBuilder builder = new StringBuilder();
                        while ((c = reader.read()) != -1) {
                            builder.append((char)c);
                        }
                        String xml = builder.toString();
                        Matcher m = ERROR_MESSAGE_PATTERN.matcher(xml);
                        if (m.find()) {
                            LOGGER.warn("Unable to report to license server: {}", (Object)m.group(1));
                        } else {
                            LOGGER.warn("Unable to report to license server: HTTP code {}", (Object)code);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Unable to contact license server: {}", (Object)ex.toString());
                }
            }
        }
    }

    private static void loadDriver() throws SQLException {
        try {
            Class.forName(DatabaseSettings.get((String)"DBDriver")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new SQLException(ex);
        }
    }

    private static String getDBVersion(Connection con) throws SQLException {
        try (Statement s = con.createStatement();){
            ResultSet rs = s.executeQuery("SELECT Version FROM DATABASE_METADATA");
            if (!rs.next()) {
                throw new SQLException("Database version not found");
            }
            String version = rs.getString(1);
            if ("5.60".equals(version)) {
                version = "5.40";
            }
            String string = version;
            return string;
        }
    }

    private static void updateVersion571(Connection con) throws SQLException {
        try (Statement s = con.createStatement();){
            ResultSet rs = s.executeQuery("SELECT DISTINCT t1.fragment, t1.locatorid, u1.uriid FROM LOCATOR t1, LOCATOR t2, LOCATOR_FOR_URI u1, LOCATOR_FOR_URI u2 WHERE t1.fragment = t2.fragment AND t1.locatorid<>t2.locatorid AND t1.locatorid=u1.locatorid AND t2.locatorid=u2.locatorid AND u1.uriid=u2.uriid ORDER BY u1.uriid, t1.fragment;");
            String prev_fragment = "";
            long prev_locatorid = -1L;
            long prev_uriid = -1L;
            while (rs.next()) {
                String fragment = rs.getString(1);
                long locatorid = rs.getLong(2);
                long uriid = rs.getLong(3);
                if (fragment.equalsIgnoreCase(prev_fragment) && uriid == prev_uriid) {
                    int rows;
                    String sql = "UPDATE LOCATOR_FOR_XLINK SET locatorid=" + locatorid + " WHERE locatorid=" + prev_locatorid;
                    try (Statement s2 = con.createStatement();){
                        LOGGER.info("Fixing duplicate fragment: {}", (Object)sql);
                        rows = s2.executeUpdate(sql);
                        LOGGER.info("Rows updated: {}", (Object)rows);
                    }
                    sql = "UPDATE LOCATOR SET fragment=? WHERE locatorid=" + prev_locatorid;
                    try (PreparedStatement s3 = con.prepareStatement(sql);){
                        s3.setString(1, prev_fragment + "_old" + rs.getRow());
                        LOGGER.info("Renaming duplicate fragment: {}", (Object)sql);
                        rows = s3.executeUpdate();
                        LOGGER.info("Rows updated: {}", (Object)rows);
                    }
                }
                prev_fragment = fragment;
                prev_locatorid = locatorid;
                prev_uriid = uriid;
            }
        }
    }

    private static void updateVersion583() throws IOException {
        File webapp = new File(Settings.getContextPath());
        File working = new File(webapp, "../ps-publisher/WEB-INF/working");
        LOGGER.info("Deleting {}", (Object)working.getCanonicalPath());
        FileUtils.deleteDirectory((File)working);
    }

    private static void updateVersion590(Connection con) throws IOException, SQLException {
        String cachePath = System.getProperty("pageseeder.ehcache");
        if (cachePath == null || cachePath.isEmpty()) {
            throw new IOException("System property pageseeder.ehcache is not set.");
        }
        File cache = new File(cachePath);
        LOGGER.info("Deleting {}", (Object)cache.getCanonicalPath());
        FileUtils.deleteDirectory((File)cache);
        try (Statement s = con.createStatement();){
            String sql = "UPDATE DATABASE_METADATA SET VERSION='5.92'";
            LOGGER.info("Executing: {}", (Object)sql);
            int rows = s.executeUpdate(sql);
            LOGGER.info("Rows updated: {}", (Object)rows);
        }
    }

    private static void updateVersion595(Connection con) throws SQLException {
        UpdateConfigs.convertAllEditorConfigs();
        try (Statement s = con.createStatement();){
            String sql = "UPDATE DATABASE_METADATA SET VERSION='5.96'";
            LOGGER.info("Executing: {}", (Object)sql);
            int rows = s.executeUpdate(sql);
            LOGGER.info("Rows updated: {}", (Object)rows);
        }
    }

    private static void updateVersion596() throws IOException {
        UpdateConfigs.moveConfigAndStateFiles();
    }

    private static void updateVersion597() throws IOException {
        String cachePath = System.getProperty("pageseeder.ehcache");
        if (cachePath == null || cachePath.isEmpty()) {
            throw new IOException("System property pageseeder.ehcache is not set.");
        }
        File cache = new File(cachePath);
        LOGGER.info("Deleting publication caches.");
        Files.deleteIfExists(new File(cache, "publication-tocs.data").toPath());
        Files.deleteIfExists(new File(cache, "publication-tocs.index").toPath());
        Files.deleteIfExists(new File(cache, "publication-updates.data").toPath());
        Files.deleteIfExists(new File(cache, "publication-updates.index").toPath());
    }

    private static void updateVersion5981(Connection con) throws SQLException {
        int count = 0;
        try (Statement s = con.createStatement();){
            ResultSet rs = s.executeQuery("SELECT DISTINCT X.XLinkID FROM XLINK X INNER JOIN XLINK_FOR_XLINK XFX ON X.XLinkID = XFX.ReplyToID INNER JOIN XLINK reply ON reply.XLinkID = XFX.ReplyID WHERE reply.ContentRole = 'Comment' OR reply.ContentRole = 'File Attachment' OR reply.ContentRole = 'Workflow'");
            while (rs.next()) {
                long xlinkid = rs.getLong(1);
                Statement s2 = con.createStatement();
                try {
                    ResultSet rs2 = s2.executeQuery("SELECT MAX(X2.XLinkID) FROM XLINK X2 INNER JOIN XLINK_FOR_XLINK XFX2 ON X2.XLinkID = XFX2.ReplyID WHERE XFX2.ReplyToID = " + xlinkid + " AND (X2.ContentRole = 'Comment' OR X2.ContentRole = 'File Attachment' OR X2.ContentRole = 'Workflow')");
                    if (!rs2.next()) continue;
                    long threadEndId = rs2.getLong(1);
                    try (Statement s3 = con.createStatement();){
                        s3.executeUpdate("UPDATE XLINK SET ThreadEndXLinkID = " + threadEndId + " WHERE XLinkID = " + xlinkid);
                    }
                    if (++count % 1000 != 0) continue;
                    LOGGER.info("Updated thread end ID for {} xlinks.", (Object)count);
                }
                finally {
                    if (s2 == null) continue;
                    s2.close();
                }
            }
        }
        LOGGER.info("Updated thread end ID for {} xlinks in total.", (Object)count);
    }

    private static void updateVersion599() {
        ProfilePictureServlet.clearCache();
    }

    private static void updateVersion600(Connection con) {
        if ("MySQL".equals(DatabaseSettings.get((String)"DatabaseType"))) {
            try (Statement s = con.createStatement();){
                String sql = "ALTER TABLE HOST DROP Flags";
                LOGGER.info("Executing: {}", (Object)sql);
                int rows = s.executeUpdate(sql);
                LOGGER.info("Rows updated: {}", (Object)rows);
            }
            catch (SQLException ex) {
                LOGGER.info(ex.getMessage());
            }
        }
    }

    private static File findScript(String version) throws FileNotFoundException {
        String dbType = DatabaseSettings.get((String)"DatabaseType");
        String sqlFolder = Settings.getContextPath() + "WEB-INF" + File.separator + "sql";
        File[] files = new File(sqlFolder).listFiles();
        if (files != null) {
            String prefix = "update_" + version.replace(".", "") + "_";
            for (File script : files) {
                String filename = script.getName();
                if (!filename.startsWith(prefix) || !filename.endsWith(dbType + ".sql")) continue;
                return script;
            }
        }
        throw new FileNotFoundException("Script to update version " + version + " for database " + dbType + " was not found.");
    }

    private void execScript(Connection con, File script) throws IOException, SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(script), StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = in.readLine()) != null) {
                StringBuilder sqlBuilder = new StringBuilder();
                while (line != null && !line.trim().isEmpty()) {
                    sqlBuilder.append(line);
                    line = in.readLine();
                }
                String sql = sqlBuilder.toString();
                if (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (sql.trim().isEmpty()) continue;
                statements.add(sql);
            }
            LOGGER.info("Executing script {}", (Object)script);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Executing database " + script.getName().replace("_", " ").replace(".sql", ""));
            this.total = statements.size();
            this.currentProgress = 0;
            for (String statement : statements) {
                Statement s = con.createStatement();
                try {
                    LOGGER.info("Executing: {}", (Object)statement);
                    int rows = s.executeUpdate(statement);
                    LOGGER.info("Rows updated: {}", (Object)rows);
                    ++this.currentProgress;
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
        }
        LOGGER.info("Script complete.");
    }

    private static void repairPublications() {
        LOGGER.info("Repairing publications - to view progress see pageseeder/webapp/WEB-INF/state/logs/process/process.xlog");
        RepairPublicationsThread thread = RepairPublicationsThread.newInstance("system", null);
        ProcessManager manager = ProcessManager.getInstance();
        manager.prepareForStart((ProcessThread)thread, true);
        thread.updateStatus(ProcessStage.Status.INITIALISED, "Starting process");
        thread.process();
        manager.clearIfFinished(thread.getThreadID());
    }
}

