/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.InitializeThread;
import com.pageseeder.NotificationThread;
import com.pageseeder.base.changes.ChangesListener;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.publication.UpdateQueue;
import com.pageseeder.base.publication.UpdateThread;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.comment.ReminderThread;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.oauth.PersistentTokenPurgeThread;
import com.pageseeder.mail.IncomingMailHandler;
import com.pageseeder.mail.IncomingMailServer;
import com.pageseeder.publish.PublishScheduler;
import com.pageseeder.publisher.utils.FilesCleanerThread;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSHelpContent;
import com.pageseeder.search.flint.PSRequester;
import com.pageseeder.search.help.HelpIndexVersion;
import com.pageseeder.search.help.HelpIndexingThread;
import com.pageseeder.thread.BackgroundThreadsManager;
import com.pageseeder.webhook.manager.WebhookManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.sf.ehcache.CacheManager;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Initialize
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Initialize.class);
    private static final int TOKEN_PURGE_PERIOD = 86400000;
    public static InitializeThread initThread = null;
    private static final ScheduledExecutorService purgeScheduler = Executors.newScheduledThreadPool(1);

    public void contextInitialized(ServletContextEvent event) {
        try {
            ServletContext context = event.getServletContext();
            System.setProperty("pageseeder.ehcache", context.getRealPath("/") + "WEB-INF/state/cache/ehcache");
            Settings.init((ServletContext)context, (boolean)true);
            initThread = new InitializeThread(context);
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)initThread);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to initialize PageSeeder", (Throwable)e);
            Database.setError((String)("Failed to initialize PageSeeder: " + e.getMessage()));
        }
    }

    public static void startBackgroundThreads(ServletContext context) {
        BackgroundThreadsManager bm = BackgroundThreadsManager.getInstance();
        ChangesManager.registerListener((ChangesListener)UpdateQueue.singleton());
        bm.start((Runnable)new UpdateThread());
        PublishScheduler.reloadAllEvents(new File(context.getRealPath("/WEB-INF")));
        bm.start(PublishScheduler.getInstance().getThread());
        if (!"false".equals(GlobalSettings.getString((String)"notifyProcess", (String)"true"))) {
            bm.start(new NotificationThread());
        }
        if (!"false".equals(GlobalSettings.getString((String)"reminderNotification", (String)"false"))) {
            bm.start(new ReminderThread());
        }
    }

    public static void schedulePersistentTokenPurgeThread() {
        long now;
        long start = LocalDateTime.of(LocalDate.now(), LocalTime.of(3, 0)).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
        if (start < (now = System.currentTimeMillis())) {
            start += 86400000L;
        }
        purgeScheduler.scheduleAtFixedRate((Runnable)new PersistentTokenPurgeThread(), start - now, 86400000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForJDOPackageFile(String dbtype, String folder, ServletContext context) {
        dbtype = "MySQL".equals(dbtype) || "PostgreSQL".equals(dbtype) || Strings.isEmpty((String)dbtype) ? "mysql" : dbtype.toLowerCase();
        InputStream pckFile = Initialize.class.getResourceAsStream(folder + "/package-" + dbtype + ".jdo");
        try {
            if (pckFile == null || pckFile.available() <= 0) {
                throw new IllegalArgumentException("Failed to locate package file " + folder + "/package-" + dbtype + ".jdo");
            }
            String dir = context.getRealPath("/") + "WEB-INF/classes" + folder;
            File currentDir = new File(dir);
            if (!currentDir.exists() && !currentDir.mkdirs()) {
                throw new IllegalArgumentException("Failed to create folder " + folder);
            }
            File currentfile = new File(currentDir, "package.jdo");
            if (currentfile.exists()) {
                return;
            }
            if (!currentfile.createNewFile()) {
                throw new IllegalArgumentException("Failed to create new package file " + folder + "/package.jdo");
            }
            try (FileOutputStream fos = new FileOutputStream(currentfile);){
                int read;
                int bufferSize = 4096;
                byte[] buffer = new byte[4096];
                while ((read = pckFile.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not create " + folder + "/package.jdo file: " + ex.getMessage());
        }
        finally {
            if (pckFile != null) {
                try {
                    pckFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteIndexLockFiles(ServletContext context) {
        File[] indexes = new File(context.getRealPath("/"), "/WEB-INF/state/index").listFiles();
        for (int i = 0; indexes != null && i < indexes.length; ++i) {
            File index = indexes[i];
            if (!index.isDirectory()) continue;
            File[] locks = index.listFiles((dir, name) -> name.endsWith(".lock"));
            for (int j = 0; locks != null && j < locks.length; ++j) {
                if (locks[j].delete()) continue;
                LOGGER.warn("Could not delete index lock file for group {} (File is {}).", (Object)index.getName(), (Object)locks[j].getAbsolutePath());
            }
        }
    }

    public static void initMail() {
        try {
            IncomingMailServer.getInstance().start();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to start the mail server", (Throwable)ex);
        }
    }

    public static void stopMail() {
        try {
            IncomingMailServer.getInstance().stop();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to shut down the mail server", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        IncomingMailHandler.shutdown = true;
        WebhookManager.getInstance().stop();
        LOGGER.info("Webhook threads stopped");
        AccessTokenManager.singleton().destroy();
        CodeManager.singleton().destroy();
        ChallengeManager.singleton().destroy();
        purgeScheduler.shutdown();
        LOGGER.info("Publisher: Stopping file cleaners");
        FilesCleanerThread.stopAllFilesCleaner();
        LOGGER.info("Publisher: File cleaners stopped");
        BackgroundThreadsManager.getInstance().shutdown();
        ProcessManager.getInstance().shutdown();
        LOGGER.info("Process threads stopped");
        IndexMaster.getInstance().destroy();
        LOGGER.info("Index threads stopped");
        LOGGER.info("Flushing cache to disk");
        CacheManager.getInstance().shutdown();
        LOGGER.info("Completed flushing cache to disk");
        Database.closeAll();
        LOGGER.info("All database connections closed");
        if (!"false".equals(GlobalSettings.getString((String)"mailServer", (String)"true"))) {
            Initialize.stopMail();
            LOGGER.info("Mail server stopped");
        }
    }

    public static void updateHelpIndex() {
        Instant currentVersion = HelpIndexVersion.getHelpIndexVersion();
        if (currentVersion != null) {
            Path helpRoot = PSHelpContent.CONTENT_ROOT.toPath();
            Instant filesVersion = Initialize.lastHelpModified(helpRoot);
            if (currentVersion.plus(5L, ChronoUnit.MINUTES).isBefore(filesVersion)) {
                long before = System.currentTimeMillis();
                LOGGER.info("Generating Help Index");
                IndexMaster master = IndexMaster.getInstance();
                List paths = HelpIndexingThread.listPSMLFiles((Path)helpRoot);
                IndexBatch batch = new IndexBatch("help/help/PageSeeder Initialise - index built-in help content", paths.size() + 1);
                master.clearHelpIndex(batch, new PSRequester("PageSeeder Initialise - clear built-in help index"));
                PSRequester requester = new PSRequester("PageSeeder Initialise - index built-in help content");
                for (String path : paths) {
                    if (master.indexHelpDocument(path, batch, requester)) continue;
                    LOGGER.warn("Failed to add {} to help index", (Object)path);
                }
                LOGGER.info("Help Index Content added {} documents to indexing queue in {}ms", (Object)paths.size(), (Object)(System.currentTimeMillis() - before));
            }
        }
    }

    public static Instant lastHelpModified(Path root) {
        MostRecent visitor = new MostRecent();
        try {
            Files.walkFileTree(root, visitor);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to walk tree to check of help has changed {}", (Object)ex.getMessage(), (Object)ex);
            LOGGER.error("YOU NEED TO INDEX THE HELP MANUALLY");
        }
        return visitor.get();
    }

    private static class MostRecent
    extends SimpleFileVisitor<Path> {
        FileTime mostRecent = FileTime.from(Instant.EPOCH);

        private MostRecent() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileTime lastModified = Files.getLastModifiedTime(file, new LinkOption[0]);
            if (lastModified.compareTo(this.mostRecent) > 0) {
                this.mostRecent = lastModified;
            }
            return FileVisitResult.CONTINUE;
        }

        public final Instant get() {
            return this.mostRecent.toInstant();
        }
    }
}

