/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.base.generator.Output;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.CORS;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.XRefLoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.ANY})
@PublicAPI(value=PublicAPI.Support.SUPPORTED)
public class Default
extends HttpServlet {
    private static final long serialVersionUID = 20180326L;
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(Default.class);
    private static final String ALLOWED_HTTP_METHODS = "GET, HEAD, OPTIONS";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String method;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ("GET".equals(method = req.getMethod())) {
            this.doGet(req, res);
        } else if ("HEAD".equals(method)) {
            this.doHead(req, res);
        } else if ("OPTIONS".equals(method)) {
            this.doOptions(req, res);
        } else if (req.getAttribute("com.pageseeder.layout") == Boolean.TRUE) {
            this.doGet(req, res);
        } else {
            this.handleBadRequest(req, res, "Only GET, HEAD and OPTIONS are supported", 405);
        }
    }

    /*
     * Exception decompiling
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 12 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Group getContextGroup(Database db, URI uri, @Nullable String groupname, Permissions perm) throws QueryFailedException, DatabaseException {
        Group cgroup = null;
        if (groupname != null) {
            cgroup = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
        }
        if (cgroup == null || !GroupRule.userHasAccess((Group)cgroup, (Permissions)perm)) {
            if (uri.getExternal().booleanValue()) {
                return GroupRule.getPublicGroup((Database)db);
            }
            cgroup = URIRule.getDefaultGroupForURI((URI)uri);
        }
        if (cgroup == null || !GroupRule.userHasAccess((Group)cgroup, (Permissions)perm)) {
            cgroup = URIRule.getGroupForURI((Database)db, (Long)uri.getId(), (Permissions)perm);
        }
        return cgroup;
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String origin = request.getHeader("Origin");
        if (origin != null && !origin.isEmpty()) {
            Database db;
            try {
                db = Database.open();
            }
            catch (OpenDatabaseException ex) {
                this.handleError(request, response, ex, "Unable to open database connection", 502);
                return;
            }
            Transaction tr = new Transaction(db);
            try {
                tr.begin();
                if (CORS.isAcceptableOrigin((String)origin, (Database)db)) {
                    response.setHeader("Access-Control-Allow-Origin", HttpRequests.toSafeHeader((String)origin));
                    response.setHeader("Access-Control-Allow-Methods", ALLOWED_HTTP_METHODS);
                    response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type");
                    response.setHeader("Access-Control-Expose-Headers", "Etag, Content-Disposition");
                    response.setIntHeader("Access-Control-Max-Age", 3600);
                    response.setIntHeader("Content-Length", 0);
                } else {
                    response.setHeader("Allow", ALLOWED_HTTP_METHODS);
                }
                tr.commit();
            }
            catch (StartTransactionException ex) {
                this.handleError(request, response, ex, "Unable to start transaction", 502);
            }
            catch (DatabaseException ex) {
                this.handleError(request, response, ex, "Database exception occurred", 502);
                tr.abort();
            }
            finally {
                db.close();
            }
        } else {
            response.setHeader("Allow", ALLOWED_HTTP_METHODS);
        }
    }

    private String getParameter(HttpServletRequest req, String name) {
        String res = req.getParameter(name);
        if (res == null && "path".equals(name)) {
            name = "docPath";
            res = req.getParameter(name);
        }
        if (res == null) {
            res = req.getParameter("ps-" + name);
        }
        return res;
    }

    public boolean handleCacheHeaders(HttpServletRequest req, HttpServletResponse res, Database db, long modified, Publication publication) throws DatabaseException {
        long modified_since;
        boolean content = true;
        if (modified == 0L) {
            return true;
        }
        long last_modified = this.calculateLastModified(db, modified, publication);
        String cur_etag = MD5.hash((String)Long.toString(last_modified));
        String none_match = req.getHeader("If-None-Match");
        if (none_match != null) {
            String[] etags;
            for (String etag : etags = none_match.split(",")) {
                if ((etag = etag.trim()).startsWith("W/") || etag.length() <= 2 || !(etag = etag.substring(1, etag.length() - 1)).equals(cur_etag)) continue;
                res.setStatus(304);
                content = false;
            }
        }
        if ((modified_since = req.getDateHeader("If-Modified-Since")) != -1L && content && last_modified <= modified_since + 1000L) {
            res.setStatus(304);
            content = false;
        }
        if (!content) {
            res.setHeader("ETag", "\"" + cur_etag + "\"");
            res.setDateHeader("Last-Modified", last_modified);
        }
        return content;
    }

    private long calculateLastModified(@Nullable Database db, long last_modified, @Nullable Publication publication) throws DatabaseException {
        if (db != null && publication != null && publication.getXLinkId() != -1L) {
            try {
                NumberedTOC toc = PublicationManager.singleton().getNumberedTOC(db, publication, true);
                return Math.max(toc.getLastUpdated().getTime(), last_modified);
            }
            catch (XRefLoopException ex) {
                LOGGER.warn("Unable to calculate last modified: {}", (Object)ex.getMessage());
            }
        }
        return last_modified;
    }

    private void setCacheHeaders(HttpServletResponse res, @Nullable Database db, @Nullable Group group, @Nullable Publication publication, boolean hasTransclusions, long modified) throws DatabaseException {
        if (modified == 0L || hasTransclusions) {
            res.setHeader("Cache-Control", "no-cache");
            return;
        }
        long last_modified = this.calculateLastModified(db, modified, publication);
        String cur_etag = MD5.hash((String)Long.toString(last_modified));
        if (db != null && group != null && publication != null && !group.getId().equals(publication.getDefaultGroupId()) && !XLinkRule.belongsToGroup((XLink)DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId()), (Group)group)) {
            res.setHeader("Cache-Control", "private, must-revalidate");
        } else {
            res.setHeader("Cache-Control", "must-revalidate");
        }
        res.setHeader("ETag", "\"" + cur_etag + "\"");
        res.setDateHeader("Last-Modified", last_modified);
    }

    public void setDownloadHeaders(HttpServletRequest req, HttpServletResponse res, String filename) {
        if ("true".equals(req.getParameter("psml")) && filename != null && !((String)filename).toLowerCase().endsWith(".psml")) {
            filename = (String)filename + ".psml";
        }
        if ("download".equals(req.getParameter("behavior"))) {
            res.setHeader("Content-Disposition", HttpRequests.toSafeHeader((String)("attachment; filename=\"" + (String)filename + "\"")));
        } else {
            res.setHeader("Content-Disposition", HttpRequests.toSafeHeader((String)("inline; filename=\"" + (String)filename + "\"")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(InputStream ins, OutputStream outs) throws IOException {
        try {
            byte[] buff = new byte[4096];
            boolean reading = true;
            while (reading) {
                int i = ins.read(buff, 0, 4096);
                if (i > 0) {
                    outs.write(buff, 0, i);
                }
                if (i == 4096) continue;
                reading = false;
            }
        }
        finally {
            ins.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(CharBuffer cb, OutputStream outs) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(outs, StandardCharsets.UTF_8);
        try {
            while (cb.hasRemaining()) {
                w.write(cb.get());
            }
        }
        finally {
            w.flush();
        }
    }

    private void handleError(HttpServletRequest req, HttpServletResponse res, @Nullable Throwable ex, String message, int code) throws IOException {
        req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
        req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getServletConfig().getServletName());
        req.setAttribute("javax.servlet.error.exception", (Object)ex);
        if (ex != null) {
            LOGGER.error(message + ": " + ex.getMessage(), ex);
        } else {
            LOGGER.error(message);
        }
        res.sendError(code, message + (String)(ex != null ? ":" + ex.getMessage() : ""));
    }

    private void handleBadRequest(HttpServletRequest req, HttpServletResponse res, String message, int code) throws IOException {
        req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
        req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getServletConfig().getServletName());
        res.sendError(code, message);
    }

    private void handleUriFetcherError(URIFetcher uri_fetch, HttpServletResponse res) throws Exception {
        if (uri_fetch.getStatus() != URIFetcherStatus.RESPONSE_RETURNED && !uri_fetch.getURIString().endsWith("/index.psml")) {
            LOGGER.warn("URIFetcher Status: {} Message: {}", (Object)uri_fetch.getStatus(), (Object)uri_fetch.getStatusMessage());
            if (uri_fetch.getStatus() == URIFetcherStatus.NOT_FOUND) {
                res.sendError(404, uri_fetch.getStatusMessage());
            } else {
                res.sendError(500, uri_fetch.getStatusMessage());
            }
        }
    }

    protected URI getURI(Database db, String host, String path) throws Exception {
        path = URLCoder.encode((String)URLCoder.decode((String)path)).replaceAll("%2F", "/");
        return DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)Settings.getDocumentScheme(), (String)HostRule.resolveAlias((Database)db, (String)host), (Integer)Settings.getDocumentPort(), (String)path);
    }

    protected String getURIString(String path, HttpServletRequest req) {
        return URIRule.getURIString((String)Settings.getDocumentScheme(), (String)req.getServerName(), (Integer)Settings.getDocumentPort(), (String)path);
    }

    public String getServletInfo() {
        return "Serves documents to users.";
    }
}

