/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.IOException;
import java.util.Map;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.LinearScore;
import org.pageseeder.smith.function.ScoreArray;

public final class RepeatedCharRule
implements PasswordRule,
Scriptable {
    private ScoreFunction _function = LinearScore.IDENTITY;

    @Override
    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int count = 0;
        StringBuilder unique = new StringBuilder();
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (unique.indexOf(String.valueOf(c)) >= 0) {
                ++count;
                continue;
            }
            unique.append(c);
        }
        return this._function.get(count);
    }

    @Override
    public void configure(Map<String, String> config) {
        this._function = ScoreArray.parse(config);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (p) {");
        script.append(" var f = ");
        this._function.toScript(script).append(";");
        script.append(" var n = 0;");
        script.append(" var u = '';");
        script.append(" if (p) {for (var i = 0; i < p.length; i++) {");
        script.append("  if (u.indexOf(p.charAt(i)) === -1) { u += p.charAt(i); } else { n++; }");
        script.append(" }}");
        script.append(" return f(n);");
        script.append("}");
        return script;
    }
}

