/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.IOException;
import java.util.Map;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.LinearScore;
import org.pageseeder.smith.function.ScoreArray;

public final class MixedCharRule
implements PasswordRule,
Scriptable {
    private ScoreFunction _function = LinearScore.IDENTITY;

    @Override
    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int letter = 0;
        int digit = 0;
        int other = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                letter = 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                digit = 1;
                continue;
            }
            other = 1;
        }
        int mixed = letter + digit + other;
        return this._function.get(mixed);
    }

    @Override
    public void configure(Map<String, String> config) {
        this._function = ScoreArray.parse(config);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (p) {");
        script.append(" var f = ");
        this._function.toScript(script).append(";");
        script.append(" var r = p && (/[a-zA-Z]/.test(p)? 1 : 0) + (/[0-9]/.test(p)? 1 : 0) + (/[^a-zA-Z0-9]/.test(p)? 1 : 0);");
        script.append(" return p? f(r) : f(0);");
        script.append("}");
        return script;
    }
}

