/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.IOException;
import java.util.Map;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.LinearScore;
import org.pageseeder.smith.function.ScoreArray;

public final class MixedCaseRule
implements PasswordRule,
Scriptable {
    private ScoreFunction _function = LinearScore.IDENTITY;

    @Override
    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int lower = 0;
        int upper = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (c >= 'a' && c <= 'z') {
                ++lower;
                continue;
            }
            if (c < 'A' || c > 'Z') continue;
            ++upper;
        }
        int mixed = Math.min(lower, upper);
        return this._function.get(mixed);
    }

    @Override
    public void configure(Map<String, String> config) {
        this._function = ScoreArray.parse(config);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (p) {");
        script.append(" var f = ");
        this._function.toScript(script).append(";");
        script.append(" var l = p? p.length - p.replace(/[a-z]/g, '').length : 0;");
        script.append(" var u = p? p.length - p.replace(/[A-Z]/g, '').length : 0;");
        script.append(" return f(Math.min(l,u));");
        script.append("}");
        return script;
    }
}

