/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.smith.PasswordRule;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PasswordConfig {
    private static PasswordConfig defaultConfig = null;
    private final int[] _thresholds;
    private final String[] _levels;
    private List<PasswordRule> _rules;

    protected PasswordConfig(SortedMap<Integer, String> levels, List<PasswordRule> rules) {
        this._thresholds = new int[levels.size()];
        this._levels = new String[levels.size()];
        int i = 0;
        for (Map.Entry<Integer, String> e : levels.entrySet()) {
            this._thresholds[i] = e.getKey();
            this._levels[i] = e.getValue();
            ++i;
        }
        this._rules = rules;
    }

    public String getLevel(int score) {
        int i = -1;
        for (int threshold : this._thresholds) {
            if (score < threshold) break;
            ++i;
        }
        return this._levels[i];
    }

    public int getThreshold(String level) {
        if (level == null) {
            throw new NullPointerException("Level cannot be null");
        }
        int i = this.getLevelIndex(level);
        if (i >= 0) {
            return this._thresholds[i];
        }
        throw new IllegalArgumentException("Undefined level '" + level + "'");
    }

    public boolean isDefined(String level) {
        return this.getLevelIndex(level) != -1;
    }

    public List<String> levels() {
        return Arrays.asList(this._levels);
    }

    public List<PasswordRule> rules() {
        return this._rules;
    }

    private int getLevelIndex(String level) {
        if (level == null) {
            return -1;
        }
        for (int i = 0; i < this._levels.length; ++i) {
            if (!this._levels[i].equals(level)) continue;
            return i;
        }
        return -1;
    }

    public static PasswordConfig defaultConfig() {
        if (defaultConfig == null) {
            ClassLoader loader = PasswordConfig.class.getClassLoader();
            try {
                InputStream in = loader.getResourceAsStream("org/pageseeder/smith/config.xml");
                InputSource source = new InputSource(in);
                defaultConfig = PasswordConfig.load(source);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return defaultConfig;
    }

    public static PasswordConfig load(File file) {
        FileInputStream in = null;
        PasswordConfig config = null;
        try {
            in = new FileInputStream(file);
            InputSource source = new InputSource(in);
            config = PasswordConfig.load(source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return config;
    }

    public static PasswordConfig load(InputSource source) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ConfigHandler handler = new ConfigHandler();
            parser.parse(source, (DefaultHandler)handler);
            return new PasswordConfig(handler.levels, handler.rules);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private SortedMap<Integer, String> levels = new TreeMap<Integer, String>();
        private List<PasswordRule> rules = new ArrayList<PasswordRule>();
        private Map<String, String> properties = null;

        private ConfigHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String element = qName;
            if ("levels".equals(element)) {
                this.levels.put(Integer.MIN_VALUE, atts.getValue("default"));
                return;
            } else if ("level".equals(element)) {
                Integer threshold = Integer.valueOf(atts.getValue("threshold"));
                this.levels.put(threshold, atts.getValue("name"));
                return;
            } else if ("rule".equals(element)) {
                String className = atts.getValue("class");
                if (className.indexOf(46) < 0) {
                    className = "org.pageseeder.smith.rule." + className;
                }
                try {
                    Class<?> c = Class.forName(className);
                    Object o = c.newInstance();
                    if (!(o instanceof PasswordRule)) return;
                    PasswordRule rule = (PasswordRule)o;
                    this.rules.add(rule);
                    return;
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            } else {
                if (!"property".equals(element)) return;
                String name = atts.getValue("name");
                String value = atts.getValue("value");
                if (this.properties == null) {
                    this.properties = new HashMap<String, String>();
                }
                this.properties.put(name, value);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String element = qName;
            if ("rule".equals(element)) {
                PasswordRule rule = this.rules.get(this.rules.size() - 1);
                rule.configure(this.properties);
                this.properties = null;
            }
        }
    }
}

