/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.utils;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.search.queries.PageSeederQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryVisitor;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PSHighlighter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSHighlighter.class);
    private static final Pattern PHRASES_AND_WORDS = Pattern.compile("\\\"[^\\\"]+\\\"|[^()\\s]+");
    private static final Pattern NOT_WORD = Pattern.compile("[()\\\"\\s]");
    private final Collection<String> words;
    private final Collection<String> fields;

    public PSHighlighter(IndexSearcher searcher, SearchQuery query, @Nullable Collection<String> extractFields) {
        Question q;
        if (query instanceof PageSeederQuery && (q = ((PageSeederQuery)query).question()) != null) {
            Collection<Object> collection = this.words = q.isEmpty() ? Collections.emptyList() : PSHighlighter.words(q.question());
            this.fields = extractFields != null ? extractFields : (q.isEmpty() ? Collections.emptyList() : q.fields());
            return;
        }
        HashSet terms = new HashSet();
        try {
            query.toQuery().rewrite(searcher.getIndexReader()).visit(QueryVisitor.termCollector(terms));
        }
        catch (Exception ex) {
            LOGGER.warn("Computing extract failed, no extracts will be provided", (Throwable)ex);
        }
        this.words = new ArrayList<String>();
        this.fields = extractFields != null ? extractFields : new ArrayList();
        for (Term t : terms) {
            if (!this.words.contains(t.text())) {
                this.words.add(t.text());
            }
            if (this.fields.contains(t.field()) || extractFields != null) continue;
            this.words.add(t.field());
        }
    }

    public void extract(Document doc, OutputPrinter out) {
        for (String field : this.fields) {
            IndexableField f = doc.getField(field);
            if (f == null) continue;
            String value = Fields.toString((IndexableField)f);
            for (String word : this.words) {
                String extract = Documents.extract((String)value, (String)word, (int)200);
                if (extract == null) continue;
                out.startObject("extract");
                out.field("name", field);
                out.field("extract", extract, OutputPrinter.FieldOption.XML_COPY);
                out.endObject();
                return;
            }
        }
    }

    protected static Collection<String> words(String text) {
        if (!NOT_WORD.matcher(text.trim()).find()) {
            return Collections.singletonList(text.trim());
        }
        if (Queries.isAPhrase((String)text)) {
            return Collections.singletonList(text.substring(1, text.length() - 1));
        }
        ArrayList<String> words = new ArrayList<String>();
        Matcher m = PHRASES_AND_WORDS.matcher(text);
        while (m.find()) {
            String g = m.group().trim();
            if (Queries.isAPhrase((String)g)) {
                words.add(g.substring(1, g.length() - 1));
                continue;
            }
            if ("AND".equals(g) || "OR".equals(g)) continue;
            words.add(g);
        }
        return words;
    }
}

