/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.url;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import java.util.ArrayList;
import java.util.Iterator;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLIndexingThread
extends ProcessThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLIndexingThread.class);
    private boolean clearFirst = false;
    private int total = 0;
    private int alreadyDone = 0;
    private final IndexBatch batch = new IndexBatch("urls/urls/Indexing URLs");
    private final PSRequester requester = new PSRequester("Indexing URLs");

    private URLIndexingThread(String username) {
        super(username, "URL indexing", null);
    }

    public void setClearFirst(boolean clear) {
        this.clearFirst = clear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() {
        try {
            Catalog urlsCat;
            Database db;
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing objects to index");
            ArrayList<Long> urls = new ArrayList<Long>();
            try {
                db = Database.open();
                int count = 0;
                for (URI uri : DatabaseQuery.getExternalURIsByType((Database)db, null)) {
                    if (URIs.canBeIndexedAsURL((URI)uri)) {
                        urls.add(uri.getId());
                    }
                    if (++count % 100 != 0 || !this.wasCancelled()) continue;
                    db.close();
                    return;
                }
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to query database for URLs to index", (Throwable)ex);
                this.fail("Failed to query database for URLs to index: " + ex.getMessage());
                this.complete("Finished adding objects to the indexing queue");
                return;
            }
            {
                db.close();
            }
            if (this.wasCancelled()) {
                return;
            }
            this.total = urls.isEmpty() ? 0 : urls.size() + (this.clearFirst ? 1 : 0);
            this.batch.increaseTotal(this.total);
            this.batch.setComputed();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + urls.size() + " documents to index");
            if (urls.isEmpty()) {
                this.complete("Nothing to index!");
                return;
            }
            IndexMaster master = IndexMaster.getInstance();
            if (this.clearFirst) {
                master.clearURLsIndex(this.batch, this.requester);
            }
            if ((urlsCat = Catalogs.getCatalog((String)"urls")) != null) {
                urlsCat.clear();
            }
            Iterator iterator = urls.iterator();
            do {
                if (!iterator.hasNext()) return;
                Long id = (Long)iterator.next();
                master.indexURL(id, false, this.batch, this.requester);
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Added URL " + id + " to indexing queue");
                ++this.alreadyDone;
            } while (!this.wasCancelled());
            return;
        }
        finally {
            this.complete("Finished adding objects to the indexing queue");
        }
    }

    public static URLIndexingThread newInstance(String username) {
        return new URLIndexingThread(username);
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("indexing");
        out.startObject("progress");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.endObject();
        out.endObject();
    }
}

