/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.help;

import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.help.HelpIndex;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpIndexVersion
implements SearchQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpIndexVersion.class);

    public static @Nullable Instant getHelpIndexVersion() {
        HelpIndex index = IndexMaster.getInstance().getHelpIndex();
        if (index == null) {
            return null;
        }
        HelpIndexVersion query = new HelpIndexVersion();
        try {
            SearchResults results = LuceneIndexQueries.query((Index)index, (SearchQuery)query, (SearchPaging)new SearchPaging(1, 1));
            if (results.isEmpty()) {
                return Instant.EPOCH;
            }
            Document result = results.getDocument(results.getScoreDoc()[0].doc);
            String lastModified = result.get("pshelplastmodified");
            if (lastModified == null) {
                return Instant.EPOCH;
            }
            return LocalDateTime.from(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").parse(lastModified)).toInstant(OffsetDateTime.now().getOffset());
        }
        catch (NumberFormatException | IndexException ex) {
            LOGGER.error("Failed to retrieve help index version", ex);
            return null;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public Query toQuery() {
        return new MatchAllDocsQuery();
    }

    public Sort getSort() {
        return new Sort(new SortField[]{new SortField("psmodifieddate", SortField.Type.STRING, true)});
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.emptyElement("index-version-query");
    }
}

