/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint.tika;

import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.xml.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaTranslator
implements ContentTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TikaTranslator.class);
    private static final SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private static @Nullable TikaConfig tikaConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Reader translate(Content content) throws IndexException {
        if (content.isDeleted()) {
            return null;
        }
        try {
            LOGGER.debug("Attempting to translate content {}", (Object)content);
            Metadata metadata = new Metadata();
            Object xmlContent = null;
            TikaInputStream stream = null;
            File f = content.getFile();
            if (f != null) {
                int maxSize = GlobalSettings.getInt((String)"maxIndexingSize", (int)30000000);
                if (f.length() <= (long)maxSize) {
                    stream = TikaInputStream.get((Path)f.toPath());
                }
            } else {
                stream = TikaInputStream.get((InputStream)content.getSource());
            }
            if (stream != null) {
                ParseContext context = new ParseContext();
                try {
                    try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                        if (tikaConfig == null) {
                            tikaConfig = TikaTranslator.newTikaConfig();
                        }
                        new AutoDetectParser(tikaConfig).parse((InputStream)stream, this.getHandler(out), metadata, context);
                        xmlContent = out.toString(StandardCharsets.UTF_8);
                    }
                    try {
                        List errors = XMLHelpers.validateWellFormednessReturnErrors((String)xmlContent);
                        if (errors != null && !errors.isEmpty()) {
                            LOGGER.warn("Invalid XML produced by TIKA for URI '{}'" + (String)(f != null ? " (" + f.getName() + ")" : ""), (Object)content.getContentID());
                            LOGGER.debug("Invalid XML is {}", xmlContent);
                            XMLStringWriter errorsXML = new XMLStringWriter(XML.NamespaceAware.No);
                            errorsXML.openElement("errors");
                            errorsXML.attribute("reason", "Invalid XML produced by TIKA");
                            for (String err : errors) {
                                errorsXML.element("error", err);
                            }
                            errorsXML.closeElement();
                            xmlContent = errorsXML.toString();
                        }
                    }
                    catch (SAXException ex) {
                        LOGGER.warn("Invalid XML produced by TIKA for URI '{}'" + (String)(f != null ? " (" + f.getName() + ")" : ""), (Object)content.getContentID(), (Object)ex);
                        LOGGER.debug("Invalid XML is {}", xmlContent);
                        xmlContent = "<error>Invalid XML produced by TIKA: " + XMLUtils.escapeText((String)ex.getMessage()) + "</error>";
                    }
                }
                catch (Throwable te) {
                    LOGGER.debug("Failed to parse content with TIKA", te);
                    LOGGER.warn("Could not index the metadata in URI '{}'" + (String)(f != null ? " (" + f.getName() + ")" : ""), (Object)content.getContentID(), (Object)te);
                    xmlContent = "<error>" + (te.getMessage() == null ? "Unknown error while reading content in TIKA" : XMLUtils.escapeText((String)te.getMessage())) + "</error>";
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            StringWriter sw = new StringWriter();
            XMLWriterImpl xml = new XMLWriterImpl((Writer)sw);
            xml.openElement("content");
            xml.attribute("source", "tika");
            if (xmlContent != null) {
                xml.writeXML(xmlContent);
            }
            xml.closeElement();
            return new StringReader(sw.toString());
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to translate content {}", (Object)content, (Object)ex);
            return null;
        }
    }

    private ContentHandler getHandler(OutputStream out) throws TransformerConfigurationException {
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("encoding", "UTF-8");
        handler.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
        handler.setResult(new StreamResult(out));
        return handler;
    }

    private static TikaConfig newTikaConfig() throws TikaException, IOException, SAXException {
        return new TikaConfig(TikaTranslator.class.getResourceAsStream("/com/pageseeder/search/tika-config.xml"));
    }

    static {
        try {
            tikaConfig = TikaTranslator.newTikaConfig();
        }
        catch (IOException | TikaException | SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

