/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint.log;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.search.GroupIndexReindexing;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;

public final class PSIndexListener
extends XLoggerAdaptor
implements IndexListener {
    public PSIndexListener() {
        super("Index");
    }

    public void warn(IndexJob job, String msg) {
        this.warn(new IndexEvent(EventType.INDEX, job, msg));
    }

    public void error(IndexJob job, String msg, Throwable throwable) {
        if (throwable instanceof IndexException && throwable.getCause() != null && throwable.getCause() instanceof TransformerException) {
            this.error(new IndexEvent(EventType.INDEX, job, msg), throwable.getCause());
        } else {
            this.error(new IndexEvent(EventType.INDEX, job, msg), throwable);
        }
    }

    public void endJob(IndexJob job) {
        if (job.wasSuccessful()) {
            if (job.getContentType() != PSContentType.TASK) {
                this.info(new IndexEvent(EventType.COMPLETE, job));
            }
        } else {
            this.error(new IndexEvent(EventType.FAIL, job));
        }
    }

    public void startJob(IndexJob job) {
        if (job.getContentType() != PSContentType.TASK) {
            this.info(new IndexEvent(EventType.START, job));
        }
    }

    public void startBatch(IndexBatch batch) {
        this.info(new IndexEvent(EventType.START, batch));
    }

    public void endBatch(IndexBatch batch) {
        this.info(new IndexEvent(EventType.COMPLETE, batch));
        String[] parts = batch.getIndex().split("/");
        if (parts.length != 0 && parts[0].matches("^\\d+$")) {
            Long groupid = Long.parseLong(parts[0]);
            if (GroupIndexReindexing.isReindexingBatch(groupid, batch.getID())) {
                IndexMaster master = IndexMaster.getInstance();
                if (GroupIndexReindexing.stopReindexing(groupid)) {
                    master.closeIndex(groupid);
                }
                Catalogs.save((String)master.getCatalog(groupid));
            }
        } else if (parts.length != 0 && "help".equals(parts[0])) {
            Catalogs.save((String)"help");
        }
    }

    private static final class IndexEvent
    implements XLoggable {
        private final EventType type;
        private final @Nullable IndexJob job;
        private final @Nullable IndexBatch batch;
        private final @Nullable String message;

        public IndexEvent(EventType type, IndexBatch batch) {
            this.type = type;
            this.job = null;
            this.batch = batch;
            this.message = null;
        }

        public IndexEvent(EventType type, IndexJob job) {
            this.type = type;
            this.job = job;
            this.batch = null;
            this.message = null;
        }

        public IndexEvent(EventType type, IndexJob job, String message) {
            this.type = type;
            this.job = job;
            this.batch = null;
            this.message = message;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[").append((Object)this.type).append(']');
            if (this.message != null) {
                out.append(" - ").append(this.message);
            }
            if (this.job != null) {
                out.append(" Requester=").append(this.job.getRequester().getRequesterID());
                out.append(" Index=").append(this.job.getIndex().getIndexID());
                out.append('/').append(((PSRequester)this.job.getRequester()).getGroupName());
                out.append(" Content=").append(IndexEvent.getContentID(this.job));
                out.append('/').append(this.job.getContentType().toString());
            } else if (this.batch != null) {
                out.append(" Batch=").append(this.batch.getID());
                if (this.batch.getIndex() != null) {
                    out.append(" Index=").append(this.batch.getIndex());
                }
                out.append(" Documents=").append(this.batch.getTotalDocuments());
                out.append(" Duration=").append(this.batch.getTotalDuration());
            }
            return out.toString();
        }

        public void toXMLLog(Appendable xml) throws IOException {
            xml.append("<job");
            xml.append(" type=\"").append(this.type.toString()).append('\"');
            if (this.job != null) {
                IndexEvent.attribute(xml, "process", this.job.getRequester().getRequesterID());
                if (this.job.getBatch() != null) {
                    IndexEvent.attribute(xml, "batch", this.job.getBatch().getID());
                }
                IndexEvent.attribute(xml, "index", this.job.getIndex().getIndexID());
                IndexEvent.attribute(xml, "contenttype", this.job.getContentType().toString());
                IndexEvent.attribute(xml, "contentid", IndexEvent.getContentID(this.job));
            } else if (this.batch != null) {
                IndexEvent.attribute(xml, "batch", this.batch.getID());
                IndexEvent.attribute(xml, "created", ISO8601.DATETIME.format(this.batch.getCreation().getTime()));
                IndexEvent.attribute(xml, "started", ISO8601.DATETIME.format(this.batch.getStart().getTime()));
                IndexEvent.attribute(xml, "computing", String.valueOf(this.batch.getComputingDuration()));
                IndexEvent.attribute(xml, "indexing", String.valueOf(this.batch.getIndexingDuration()));
                IndexEvent.attribute(xml, "documents", String.valueOf(this.batch.getTotalDocuments()));
                IndexEvent.attribute(xml, "total", String.valueOf(this.batch.getTotalDuration()));
            }
            if (this.message != null) {
                xml.append('>').append(XMLUtils.escapeText((String)this.message)).append("</job>");
            } else {
                xml.append(" />");
            }
        }

        public @Nullable Long getGroupID() {
            String id = IndexEvent.toGroupID(this.job, this.batch);
            return id != null ? Long.valueOf(id) : null;
        }

        public @Nullable String getGroup() {
            if (this.batch != null) {
                String[] parts;
                String indexName = this.batch.getIndex();
                if (indexName != null && indexName.indexOf(47) > 0 && (parts = indexName.split("/")).length > 1 && !"help".startsWith(parts[1]) && !"urls".startsWith(parts[1])) {
                    return parts[1];
                }
                return null;
            }
            return this.job == null ? null : ((PSRequester)this.job.getRequester()).getGroupName();
        }

        public @Nullable String getTicket() {
            if (this.batch != null) {
                return this.batch.getID();
            }
            if (this.job == null) {
                return null;
            }
            if (this.job.getBatch() != null) {
                return this.job.getBatch().getID();
            }
            return this.job.getRequester().getRequesterID();
        }

        public @Nullable String getUser() {
            return null;
        }

        public @Nullable String getTitle() {
            if (this.batch != null) {
                String[] parts;
                String indexName = this.batch.getIndex();
                if (indexName != null && indexName.indexOf(47) > 0 && (parts = indexName.split("/")).length > 1) {
                    return parts[2];
                }
                return "Batch Indexing";
            }
            return this.job == null ? null : ((PSRequester)this.job.getRequester()).getProcess();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable XLoggable.TYPE getType() {
            if (this.job != null && this.job.isBatch()) {
                return null;
            }
            if (this.type == EventType.START) {
                return XLoggable.TYPE.START;
            }
            if (this.type == EventType.COMPLETE || this.type == EventType.FAIL) {
                return XLoggable.TYPE.END;
            }
            return null;
        }

        private static void attribute(Appendable xml, String name, String value) throws IOException {
            xml.append(' ');
            xml.append(name).append('=').append('\"');
            xml.append(XMLUtils.escapeAttValue((String)value));
            xml.append('\"');
        }

        private static String getContentID(IndexJob job) {
            Long[] ids;
            if ("help".equals(job.getIndex().getIndexID())) {
                return job.getContentID();
            }
            ContentType ctype = job.getContentType();
            if ((ctype == PSContentType.URL || ctype == PSContentType.FOLDER || ctype == PSContentType.DOCUMENT) && (ids = IndexUtils.getURIContentIDs(job.getContentID())) != null) {
                return String.valueOf(ids[0]);
            }
            Long id = IndexUtils.getCommentContentID(job.getContentID());
            return id == null ? job.getContentID() : String.valueOf(id);
        }

        private static @Nullable String toGroupID(@Nullable IndexJob job, @Nullable IndexBatch batch) {
            if (batch != null) {
                String index = batch.getIndex();
                if (index != null) {
                    if (index.startsWith("help/") || index.equals("help") || index.startsWith("urls/") || index.equals("urls")) {
                        return null;
                    }
                    return index.split("/")[0];
                }
                return null;
            }
            if (job != null) {
                String indexID = job.getIndex().getIndexID();
                return "help".equals(indexID) || "urls".equals(indexID) ? null : indexID;
            }
            return null;
        }
    }

    private static enum EventType {
        START,
        INDEX,
        COMPLETE,
        FAIL;

    }
}

