/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.search.flint.DeleteRules;
import com.pageseeder.search.flint.PSContentType;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLContent.class);
    private final Long id;
    private final @Nullable Long releaseID;
    private final @Nullable Long groupID;
    private final boolean includeGroups;
    private boolean resolved = false;
    private boolean deleted = false;
    private @Nullable InputStream contentStream = null;
    private @Nullable String extraXML = null;

    public URLContent(Long id, @Nullable Long groupid, @Nullable Long releaseID, boolean includeGroups) {
        this.id = id;
        this.groupID = groupid;
        this.releaseID = releaseID;
        this.includeGroups = includeGroups;
    }

    public static URLContent deleteURLContent(Long id, Long releaseID) {
        return new URLContent(id, releaseID);
    }

    private URLContent(Long id, Long releaseID) {
        this.id = id;
        this.releaseID = releaseID;
        this.deleted = true;
        this.groupID = null;
        this.includeGroups = false;
    }

    public ContentType getContentType() {
        return PSContentType.URL;
    }

    public @Nullable File getFile() {
        return null;
    }

    public @Nullable String getExtraXML() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.extraXML;
    }

    public String getContentID() {
        return this.id.toString();
    }

    public @Nullable InputStream getSource() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        if (this.isDeleted()) {
            return null;
        }
        return this.contentStream;
    }

    public String getMediaType() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return "application/vnd.pageseeder.url+xml";
    }

    public boolean isDeleted() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.deleted;
    }

    public DeleteRule getDeleteRule() {
        if (this.releaseID != null) {
            return DeleteRules.newDeleteSingleURLReleaseQuery(this.id, this.releaseID);
        }
        if (this.deleted) {
            return DeleteRules.newDeleteAllURLReleasesQuery(this.id);
        }
        return DeleteRules.newURLDeleteRule(this.id);
    }

    public String toString() {
        return this.id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() throws IndexException {
        if (this.resolved) {
            return;
        }
        try {
            Database db = Database.open();
            Transaction tr = null;
            try {
                tr = new Transaction(db);
                tr.begin();
                URI uri = DatabaseQuery.getURIById((Database)db, (Long)this.id);
                if (!this.deleted) {
                    this.deleted = uri.isArchived();
                    if (!this.deleted && this.releaseID != null) {
                        XLink release = DatabaseQuery.getXLinkById((Database)db, (Long)this.releaseID);
                        boolean bl = this.deleted = release == null || XLinks.isArchived((XLink)release);
                    }
                }
                if (!this.deleted) {
                    Group group = this.groupID == null ? null : DatabaseQuery.getGroupById((Database)db, (Long)this.groupID);
                    DocumentContentResolver resolver = new DocumentContentResolver(this.id, group == null ? null : group.getName());
                    resolver.setPSMLFormat(true);
                    resolver.setReleaseId(this.releaseID);
                    this.contentStream = resolver.getContent(db);
                    if (group == null) {
                        XMLStringWriter extra = new XMLStringWriter(XML.NamespaceAware.No);
                        extra.openElement("extra");
                        extra.attribute("reversexref-count", DatabaseQuery.getXLinksCountByReverseXRefsURIAllGroups((Database)db, (Long)this.id).intValue());
                        if (this.includeGroups) {
                            Set groups = DatabaseQuery.getGroupsByURIReverseXRefsComments((Database)db, (Long)this.id);
                            for (Group agroup : groups) {
                                extra.openElement("group");
                                extra.attribute("name", agroup.getName());
                                extra.attribute("id", agroup.getId().toString());
                                extra.closeElement();
                            }
                        }
                        extra.closeElement();
                        this.extraXML = extra.toString();
                    }
                }
                tr.commit();
            }
            finally {
                if (tr != null) {
                    tr.abort();
                }
                db.close();
                db = null;
            }
        }
        catch (URIException ex) {
            throw new IndexException("Failed to resolve content because of a URI error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (DatabaseException ex) {
            throw new IndexException("Failed to resolve content because of a Database error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new IndexException("Failed to resolve content: " + ex.getMessage(), ex);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to resolve content", ex);
        }
        finally {
            this.resolved = true;
        }
    }
}

