/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CharacterUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.CharsRef;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class IndexAnalyzers {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexAnalyzers.class);
    private static final File WEBAPP = new File(Settings.getContextPath());
    private static final Map<String, Analyzer> CACHE = new HashMap<String, Analyzer>();

    private IndexAnalyzers() {
    }

    private static String ensureTemplate(@Nullable String template) {
        if (template != null) {
            return template;
        }
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        if (globalTemplate != null) {
            return globalTemplate;
        }
        return "default";
    }

    public static Analyzer getAnalyzer(@Nullable String ownerDir) throws IOException, SAXException {
        File synonyms;
        String template = IndexAnalyzers.ensureTemplate(ownerDir);
        if (CACHE.containsKey(template)) {
            return CACHE.get(template);
        }
        Template kit = new Template(template);
        File fields = TemplateFiles.getFile((Template)kit, (File)WEBAPP, (String)"index/fields.xml");
        if (fields == null || !fields.exists()) {
            if (!"default".equals(template)) {
                fields = TemplateFiles.getFile((Template)Template.DEFAULT, (File)WEBAPP, (String)"index/fields.xml");
            }
            if (fields == null || !fields.exists()) {
                throw new IOException("Missing file default/Index/fields.xml");
            }
        }
        if ((synonyms = TemplateFiles.getFile((Template)kit, (File)WEBAPP, (String)"index/synonyms.xml")) != null && !synonyms.exists()) {
            synonyms = null;
        }
        PSIndexAnalyzer analyzer = IndexAnalyzers.createAnalyzer(fields, synonyms);
        CACHE.put(template, (Analyzer)analyzer);
        return analyzer;
    }

    public static Analyzer cloneAnalyzerForQuery(Analyzer analyzer) {
        if (analyzer instanceof PSIndexAnalyzer) {
            return ((PSIndexAnalyzer)analyzer).cloneForQuery();
        }
        return analyzer;
    }

    public static Analyzer cloneAnalyzerKeepStopwords(Analyzer analyzer) {
        if (analyzer instanceof PSIndexAnalyzer) {
            return ((PSIndexAnalyzer)analyzer).cloneKeepStopWords();
        }
        return analyzer;
    }

    public static boolean isAnalyzerTokenizingField(Analyzer analyzer, String field) {
        if (analyzer instanceof PSIndexAnalyzer) {
            return ((PSIndexAnalyzer)analyzer).getWrappedAnalyzer((String)field).tokenized;
        }
        return true;
    }

    public static boolean isAnalyzerRemovingStopWordsField(Analyzer analyzer, String field) {
        if (analyzer instanceof PSIndexAnalyzer) {
            return ((PSIndexAnalyzer)analyzer).getWrappedAnalyzer((String)field).stopwords;
        }
        return true;
    }

    public static boolean isAnalyzerPrefixField(Analyzer analyzer, String field) {
        if (analyzer instanceof PSIndexAnalyzer) {
            return ((PSIndexAnalyzer)analyzer).getWrappedAnalyzer((String)field).prefixDelimiter != null;
        }
        return true;
    }

    public static void clearCachedAnalyzer(String ownerDir) {
        CACHE.remove(ownerDir);
    }

    static @Nullable File getSynonymFile(@Nullable String template) {
        if (template == null || "default".equals(template)) {
            return null;
        }
        return TemplateFiles.getFile((Template)new Template(template), (File)WEBAPP, (String)"index/synonyms.xml");
    }

    static void saveSynonyms(String ownerDir, Map<String, String> synonyms) throws IOException {
        File synonymsFile = IndexAnalyzers.getSynonymFile(ownerDir);
        if (synonymsFile == null) {
            throw new IOException("Failed to find synonyms file for owner directory " + ownerDir);
        }
        if (!synonymsFile.exists()) {
            synonymsFile.getParentFile().mkdirs();
            if (!synonymsFile.createNewFile()) {
                throw new IOException("Failed to create synonyms file for owner directory " + ownerDir);
            }
        }
        try (FileWriter out = new FileWriter(synonymsFile);){
            XMLWriterImpl xml = new XMLWriterImpl((Writer)out);
            xml.openElement("synonyms");
            for (Map.Entry<String, String> synonym : synonyms.entrySet()) {
                xml.openElement("word");
                xml.attribute("value", synonym.getKey());
                xml.attribute("synonyms", synonym.getValue());
                xml.closeElement();
            }
            xml.closeElement();
        }
        CACHE.remove(ownerDir);
    }

    private static PSIndexAnalyzer createAnalyzer(File fields, @Nullable File synonyms) throws IOException, SAXException {
        DefaultHandler handler;
        XMLReader parser;
        SynonymMap synonymsMap = null;
        if (synonyms != null) {
            try {
                parser = XMLHelpers.safeXMLReader();
                handler = new SynonymHandler();
                parser.setContentHandler(handler);
                parser.parse(new InputSource(synonyms.toURI().toString()));
                synonymsMap = ((SynonymHandler)handler).getSynonyms();
            }
            catch (SAXException ex) {
                LOGGER.warn("Error occurred while parsing synonyms XML file.", (Throwable)ex);
            }
        }
        try {
            parser = XMLHelpers.safeXMLReader();
            handler = new Handler(synonymsMap);
            parser.setContentHandler(handler);
            parser.parse(new InputSource(fields.toURI().toString()));
            return ((Handler)handler).analyzer;
        }
        catch (SAXException ex) {
            LOGGER.warn("Error occurred while parsing fields XML file.", (Throwable)ex);
            throw ex;
        }
    }

    private static final class FilenameTokenizer
    extends Tokenizer {
        private static final int BUFFER_SIZE = 8192;
        private int offset = 0;
        private int bufferIndex = 0;
        private int dataLen = 0;
        private int finalOffset = 0;
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final CharacterUtils.CharacterBuffer ioBuffer = CharacterUtils.newCharacterBuffer((int)8192);
        private int extensionOffset = -1;
        private int extensionLength = -1;
        private boolean extensionReached = false;
        private boolean extensionDone = false;

        private FilenameTokenizer() {
        }

        int normalize(int c) {
            return c;
        }

        public boolean incrementToken() throws IOException {
            this.clearAttributes();
            int length = 0;
            int start = -1;
            int end = -1;
            char[] buffer = this.termAtt.buffer();
            boolean extensionAtStart = false;
            if (this.extensionReached && !this.extensionDone) {
                if (this.extensionLength >= buffer.length - 1) {
                    buffer = this.termAtt.resizeBuffer(this.extensionLength);
                }
                for (int i = this.extensionOffset; i < this.extensionOffset + this.extensionLength; ++i) {
                    int c = Character.codePointAt(this.ioBuffer.getBuffer(), i, this.ioBuffer.getLength());
                    length += Character.toChars(this.normalize(c), buffer, length);
                }
                this.termAtt.setLength(this.extensionLength);
                this.finalOffset = this.correctOffset(this.extensionOffset + this.extensionLength);
                this.offsetAtt.setOffset(this.correctOffset(this.extensionOffset), this.finalOffset);
                this.extensionDone = true;
                return true;
            }
            while (true) {
                if (this.bufferIndex >= this.dataLen) {
                    if (this.extensionOffset != -1 && !this.extensionDone) {
                        this.extensionReached = true;
                        break;
                    }
                    this.offset += this.dataLen;
                    CharacterUtils.fill((CharacterUtils.CharacterBuffer)this.ioBuffer, (Reader)this.input);
                    if (this.ioBuffer.getLength() == 0) {
                        this.dataLen = 0;
                        if (length <= 0) {
                            if (!this.extensionDone) {
                                this.finalOffset = this.correctOffset(this.offset);
                            }
                            return false;
                        }
                        break;
                    }
                    this.dataLen = this.ioBuffer.getLength();
                    this.bufferIndex = 0;
                    if (this.dataLen < 8192) {
                        for (int backwardsCounter = this.dataLen - 1; backwardsCounter >= 0; --backwardsCounter) {
                            int c = Character.codePointAt(this.ioBuffer.getBuffer(), backwardsCounter, this.ioBuffer.getLength());
                            if (c != 46) continue;
                            if (backwardsCounter == this.dataLen - 1) break;
                            if (backwardsCounter == 0) {
                                extensionAtStart = true;
                                this.extensionDone = true;
                                break;
                            }
                            this.extensionOffset = backwardsCounter;
                            this.extensionLength = this.dataLen - backwardsCounter;
                            this.dataLen = backwardsCounter;
                            break;
                        }
                    }
                }
                int c = Character.codePointAt(this.ioBuffer.getBuffer(), this.bufferIndex, this.ioBuffer.getLength());
                int charCount = Character.charCount(c);
                this.bufferIndex += charCount;
                if (Character.isLetterOrDigit(c) || extensionAtStart) {
                    if (length == 0) {
                        end = start = this.offset + this.bufferIndex - charCount;
                    } else if (length >= buffer.length - 1) {
                        buffer = this.termAtt.resizeBuffer(2 + length);
                    }
                    end += charCount;
                    length += Character.toChars(this.normalize(c), buffer, length);
                    continue;
                }
                if (length > 0) break;
            }
            if (start == -1) {
                return this.incrementToken();
            }
            this.termAtt.setLength(length);
            this.finalOffset = this.correctOffset(end);
            this.offsetAtt.setOffset(this.correctOffset(start), this.finalOffset);
            return true;
        }

        public void end() throws IOException {
            super.end();
            this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
        }

        public void reset() throws IOException {
            super.reset();
            this.bufferIndex = 0;
            this.offset = 0;
            this.dataLen = 0;
            this.finalOffset = 0;
            this.ioBuffer.reset();
            this.extensionLength = -1;
            this.extensionOffset = -1;
            this.extensionReached = false;
            this.extensionDone = false;
        }
    }

    private static final class PrefixTokenizer
    extends Tokenizer {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        private final String delimiter;
        private final boolean alwaysPrefix;
        private boolean delimiterSearched = false;
        private final StandardTokenizerImpl scanner;
        private int prefixLength = -1;
        private int finalOffset = -1;

        PrefixTokenizer(String del, boolean always) {
            this.delimiter = del;
            this.alwaysPrefix = always;
            this.scanner = new StandardTokenizerImpl(this.input);
        }

        public boolean incrementToken() throws IOException {
            int tokenType;
            this.clearAttributes();
            if (!this.delimiterSearched) {
                char[] buffer = new char[1024];
                int read = this.input.read(buffer);
                if (read <= 0) {
                    return false;
                }
                this.delimiterSearched = true;
                String content = new String(buffer, 0, read);
                int delimiterIndex = content.indexOf(this.delimiter);
                if (delimiterIndex > 0) {
                    String prefix = content.substring(0, delimiterIndex);
                    this.prefixLength = prefix.length();
                    this.termAtt.append(prefix);
                    this.offsetAtt.setOffset(this.correctOffset(0), this.correctOffset(this.prefixLength));
                    this.typeAtt.setType("<ALPHANUM>");
                    this.scanner.yyreset((Reader)new StringReader(content.substring(delimiterIndex + this.delimiter.length())));
                    this.finalOffset = this.prefixLength + this.delimiter.length();
                    return true;
                }
                if (delimiterIndex == 0) {
                    this.prefixLength = 0;
                    this.finalOffset = this.delimiter.length();
                    this.scanner.yyreset((Reader)new StringReader(content.substring(this.delimiter.length())));
                } else {
                    if (this.alwaysPrefix) {
                        this.finalOffset = this.prefixLength = content.length();
                        this.termAtt.append(content);
                        this.offsetAtt.setOffset(this.correctOffset(0), this.correctOffset(content.length()));
                        this.typeAtt.setType("<ALPHANUM>");
                        return true;
                    }
                    this.scanner.yyreset((Reader)new StringReader(content));
                    this.finalOffset = content.length();
                }
            }
            if ((tokenType = this.scanner.getNextToken()) == -1) {
                return false;
            }
            this.scanner.getText(this.termAtt);
            int start = this.scanner.yychar();
            if (this.prefixLength >= 0) {
                start += this.prefixLength + this.delimiter.length();
            }
            this.finalOffset = this.correctOffset(start + this.termAtt.length());
            this.offsetAtt.setOffset(this.correctOffset(start), this.finalOffset);
            this.typeAtt.setType(StandardTokenizer.TOKEN_TYPES[tokenType]);
            return true;
        }

        public void end() throws IOException {
            super.end();
            if (this.finalOffset >= 0) {
                this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
            }
        }

        public void close() throws IOException {
            super.close();
            this.scanner.yyreset(this.input);
            this.delimiterSearched = false;
            this.prefixLength = -1;
            this.finalOffset = -1;
        }

        public void reset() throws IOException {
            super.reset();
            this.scanner.yyreset(this.input);
            this.delimiterSearched = false;
        }
    }

    private static final class SynonymHandler
    extends DefaultHandler {
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable SynonymMap.Builder builder = null;

        private SynonymHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("word".equals(localName)) {
                String word = attributes.getValue("value");
                String syns = attributes.getValue("synonyms");
                if (!Strings.isEmpty((String)word) && !Strings.isEmpty((String)syns)) {
                    if (this.builder == null) {
                        this.builder = new SynonymMap.Builder(false);
                    }
                    for (String synonym : syns.split(",")) {
                        this.builder.add(new CharsRef(word), new CharsRef(synonym), true);
                    }
                }
            }
        }

        @Nullable SynonymMap getSynonyms() {
            try {
                return this.builder == null ? null : this.builder.build();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to build synonyms map", (Throwable)ex);
                return null;
            }
        }
    }

    private static final class SynonymAnalyzer
    extends Analyzer {
        private final boolean filename;
        private final boolean tokenized;
        private final boolean stopwords;
        private final boolean lowercase;
        private final @Nullable String prefixDelimiter;
        private boolean delimiterForQuery = false;
        private final @Nullable SynonymMap synonyms;

        SynonymAnalyzer(boolean tokenized, boolean filename, boolean stopwords, boolean lowercase, @Nullable String prefixDelimiter, @Nullable SynonymMap synonyms) {
            this.tokenized = tokenized;
            this.filename = filename;
            this.lowercase = lowercase;
            this.stopwords = stopwords;
            this.prefixDelimiter = prefixDelimiter;
            this.synonyms = synonyms;
        }

        SynonymAnalyzer cloneKeepStopWords() {
            SynonymAnalyzer a = new SynonymAnalyzer(this.tokenized, this.filename, false, this.lowercase, this.prefixDelimiter, this.synonyms);
            a.delimiterForQuery = this.delimiterForQuery;
            return a;
        }

        SynonymAnalyzer cloneForQuery() {
            SynonymAnalyzer a = new SynonymAnalyzer(this.tokenized, this.filename, this.stopwords, this.lowercase, this.prefixDelimiter != null ? " " : null, this.synonyms);
            a.delimiterForQuery = true;
            return a;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            FilenameTokenizer results;
            FilenameTokenizer source = this.filename ? new FilenameTokenizer() : (!this.tokenized ? new KeywordTokenizer() : (this.prefixDelimiter != null ? new PrefixTokenizer(this.prefixDelimiter, this.delimiterForQuery) : new StandardTokenizer()));
            FilenameTokenizer filenameTokenizer = results = this.lowercase ? new LowerCaseFilter((TokenStream)source) : source;
            if (this.synonyms != null) {
                results = new SynonymFilter((TokenStream)results, this.synonyms, false);
            }
            if (this.stopwords) {
                results = new StopFilter((TokenStream)results, EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
            }
            if (this.tokenized) {
                results = new ASCIIFoldingFilter((TokenStream)results);
            }
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)results);
        }
    }

    protected static final class PSIndexAnalyzer
    extends AnalyzerWrapper {
        private final Map<String, SynonymAnalyzer> analyzers = new HashMap<String, SynonymAnalyzer>();
        private final Map<String, SynonymAnalyzer> startsWithAnalyzers = new HashMap<String, SynonymAnalyzer>();
        private final Map<String, SynonymAnalyzer> endsWithAnalyzers = new HashMap<String, SynonymAnalyzer>();
        private final SynonymAnalyzer nonAnalyzer;
        private final SynonymMap synonyms;

        PSIndexAnalyzer(SynonymMap syns) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.synonyms = syns;
            this.nonAnalyzer = new SynonymAnalyzer(false, false, false, false, null, null);
        }

        PSIndexAnalyzer cloneKeepStopWords() {
            PSIndexAnalyzer clone = new PSIndexAnalyzer(this.synonyms);
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.analyzers.entrySet()) {
                clone.analyzers.put(analyzer.getKey(), analyzer.getValue().cloneKeepStopWords());
            }
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.startsWithAnalyzers.entrySet()) {
                clone.analyzers.put(analyzer.getKey(), analyzer.getValue().cloneKeepStopWords());
            }
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.endsWithAnalyzers.entrySet()) {
                clone.analyzers.put(analyzer.getKey(), analyzer.getValue().cloneKeepStopWords());
            }
            return clone;
        }

        PSIndexAnalyzer cloneForQuery() {
            PSIndexAnalyzer clone = new PSIndexAnalyzer(this.synonyms);
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.analyzers.entrySet()) {
                clone.analyzers.put(analyzer.getKey(), analyzer.getValue().cloneForQuery());
            }
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.startsWithAnalyzers.entrySet()) {
                clone.analyzers.put(analyzer.getKey(), analyzer.getValue().cloneForQuery());
            }
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.endsWithAnalyzers.entrySet()) {
                clone.analyzers.put(analyzer.getKey(), analyzer.getValue().cloneForQuery());
            }
            return clone;
        }

        void addField(String name, boolean keyword, boolean filename, boolean lowercase, boolean withSynonyms, boolean stopwords, String prefixDelimiter) {
            SynonymAnalyzer a = new SynonymAnalyzer(!keyword, filename, stopwords, lowercase, prefixDelimiter, withSynonyms ? this.synonyms : null);
            if (name.startsWith("*")) {
                this.endsWithAnalyzers.put(name.substring(1), a);
            } else if (name.endsWith("*")) {
                this.startsWithAnalyzers.put(name.substring(0, name.length() - 1), a);
            } else {
                this.analyzers.put(name, a);
            }
        }

        protected SynonymAnalyzer getWrappedAnalyzer(String fieldName) {
            if (this.analyzers.containsKey(fieldName)) {
                return this.analyzers.get(fieldName);
            }
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.startsWithAnalyzers.entrySet()) {
                if (!fieldName.startsWith(analyzer.getKey())) continue;
                SynonymAnalyzer an = analyzer.getValue();
                this.analyzers.put(fieldName, analyzer.getValue());
                return an;
            }
            for (Map.Entry<String, SynonymAnalyzer> analyzer : this.endsWithAnalyzers.entrySet()) {
                if (!fieldName.endsWith(analyzer.getKey())) continue;
                SynonymAnalyzer an = analyzer.getValue();
                this.analyzers.put(fieldName, an);
                return an;
            }
            return this.nonAnalyzer;
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private final PSIndexAnalyzer analyzer;

        Handler(SynonymMap synonyms) {
            this.analyzer = new PSIndexAnalyzer(synonyms);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if ("field".equals(localName) || "field".equals(qName)) {
                String name = atts.getValue("name");
                boolean filename = "true".equals(atts.getValue("filename"));
                boolean keyword = !"false".equals(atts.getValue("keyword"));
                boolean synonyms = "true".equals(atts.getValue("synonyms"));
                boolean stopwords = "true".equals(atts.getValue("stop-words"));
                boolean lowercase = "true".equals(atts.getValue("case-insensitive"));
                String delimiter = atts.getValue("prefix-delimiter");
                this.analyzer.addField(name, keyword, filename, lowercase, synonyms, stopwords, delimiter);
            }
        }
    }
}

