/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.search.flint.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.lucene.LuceneDeleteRule;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public class DeleteRules {
    private DeleteRules() {
    }

    public static DeleteRule newFolderDeleteRule(Long uriid) {
        return DeleteRules.newDeleteRule(uriid, Collections.singletonList("folder"));
    }

    public static DeleteRule newURLDeleteRule(Long uriid) {
        return DeleteRules.newDeleteRule(uriid, Collections.singletonList("url"));
    }

    public static DeleteRule newDocumentDeleteRule(Long uriid) {
        return DeleteRules.newDeleteRule(uriid, Constants.DOCUMENT_PSTYPES);
    }

    public static DeleteRule newCommentDeleteRule(Long xlinkid) {
        return DeleteRules.newDeleteRule(xlinkid, Constants.COMMENT_PSTYPES);
    }

    public static DeleteRule newTaskDeleteRule(Long xlinkid) {
        return DeleteRules.newDeleteRule(xlinkid, Constants.TASK_PSTYPES);
    }

    public static DeleteRule newDeleteAllDocumentReleasesQuery(Long uriID) {
        return new LuceneDeleteRule((SearchQuery)new DeleteRuleQuery(uriID, null, true));
    }

    public static DeleteRule newDeleteSingleDocumentReleaseQuery(Long uriID, Long releaseID) {
        return new LuceneDeleteRule((SearchQuery)new DeleteRuleQuery(uriID, releaseID, true));
    }

    public static DeleteRule newDeleteAllURLReleasesQuery(Long uriID) {
        return new LuceneDeleteRule((SearchQuery)new DeleteRuleQuery(uriID, null, false));
    }

    public static DeleteRule newDeleteSingleURLReleaseQuery(Long uriID, Long releaseID) {
        return new LuceneDeleteRule((SearchQuery)new DeleteRuleQuery(uriID, releaseID, false));
    }

    private static DeleteRule newDeleteRule(Long id, List<String> types) {
        DeleteRuleQuery query = new DeleteRuleQuery(id);
        for (String type : types) {
            query.addType(type);
        }
        return new LuceneDeleteRule((SearchQuery)query);
    }

    private static final class DeleteRuleQuery
    implements SearchQuery,
    XMLWritable {
        private final List<String> pstypes = new ArrayList<String>();
        private final boolean isRelease;
        private final boolean isDocumentRelease;
        private @Nullable Long psid = null;
        private @Nullable Long releaseid = null;
        private @Nullable Long uriid = null;
        private @Nullable BooleanQuery query = null;

        public DeleteRuleQuery(Long uriID, @Nullable Long releaseID, boolean document) {
            this.isRelease = true;
            this.uriid = uriID;
            this.releaseid = releaseID;
            this.isDocumentRelease = document;
        }

        public DeleteRuleQuery(Long id) {
            this.psid = id;
            this.isRelease = false;
            this.isDocumentRelease = false;
        }

        public void addType(String type) {
            this.pstypes.add(type);
        }

        public @Nullable Sort getSort() {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public Query toQuery() {
            if (this.query == null) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                if (this.isRelease) {
                    String versionType;
                    String string = versionType = this.isDocumentRelease ? "documentversion" : "urlversion";
                    if (this.releaseid != null) {
                        builder.add((Query)new TermQuery(new Term("psversionid", Long.toString(this.releaseid))), BooleanClause.Occur.MUST);
                        builder.add((Query)new TermQuery(new Term("pstype", versionType)), BooleanClause.Occur.MUST);
                    } else {
                        BooleanQuery.Builder versionQuery = new BooleanQuery.Builder();
                        versionQuery.add((Query)new TermQuery(new Term("psid", Long.toString(this.uriid) + "#version")), BooleanClause.Occur.MUST);
                        versionQuery.add((Query)new TermQuery(new Term("pstype", versionType)), BooleanClause.Occur.MUST);
                        builder.add((Query)versionQuery.build(), BooleanClause.Occur.SHOULD);
                        BooleanQuery.Builder documentQuery = new BooleanQuery.Builder();
                        documentQuery.add((Query)new TermQuery(new Term("psid", Long.toString(this.uriid))), BooleanClause.Occur.MUST);
                        if (this.isDocumentRelease) {
                            BooleanQuery.Builder typesQuery = new BooleanQuery.Builder();
                            for (String type : Constants.DOCUMENT_PSTYPES) {
                                typesQuery.add((Query)new TermQuery(new Term("pstype", type)), BooleanClause.Occur.SHOULD);
                            }
                            documentQuery.add((Query)typesQuery.build(), BooleanClause.Occur.MUST);
                        } else {
                            documentQuery.add((Query)new TermQuery(new Term("pstype", "url")), BooleanClause.Occur.MUST);
                        }
                        builder.add((Query)documentQuery.build(), BooleanClause.Occur.SHOULD);
                    }
                } else {
                    builder.add((Query)new TermQuery(new Term("psid", Long.toString(this.psid))), BooleanClause.Occur.MUST);
                    BooleanQuery.Builder typesQuery = new BooleanQuery.Builder();
                    for (String type : this.pstypes) {
                        typesQuery.add((Query)new TermQuery(new Term("pstype", type)), BooleanClause.Occur.SHOULD);
                    }
                    builder.add((Query)typesQuery.build(), BooleanClause.Occur.MUST);
                }
                this.query = builder.build();
            }
            return this.query;
        }

        public void toXML(XMLWriter xml) throws IOException {
            xml.openElement("delete-query");
            if (this.query != null) {
                xml.attribute("query", this.query.toString());
            }
            xml.closeElement();
        }
    }
}

