/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchIndexJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchIndexJob.class);
    private final PSRequester requester;
    private final Map<Group, GroupBatch> batches = new HashMap<Group, GroupBatch>();
    private final GroupBatch urlBatch;

    public BatchIndexJob(String name) {
        this.requester = new PSRequester(name);
        this.urlBatch = new GroupBatch(this.requester);
    }

    public void index(Database db, URI uri, Iterator<Group> groups) {
        this.index(db, uri, null, groups);
    }

    public void index(Database db, URI uri, @Nullable Long version, Iterator<Group> groups) {
        if (version != null && URIRule.isFolder((URI)uri)) {
            return;
        }
        if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this.urlBatch.indexLastOne(db, null, false);
                this.urlBatch.setLastContent(uri, version, null, uri.isArchived());
            }
        } else {
            IndexMaster master = IndexMaster.getInstance();
            while (groups.hasNext()) {
                Group group;
                block9: {
                    group = groups.next();
                    if (!master.isIndexable(db, group)) continue;
                    if (version != null) {
                        try {
                            if ("false".equals(GroupProperties.get((Database)db, (Group)group).getProperty("indexVersions", "false"))) {
                            }
                            break block9;
                        }
                        catch (QueryFailedException | IOException ex) {
                            LOGGER.error("Failed to load group properties for {}, versions will not be indexed", (Object)group.getName(), (Object)ex);
                        }
                        continue;
                    }
                }
                GroupBatch batch = this.batches.computeIfAbsent(group, g -> new GroupBatch((Group)g, this.requester));
                batch.indexLastOne(db, group, false);
                if (IndexMaster.shouldIgnoreURI(uri.getPath())) continue;
                batch.setLastContent(uri, version, group, false);
            }
        }
    }

    public void index(Database db, XLink xl, Iterator<Group> grps) {
        IndexMaster master = IndexMaster.getInstance();
        while (grps.hasNext()) {
            Group group = grps.next();
            if (!master.isIndexable(db, group)) continue;
            GroupBatch batch = this.batches.computeIfAbsent(group, g -> new GroupBatch((Group)g, this.requester));
            batch.indexLastOne(db, group, false);
            batch.setLastContent(xl, false);
        }
    }

    public void delete(Database db, URI uri, Iterator<Group> grps) {
        if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this.urlBatch.indexLastOne(db, null, false);
                this.urlBatch.setLastContent(uri, null, null, true);
            }
        } else {
            IndexMaster master = IndexMaster.getInstance();
            while (grps.hasNext()) {
                Group group = grps.next();
                if (!master.isIndexable(db, group)) continue;
                GroupBatch batch = this.batches.computeIfAbsent(group, g -> new GroupBatch((Group)g, this.requester));
                batch.indexLastOne(db, group, false);
                batch.setLastContent(uri, null, group, true);
            }
        }
    }

    public void delete(Database db, String contentID, PSContentType type, Iterator<Group> grps) {
        if (type == PSContentType.URL) {
            this.urlBatch.indexLastOne(db, null, false);
            this.urlBatch.setLastContent(contentID, type);
        } else {
            IndexMaster master = IndexMaster.getInstance();
            while (grps.hasNext()) {
                Group group = grps.next();
                if (!master.isIndexable(db, group)) continue;
                GroupBatch batch = this.batches.computeIfAbsent(group, g -> new GroupBatch((Group)g, this.requester));
                batch.indexLastOne(db, group, false);
                batch.setLastContent(contentID, type);
            }
        }
    }

    public void complete(Database db) {
        for (Map.Entry<Group, GroupBatch> entry : this.batches.entrySet()) {
            GroupBatch batch = entry.getValue();
            Group group = entry.getKey();
            batch.indexLastOne(db, group, true);
        }
        this.urlBatch.indexLastOne(db, null, true);
    }

    private static class GroupBatch {
        private final PSRequester requester;
        private final IndexBatch batch;
        private @Nullable String lastContentID = null;
        private @Nullable PSContentType lastContentType = null;
        private @Nullable Map<String, String> lastParameters = null;
        private boolean lastSlowLane = false;
        private boolean lastIsComment = false;

        public GroupBatch(Group group, PSRequester req) {
            this.batch = new IndexBatch(String.valueOf(group.getId()) + "/" + group.getName() + "/" + req.getProcess());
            this.requester = req;
        }

        public GroupBatch(PSRequester req) {
            this.batch = new IndexBatch("urls/urls/" + req.getProcess());
            this.requester = req;
        }

        public void indexLastOne(Database db, @Nullable Group group, boolean last) {
            if (this.lastContentID == null) {
                return;
            }
            if (this.lastIsComment) {
                this.batch.increaseTotal();
            }
            this.batch.increaseTotal();
            if (last) {
                this.batch.setComputed();
            }
            IndexMaster master = IndexMaster.getInstance();
            if (this.lastIsComment) {
                master.launchIndexJob(this.lastContentID, PSContentType.COMMENT, this.batch, group, db, null, this.requester, false, false);
                master.launchIndexJob(this.lastContentID, PSContentType.TASK, this.batch, group, db, null, this.requester, false, false);
            } else if (this.lastContentType == PSContentType.URL) {
                master.indexURL(IndexUtils.getURIContentIDs(this.lastContentID)[0], IndexUtils.isContentDeleted(this.lastContentID), this.batch, this.requester);
            } else {
                master.launchIndexJob(this.lastContentID, this.lastContentType, this.batch, group, db, this.lastParameters, this.requester, false, this.lastSlowLane);
            }
            this.lastContentID = null;
            this.lastContentType = null;
            this.lastParameters = null;
            this.lastSlowLane = false;
            this.lastIsComment = false;
        }

        protected void setLastContent(String cid, PSContentType type) {
            this.lastContentID = cid;
            this.lastContentType = type;
            this.lastParameters = null;
            this.lastSlowLane = false;
            this.lastIsComment = PSContentType.COMMENT.equals((Object)type) || PSContentType.TASK.equals((Object)type);
        }

        protected void setLastContent(URI uri, @Nullable Long version, @Nullable Group group, boolean delete) {
            this.lastContentID = IndexUtils.buildURIContentID(uri.getId(), version, delete);
            this.lastContentType = IndexUtils.toContentType(uri);
            this.lastParameters = group == null ? null : IndexUtils.buildParameters(uri, group, version);
            this.lastSlowLane = IndexMaster.getInstance().isSlowLane(uri);
            this.lastIsComment = false;
        }

        protected void setLastContent(XLink xl, boolean delete) {
            this.lastContentID = IndexUtils.buildCommentContentID(xl.getId(), delete);
            this.lastContentType = null;
            this.lastParameters = null;
            this.lastSlowLane = false;
            this.lastIsComment = true;
        }
    }
}

