/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.GroupIndexReindexing;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSHelpContent;
import com.pageseeder.search.flint.PSRequester;
import com.pageseeder.search.help.HelpIndexingThread;
import com.pageseeder.search.utils.IndexingThreadBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerIndexingThread
extends IndexingThreadBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerIndexingThread.class);
    private int totalGroups = 0;
    private int groupsDone = 0;
    private String prefix = "";
    private @Nullable String currentGroup = null;
    private boolean indexProjects = true;
    private boolean indexUrls = true;
    private boolean indexPersonal = true;
    private boolean indexHelp = true;

    private ServerIndexingThread(String username) {
        super(username, "Indexing server", null);
        this.typesToIndex.add(IndexingThreadBase.INDEXTYPE.COMMENT);
        this.typesToIndex.add(IndexingThreadBase.INDEXTYPE.DOCUMENT);
        this.typesToIndex.add(IndexingThreadBase.INDEXTYPE.VERSION);
    }

    void setGroupNamePrefix(@Nullable String p) {
        if (p != null && !p.isEmpty()) {
            this.prefix = p;
        }
    }

    void setGroupsToIndex(boolean help, boolean urls, boolean personal, boolean projects) {
        this.indexUrls = urls;
        this.indexHelp = help;
        this.indexPersonal = personal;
        this.indexProjects = projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            LOGGER.error("Unable to open database connection", (Throwable)ex);
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            IndexMaster master = IndexMaster.getInstance();
            Member member = DatabaseQuery.getMemberByUsername((Database)db, (String)this.getUsername());
            if (this.indexHelp && !this.indexHelpContent()) {
                return;
            }
            if (this.indexUrls && !this.indexUrlObjects(tr, db)) {
                return;
            }
            if (this.indexPersonal && !this.indexProjectObjects(master, member, DatabaseQuery.getPersonalGroups((Database)db), tr, db)) {
                return;
            }
            if (this.indexProjects) {
                ArrayList<String> prefixes = new ArrayList<String>();
                for (String pref : this.prefix.split(",")) {
                    pref = pref.isEmpty() || pref.endsWith("-") ? pref.trim() : pref.trim() + "-";
                    prefixes.add(pref);
                }
                Collections.sort(prefixes);
                String ancestor = " ";
                for (String pref : prefixes) {
                    if (pref.startsWith(ancestor)) continue;
                    ancestor = pref;
                    if (this.indexProjectObjects(master, member, DatabaseQuery.getGroupsByPrefix((Database)db, (String)pref), tr, db)) continue;
                    return;
                }
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            this.fail("Failed to open transaction: " + ex.getMessage());
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to connect to the database", (Throwable)ex);
            this.fail("Failed to connect to the database: " + ex.getMessage());
            tr.abort();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to index server", (Throwable)ex);
            this.fail("Failed to index server: " + ex.getMessage());
            tr.abort();
        }
        finally {
            if (this.wasCancelled()) {
                tr.abort();
            }
            db.close();
            this.complete("Finished adding objects to the indexing queue");
        }
    }

    private boolean indexHelpContent() {
        this.total = 0;
        this.alreadyDone = 0;
        IndexBatch batch = new IndexBatch("help/help/Indexing server (built-in help content)");
        List<String> documents = HelpIndexingThread.listPSMLFiles(PSHelpContent.CONTENT_ROOT.toPath());
        this.total = documents.size() + 1;
        batch.increaseTotal(this.total);
        batch.setComputed();
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + documents.size() + " help documents to index");
        if (documents.isEmpty()) {
            return true;
        }
        if (this.wasCancelled()) {
            return false;
        }
        IndexMaster master = IndexMaster.getInstance();
        master.clearHelpIndex(batch, new PSRequester("Indexing server (built-in help content)"));
        Catalog helpCat = Catalogs.getCatalog((String)"help");
        if (helpCat != null) {
            helpCat.clear();
        }
        for (String path : documents) {
            master.indexHelpDocument(path, batch, this.requester);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Added " + path + " to indexing queue");
            ++this.alreadyDone;
        }
        return true;
    }

    private boolean indexUrlObjects(Transaction tr, Database db) throws StartTransactionException, CommitTransactionException, QueryFailedException {
        this.total = 0;
        this.alreadyDone = 0;
        IndexBatch batch = new IndexBatch("urls/urls/Indexing server (URLs)");
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing urls to index");
        ArrayList<Long> urls = new ArrayList<Long>();
        try {
            int count = 0;
            for (Object uri : DatabaseQuery.getExternalURIsByType((Database)db, null)) {
                if (URIs.canBeIndexedAsURL((URI)uri)) {
                    urls.add(uri.getId());
                }
                if (++count % 100 != 0 || !this.wasCancelled()) continue;
                return false;
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to query database for URLs to index", (Throwable)ex);
            this.fail("Failed to query database for URLs to index: " + ex.getMessage());
            return false;
        }
        tr.commitAndStart();
        if (this.wasCancelled()) {
            return false;
        }
        this.total = urls.isEmpty() ? 0 : urls.size() + 1;
        batch.increaseTotal(this.total);
        batch.setComputed();
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + urls.size() + " URLs to index");
        if (urls.isEmpty()) {
            return true;
        }
        IndexMaster master = IndexMaster.getInstance();
        master.clearURLsIndex(batch, new PSRequester("Indexing server (URLs)"));
        Catalog urlsCat = Catalogs.getCatalog((String)"urls");
        if (urlsCat != null) {
            urlsCat.clear();
        }
        for (Long id : urls) {
            master.indexURL(id, false, batch, this.requester);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Added URL " + id + " to indexing queue");
            ++this.alreadyDone;
            if (!this.wasCancelled()) continue;
            return false;
        }
        Group publicGroup = GroupRule.getPublicGroup((Database)db);
        publicGroup.setIndexVersion(Settings.CURRENT_INDEX_VERSION);
        tr.commitAndStart();
        return true;
    }

    private boolean indexProjectObjects(IndexMaster master, Member member, Collection<Group> groups, Transaction tr, Database db) throws DatabaseException, IOException {
        this.totalGroups = groups.size();
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.totalGroups + " groups to index");
        ArrayList<String> catalogCleared = new ArrayList<String>();
        for (Group group : groups) {
            ++this.groupsDone;
            if (!master.isIndexable(db, group)) continue;
            this.currentGroup = group.getName();
            String catlogName = GroupIndex.getCatalogName(group);
            if ((this.prefix == null || (catlogName + "-").startsWith(this.prefix)) && !catalogCleared.contains(catlogName)) {
                catalogCleared.add(catlogName);
                Catalog cat = Catalogs.getCatalog((String)catlogName);
                if (cat != null) {
                    cat.clear();
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Cleared index catalog: " + catlogName);
                }
            }
            if (!this.indexGroup(group, member, tr, db)) {
                return false;
            }
            tr.commitAndStart();
            this.currentGroup = null;
            if (!this.wasCancelled()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean indexGroup(Group group, Member member, Transaction tr, Database db) throws DatabaseException, IOException {
        this.total = 0;
        this.alreadyDone = 0;
        IndexBatch batch = new IndexBatch(String.valueOf(group.getId()) + "/" + group.getName() + "/Indexing server").withClearJob();
        try {
            IndexIO indexIo;
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing objects to index in group " + group.getName());
            Collection<XLink> comments = this.findComments(db, group);
            if (this.wasCancelled()) {
                tr.abort();
                boolean bl = false;
                return bl;
            }
            List<IndexingThreadBase.URIToIndex> filefolders = this.findFilesAndFolders(group, db);
            if (this.wasCancelled()) {
                tr.abort();
                this.complete("Could not compute documents in group " + group.getName());
                boolean bl = false;
                return bl;
            }
            Map<Long, URI> versions = this.findVersions(db, group, filefolders);
            if (this.wasCancelled()) {
                tr.abort();
                boolean bl = false;
                return bl;
            }
            if (!this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.DOCUMENT)) {
                filefolders = new ArrayList<IndexingThreadBase.URIToIndex>();
            }
            this.total = comments.size() * 2 + versions.size() + filefolders.size() + 1;
            batch.increaseTotal(this.total);
            batch.setComputed();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.total + " objects to index in group " + group.getName());
            if (this.total == 0) {
                group.setIndexVersion(Settings.CURRENT_INDEX_VERSION);
                tr.commitAndStart();
                boolean bl = true;
                return bl;
            }
            GroupIndexReindexing.startReindexing(group.getId(), batch.getID(), true);
            IndexMaster master = IndexMaster.getInstance();
            try {
                indexIo = master.getIndex(db, group).getIndexIO();
            }
            catch (Exception ex) {
                IndexMaster.removeIndexFiles(group.getId());
                indexIo = master.getIndex(db, group).getIndexIO();
            }
            Long startDate = indexIo.getLastTimeUsed();
            master.clearIndex(batch, db, group, this.requester, false);
            if (!this.indexComments(comments, group, batch, db) || !this.indexVersions(versions, group, batch, db)) {
                tr.commit();
                boolean bl = false;
                return bl;
            }
            tr.commitAndStart();
            for (IndexingThreadBase.URIToIndex dir : filefolders) {
                if (this.indexFileFolder(dir, group, member, batch, db, tr)) continue;
                tr.commit();
                boolean bl = false;
                return bl;
            }
            Long afterDate = master.getIndex(db, group).getIndexIO().getLastTimeUsed();
            if (afterDate.equals(startDate)) {
                master.closeIndex(group.getId());
            }
            group.setIndexVersion(Settings.CURRENT_INDEX_VERSION);
        }
        finally {
            if (this.wasCancelled()) {
                batch.cancel(this.alreadyDone);
            }
        }
        return true;
    }

    public static ServerIndexingThread newInstance(String username) {
        return new ServerIndexingThread(username);
    }

    private List<IndexingThreadBase.URIToIndex> findFilesAndFolders(Group group, Database db) throws QueryFailedException, IOException {
        ArrayList<IndexingThreadBase.URIToIndex> filefolders = new ArrayList<IndexingThreadBase.URIToIndex>();
        if (!this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.DOCUMENT) && !this.typesToIndex.contains((Object)IndexingThreadBase.INDEXTYPE.VERSION)) {
            return filefolders;
        }
        Collection groupUris = group.getGroupURIsCol();
        for (GroupURI guri : groupUris) {
            this.addGroupURI(filefolders, guri, db);
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + filefolders.size() + " documents/folders to index");
        return filefolders;
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("indexing");
        out.startObject("groups");
        if (this.currentGroup != null) {
            out.field("group", this.currentGroup);
        }
        out.field("current", (long)this.groupsDone);
        out.field("total", (long)this.totalGroups);
        out.endObject();
        out.startObject("progress");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.endObject();
        out.startCollection("types", OutputPrinter.CollectionOption.JSON_ONLY);
        for (IndexingThreadBase.INDEXTYPE type : this.typesToIndex) {
            out.startObject("type");
            out.field("name", type.toString().toLowerCase());
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }
}

