/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.GroupIndexReindexing;
import com.pageseeder.search.SearchBase;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.utils.Results;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.SortField;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.MultipleIndexReader;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.flint.lucene.util.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.XML, OutputType.JSON, OutputType.CSV})
public final class Search
extends SearchBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(Search.class);
    private static final int DEFAULT_MAX_RESULTS = 100;
    private static final int DEFAULT_FIELD_SIZE = 1000;
    private static final int MAX_FIELD_SIZE = 10000;
    private static final int DEFAULT_MAX_SUGGESTIONS = 20;
    private static final List<String> DEFAULT_CSV_COLUMNS = Arrays.asList("psid", "pstitle", "psmodifieddate");

    @Override
    protected void addETagValues(GeneratorRequest req, StringBuilder etag) {
        etag.append("predicate:").append(req.getParameter((Parameter)StandardParameters.predicate, "*"));
        etag.append(",defaultfield:").append(req.getParameter((Parameter)StandardParameters.defaultfield, "pscontent"));
        etag.append(",suggestsize:").append(req.getParameter((Parameter)StandardParameters.suggestsize, ""));
        etag.append(",page:").append(req.getParameter((Parameter)StandardParameters.page, 1L));
        etag.append(",pagesize:").append(req.getParameter((Parameter)StandardParameters.pagesize, 100L));
        etag.append(",fieldsize:").append(req.getParameter((Parameter)StandardParameters.fieldsize, 1000L));
    }

    @Override
    protected boolean supportPredicate() {
        return true;
    }

    @Override
    protected void finishNoIndexes(GeneratorRequest req, GeneratorResponse res) throws IOException {
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("search");
        out.field("indexes", "");
        out.endObject();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finish(GeneratorRequest req, List<Index> indexes, List<Group> groups, PageSeederQuery query, SearchBase.AllFacets facets, int facetSize, @Nullable String warning, Catalog catalog, Analyzer analyser, boolean urlsFilterAdded, GeneratorResponse res) throws IOException {
        SearchResults results;
        int max;
        int page = SearchUtils.getIntParameter(req, StandardParameters.page, 1);
        int pageSize = SearchUtils.getIntParameter(req, StandardParameters.pagesize, 100);
        if (pageSize > (max = GlobalSettings.getInt((String)"maxPageSize", (int)10000))) {
            pageSize = max;
        }
        SearchPaging paging = new SearchPaging(page, pageSize);
        try {
            results = LuceneIndexQueries.query(indexes, (SearchQuery)query, (SearchPaging)paging);
        }
        catch (IndexException ex) {
            LOGGER.error("Failed to search index", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to run query " + String.valueOf(query) + ": " + ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        if (OutputType.CSV == out.getType()) {
            String columnsSpec = req.getParameter("columns");
            List<String> columns = columnsSpec != null ? Arrays.asList(columnsSpec.split(",")) : DEFAULT_CSV_COLUMNS;
            List headers = columns.stream().map(Search::toHeader).collect(Collectors.toList());
            out.setCSVOutput("result", (List)columns);
            out.setCSVHeaders(headers);
        }
        out.startObject("search");
        boolean reindexing = false;
        for (Index idx : indexes) {
            if (!(idx instanceof GroupIndex) || !GroupIndexReindexing.isReindexing(((GroupIndex)idx).getGroupID())) continue;
            reindexing = true;
            break;
        }
        if (reindexing) {
            out.field("reindexing", true);
        }
        if (warning != null) {
            out.field("warning", warning);
        }
        out.field("indexes", indexes.stream().map(Index::getIndexID).collect(Collectors.joining(",")));
        try {
            if (OutputType.CSV != out.getType()) {
                boolean predicateType;
                query.print((OutputPrinter)out);
                boolean bl = predicateType = this.supportPredicate() && "predicate".equals(req.getParameter((Parameter)StandardParameters.type, "predicate"));
                if (!predicateType) {
                    this.computeSuggestions(SearchUtils.getIntParameter(req, StandardParameters.suggestsize, 20), indexes, query, (OutputPrinter)out);
                }
                if (!facets.isEmpty()) {
                    out.startCollection("facets");
                    this.printFacets(facets, results.searcher(), query, groups, facetSize, catalog, out);
                    out.endCollection();
                }
            }
            int fieldsize = Math.min(SearchUtils.getIntParameter(req, StandardParameters.fieldsize, 1000), 10000);
            Collection<String> extractFields = OutputType.CSV == out.getType() ? null : this.extractFields(query, results.searcher());
            Results.print(results, paging, extractFields, fieldsize, catalog, analyser, groups, (OutputPrinter)out);
        }
        catch (IndexException ex) {
            LOGGER.error("Failed to output search results", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to output search results: " + ex.getMessage());
        }
        finally {
            results.terminate();
            out.endObject();
            out.flush();
        }
    }

    @Override
    protected boolean addSort(GeneratorRequest req, GeneratorResponse res, @Nullable Catalog catalog, PageSeederQuery.Builder builder) {
        String[] sortby;
        for (String sf : sortby = Strings.split((String)req.getParameter((Parameter)StandardParameters.sortfields, ""), (char)',')) {
            boolean reverse;
            if (sf.isEmpty()) continue;
            boolean bl = reverse = sf.charAt(0) == '-';
            if (reverse) {
                sf = sf.substring(1);
            }
            if (catalog != null) {
                FlintField.DocValuesType dvt = catalog.getDocValuesType(sf);
                if (dvt == FlintField.DocValuesType.SORTED_NUMERIC) {
                    FlintField.NumericType num = catalog.getNumericType(sf);
                    if (num == FlintField.NumericType.INT) {
                        builder.addNumericSortField(sf, SortField.Type.INT, reverse);
                        continue;
                    }
                    if (num == FlintField.NumericType.LONG) {
                        builder.addNumericSortField(sf, SortField.Type.LONG, reverse);
                        continue;
                    }
                    if (num == FlintField.NumericType.FLOAT) {
                        builder.addNumericSortField(sf, SortField.Type.FLOAT, reverse);
                        continue;
                    }
                    if (num != FlintField.NumericType.DOUBLE) continue;
                    builder.addNumericSortField(sf, SortField.Type.DOUBLE, reverse);
                    continue;
                }
                if (dvt == FlintField.DocValuesType.SORTED_SET) {
                    builder.addSetSortField(sf, reverse);
                    continue;
                }
                if (dvt == FlintField.DocValuesType.SORTED) {
                    builder.addSortField(sf, SortField.Type.STRING, reverse);
                    continue;
                }
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SORT_FIELD, "Invalid sort field: " + sf);
                return false;
            }
            builder.addSortField(sf, SortField.Type.STRING, reverse);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSuggestions(int size, List<Index> indexes, PageSeederQuery query, OutputPrinter out) throws IOException {
        if (query.question() != null && !query.question().isEmpty()) {
            IndexMaster master = IndexMaster.getInstance();
            MultipleIndexReader multi = LuceneIndexQueries.getMultipleIndexReader(indexes);
            try {
                IndexSearcher searcher = new IndexSearcher(multi.grab());
                Bucket<Question> similar = master.similar(indexes, query.question(), size);
                if (similar != null && !similar.isEmpty()) {
                    out.startCollection("suggestions");
                    for (Question q : similar) {
                        out.startObject("suggestion");
                        out.field("question", q.question());
                        PageSeederQuery qq = query.newQuery(q);
                        if (qq != null) {
                            int count = Documents.count((IndexSearcher)searcher, (Query)qq.toQuery());
                            out.field("cardinality", (long)count);
                        }
                        out.endObject();
                    }
                    out.endCollection();
                }
            }
            catch (IndexException ex) {
                LOGGER.error("Failed to compute suggestions", (Throwable)ex);
            }
            finally {
                multi.releaseSilently();
            }
        }
    }

    private Collection<String> extractFields(PageSeederQuery query, IndexSearcher searcher) {
        if (query.question() != null) {
            return query.question().fields();
        }
        HashSet terms = new HashSet();
        try {
            query.toQuery().rewrite(searcher.getIndexReader()).visit(QueryVisitor.termCollector(terms));
        }
        catch (Exception ex) {
            LOGGER.warn("Computing extract failed, no extracts will be provided", (Throwable)ex);
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (Term t : terms) {
            if (fields.contains(t.field())) continue;
            fields.add(t.field());
        }
        return fields;
    }

    private static String toHeader(String field) {
        switch (field) {
            case "psassignedto": {
                return "Assigned to";
            }
            case "psblocklabelname": {
                return "Block label name";
            }
            case "psdescription": {
                return "Description";
            }
            case "psdocid": {
                return "Doc ID";
            }
            case "psfilename": {
                return "Filename";
            }
            case "psfolder": {
                return "Folder";
            }
            case "psfragmentlabel": {
                return "Fragment label";
            }
            case "psheight": {
                return "Height";
            }
            case "psid": {
                return "ID";
            }
            case "psimagealt": {
                return "Image alt";
            }
            case "psimagelabel": {
                return "Image label";
            }
            case "pslabel": {
                return "Labels";
            }
            case "pslatestversion": {
                return "Version";
            }
            case "pslinklabel": {
                return "Link label";
            }
            case "pslistrole": {
                return "List role";
            }
            case "psmedia-createddate": {
                return "Media created";
            }
            case "psmedia-modifieddate": {
                return "Media modified";
            }
            case "psmediatype": {
                return "Media type";
            }
            case "psmetadataname": {
                return "Metadata property name";
            }
            case "psmodifieddate": {
                return "Last modified";
            }
            case "pspagecount": {
                return "Page count";
            }
            case "psplaceholder": {
                return "Placeholder";
            }
            case "pspriority": {
                return "Priority";
            }
            case "pspropertyname": {
                return "Property name";
            }
            case "psreversexrefconfig": {
                return "Reverse xref config";
            }
            case "psreversexrefcount": {
                return "Reverse XRef count";
            }
            case "psreversexreflabel": {
                return "Reverse XRef label";
            }
            case "psreversexreftype": {
                return "Reverse XRef type";
            }
            case "pssize": {
                return "Size";
            }
            case "psstatus": {
                return "Status";
            }
            case "psstatuschangeddate": {
                return "Status changed";
            }
            case "pstablerole": {
                return "Table role";
            }
            case "pstitle": {
                return "Title";
            }
            case "psurl": {
                return "URL";
            }
            case "psversion": {
                return "Version";
            }
            case "pswidth": {
                return "Width";
            }
            case "pswordcount": {
                return "Word count";
            }
            case "psxrefconfig": {
                return "XRef config";
            }
            case "psxrefcount": {
                return "XRef count";
            }
            case "psxreflabel": {
                return "XRef label";
            }
            case "psxreftype": {
                return "XRef type";
            }
        }
        if (field.startsWith("psinline-")) {
            return Search.capitalize(field.substring(9)) + " inline label";
        }
        if (field.startsWith("psproperty-")) {
            return Search.capitalize(field.substring(11)) + " property";
        }
        if (field.startsWith("psmetadata-")) {
            return Search.capitalize(field.substring(11)) + " metadata";
        }
        if (field.startsWith("x-")) {
            return field.substring(2) + " (x- field)";
        }
        return field;
    }

    private static String capitalize(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

