/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexMaster;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.lucene.index.IndexReader;
import org.pageseeder.berlioz.util.ISO8601;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.XML, OutputType.JSON})
@Beta
public final class ListIndexes
implements Generator,
SingleCheck {
    private static final FileFilter INDEX_FOLDERS = file -> file.isDirectory() && Strings.isDigits((String)file.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(ListIndexes.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        IndexMaster master = IndexMaster.getInstance();
        boolean includeInactive = req.getParameter((Parameter)StandardParameters.archived, false);
        long page = req.getParameter((Parameter)StandardParameters.page, 1L);
        long pagesize = req.getParameter((Parameter)StandardParameters.pagesize, 100L);
        int start = (int)((page - 1L) * pagesize) - (page == 1L ? 0 : 2);
        int end = (int)((long)start + pagesize) - (page == 1L ? 2 : 0);
        List<Group> groups = this.getGroups(req.getHttpServletRequest().getServletContext(), includeInactive, db);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("indexes");
        out.field("page", page);
        out.field("pagesize", pagesize);
        out.field("total", (long)(groups.size() + 2));
        out.field("has-more", end < groups.size());
        out.startCollection("indexes", OutputPrinter.CollectionOption.JSON_ONLY);
        if (page == 1L) {
            out.startObject("index");
            out.field("id", "help");
            try {
                this.outputIndex((Index)master.getHelpIndex(), out);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load help index", (Throwable)ex);
                out.field("error", ex.getMessage());
            }
            finally {
                out.endObject();
            }
            out.startObject("index");
            out.field("id", "urls");
            try {
                this.outputIndex((Index)master.getURLsIndex(), out);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load urls index", (Throwable)ex);
                out.field("error", ex.getMessage());
            }
            finally {
                out.endObject();
            }
        }
        int passed = 0;
        for (Group group : groups) {
            if (++passed - 1 < start) continue;
            if (passed > end) break;
            GroupIndex index = master.getIndex(db, group);
            out.startObject("index");
            out.field("id", group.getName());
            out.field("group", group.getName());
            try {
                this.outputIndex((Index)index, out);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load index with name {}", (Object)group.getName(), (Object)ex);
                out.field("error", ex.getMessage());
            }
            finally {
                out.endObject();
            }
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputIndex(Index index, UniversalPrinter out) {
        IndexReader reader = null;
        try {
            reader = LuceneIndexQueries.grabReader((Index)index);
            long lastUsed = index.getIndexIO().getLastTimeUsed();
            if (lastUsed > 0L) {
                out.field("last-modified", ISO8601.DATETIME.format(lastUsed));
            }
            out.field("deletions", Boolean.toString(reader.hasDeletions()));
            out.field("documents", (long)reader.numDocs());
            out.field("max-doc", (long)reader.maxDoc());
        }
        finally {
            LuceneIndexQueries.releaseQuietly((Index)index, (IndexReader)reader);
        }
    }

    private List<Group> getGroups(ServletContext context, boolean includeInactive, Database db) throws QueryFailedException {
        File[] files = new File(context.getRealPath("/"), "/WEB-INF/state/index").listFiles(INDEX_FOLDERS);
        List indexes = files == null ? null : Arrays.stream(files).map(File::getName).collect(Collectors.toList());
        ArrayList<Group> groups = new ArrayList<Group>();
        if (indexes != null) {
            for (String name : indexes) {
                Group group = DatabaseQuery.getGroupById((Database)db, (Long)Long.parseLong(name));
                if (group != null && GroupRule.isPersonalGroup((String)group.getName()) || !includeInactive && (group == null || GroupRule.isArchived((Group)group) || GroupRule.isProject((Group)group))) continue;
                groups.add(group);
            }
        }
        groups.sort(Comparator.comparing(Group::getName));
        return groups;
    }
}

