/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.search.Terms;

@Requires(parameters={"index"})
@Output(types={OutputType.XML, OutputType.JSON})
@Beta
public final class ListIndexFields
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        LuceneIndex index;
        Database db = req.getDatabase();
        IndexMaster master = IndexMaster.getInstance();
        String indexName = req.getParameter((Parameter)StandardParameters.index);
        assert (indexName != null);
        UniversalPrinter out = res.getUniversalWriter();
        if ("help".equals(indexName)) {
            index = master.getHelpIndex();
        } else if ("urls".equals(indexName)) {
            index = master.getURLsIndex();
        } else {
            Group group = GroupRule.getGroup((Database)db, (String)indexName);
            if (group == null) {
                res.setError(GeneratorStatus.NOT_FOUND, "Invalid index " + indexName);
                return;
            }
            index = master.getIndex(db, group);
        }
        out.startCollection("fields");
        IndexReader reader = null;
        try {
            reader = LuceneIndexQueries.grabReader((Index)index);
            for (String fieldname : Terms.fields((IndexReader)reader)) {
                out.startObject("field");
                out.field("name", fieldname);
                out.field("documents", (long)reader.getDocCount(fieldname));
                out.endObject();
            }
        }
        finally {
            out.endCollection();
            LuceneIndexQueries.releaseQuietly((Index)index, (IndexReader)reader);
        }
        out.flush();
    }
}

