/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditXLinkCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.XLink;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;

@Requires(database=true, group=true)
public final class IndexXLink
implements Generator,
SingleCheck {
    @ContentPermission(value=EditXLinkCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        XLink xlink = this.loadXLink(req);
        if (xlink == null) {
            return new ForbiddenCheck();
        }
        return new EditXLinkCheck(URIRule.getURIByXLink((XLink)xlink), xlink);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group group = req.getGroup();
        assert (group != null);
        XLink xl = this.loadXLink(req);
        assert (xl != null);
        IndexMaster master = IndexMaster.getInstance();
        boolean index = "true".equals(req.getParameter((Parameter)StandardParameters.index, "true"));
        boolean translate = "true".equals(req.getParameter((Parameter)StandardParameters.translate, "false"));
        boolean astask = "true".equals(req.getParameter((Parameter)StandardParameters.astask, "false"));
        if (!index) {
            try {
                StringWriter sw = new StringWriter();
                if (translate) {
                    master.translateXLink(req.getDatabase(), xl, astask, group, req.getParameters(), sw);
                } else {
                    master.process(xl, astask, group, sw);
                }
                String xml = sw.toString();
                if (xml.startsWith("<?xml ")) {
                    xml = xml.substring(xml.indexOf(62) + 1);
                }
                if (xml.trim().startsWith("<!DOCTYPE ")) {
                    xml = xml.substring(xml.indexOf(62) + 1);
                }
                res.getXMLWriter().writeXML(xml);
            }
            catch (IndexException ex) {
                req.getLogger((Object)this).error("Failed to translate xlink {}", (Object)xl.getId());
                req.getLogger((Object)this).error("Error is:", (Throwable)ex);
                throw new IOException(ex);
            }
        } else {
            master.indexUrgent(req.getDatabase(), xl, Collections.singleton(req.getGroup()).iterator(), new PSRequester("Indexing single XLink " + xl.getId()));
            res.getXMLWriter().emptyElement("indexed");
        }
    }

    private @Nullable XLink loadXLink(GeneratorRequest req) throws DatabaseException {
        long id = req.getParameter((Parameter)StandardParameters.xl, -1L);
        return DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)id);
    }
}

