/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.search.GroupIndexingThread;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.utils.IndexingThreadBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.LoggerFactory;

@Requires(group=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GroupIndexing
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        assert (group != null);
        return new EditGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Member member = req.getMember();
        assert (group != null && member != null);
        List<String> types = Arrays.asList(Strings.split((String)req.getParameter((Parameter)StandardParameters.types, ""), (char)','));
        boolean clear = "true".equals(req.getParameter((Parameter)StandardParameters.clear));
        if (!IndexMaster.getInstance().isIndexable(req.getDatabase(), req.getGroup())) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Indexing is disabled on this group.");
            return;
        }
        if (clear) {
            boolean missingOne;
            boolean bl = missingOne = !types.contains("document") || !types.contains("url") || !types.contains("comment");
            if (!missingOne) {
                try {
                    Properties props = GroupProperties.get((Database)req.getDatabase(), (Group)req.getGroup());
                    missingOne = "true".equals(props.getProperty("indexVersions")) && !types.contains("version");
                }
                catch (DatabaseException ex) {
                    LoggerFactory.getLogger(GroupIndexing.class).error("Failed to load group properties for {}", (Object)req.getGroup(), (Object)ex);
                }
            }
            if (missingOne) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Cannot clear the index if not all objects are indexed.");
                return;
            }
        }
        GroupIndexingThread thread = GroupIndexingThread.newInstance(member.getUsername(), "Indexing group " + group.getName(), group);
        thread.setClearFirst(clear);
        if (types.contains("document")) {
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.DOCUMENT);
        }
        if (types.contains("comment")) {
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.COMMENT);
        }
        if (types.contains("version")) {
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.VERSION);
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("group-indexing");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

