/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.common.Beta;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.query.AnyTermParameter;
import org.pageseeder.flint.lucene.query.BasicQuery;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.query.TermParameter;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
@Beta
public final class GetTaskSummary
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Database db = req.getDatabase();
        assert (group != null);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("task-summary");
        IndexMaster master = IndexMaster.getInstance();
        if (master.isIndexable(db, group)) {
            try {
                Properties properties = GroupProperties.get((Database)db, (Group)group);
                AnyTermParameter active = GetTaskSummary.getActiveParameter(properties);
                TermParameter task = new TermParameter("pstype", "task");
                ArrayList<Object> p = new ArrayList<Object>();
                p.add(active);
                p.add(task);
                TermParameter high = GetTaskSummary.getTopPriorityParameter(properties);
                Sort mostrecent = new Sort(new SortField[]{new SortField("psmodifieddate", SortField.Type.STRING, true)});
                BasicQuery q = BasicQuery.newBasicQuery((SearchParameter)high, p);
                q.setSort(mostrecent);
                SearchResults results = master.search(db, group, (SearchQuery)q, 10, 1);
                results.toXML(xml);
                GregorianCalendar calendar = new GregorianCalendar();
                ((Calendar)calendar).add(5, 7);
                DateParameter overdue = new DateParameter("psduedate", null, calendar.getTime(), DateTools.Resolution.SECOND, false);
                BasicQuery q1 = BasicQuery.newBasicQuery((SearchParameter)overdue, p);
                q1.setSort(mostrecent);
                SearchResults results1 = master.search(db, group, (SearchQuery)q1, 10, 1);
                results1.toXML(xml);
            }
            catch (QueryFailedException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to query DB: " + ex.getMessage());
                return;
            }
            catch (IndexException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof IndexFormatTooOldException) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)IndexErrorID.INDEX_TOO_OLD, "index-too-old");
                } else {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to perform search: " + ex.getMessage());
                }
                return;
            }
        }
        xml.closeElement();
    }

    private static @Nullable TermParameter getTopPriorityParameter(Properties properties) {
        String[] priorities = Strings.split((String)properties.getProperty("priority", "High"), (char)',');
        if (priorities.length > 0) {
            return new TermParameter("pspriority", priorities[0]);
        }
        return null;
    }

    private static AnyTermParameter getActiveParameter(Properties properties) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String active : Strings.split((String)properties.getProperty("statusActive", "Open"), (char)',')) {
            terms.add(new Term("psstatus", active));
        }
        return new AnyTermParameter(terms);
    }
}

