/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.query.BasicQuery;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.query.TermParameter;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
@Beta
public final class GetRecentItems
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Database db = req.getDatabase();
        assert (group != null);
        XMLWriter xml = res.getXMLWriter();
        String type = req.getParameter((Parameter)StandardParameters.type, "document");
        xml.openElement("recent-items");
        xml.attribute("type", type);
        IndexMaster master = IndexMaster.getInstance();
        if (master.isIndexable(db, group)) {
            try {
                int max = (int)req.getParameter((Parameter)StandardParameters.max, 5L);
                BasicQuery q = BasicQuery.newBasicQuery((SearchParameter)new TermParameter("pstype", type));
                q.setSort(new Sort(new SortField[]{new SortField("psmodifieddate", SortField.Type.STRING, true)}));
                SearchResults results = master.search(db, group, (SearchQuery)q, max, 1);
                results.toXML(xml);
            }
            catch (IndexException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof IndexFormatTooOldException) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)IndexErrorID.INDEX_TOO_OLD, "index-too-old");
                } else {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to perform search: " + ex.getMessage());
                }
                return;
            }
        }
        xml.closeElement();
    }
}

