/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.query.BasicQuery;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.query.TermParameter;
import org.pageseeder.flint.lucene.search.FieldFacet;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, parameters={"field"})
@Beta
public final class GetFacet
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Database db = req.getDatabase();
        XMLWriter xml = res.getXMLWriter();
        String type = req.getParameter((Parameter)StandardParameters.type, "document");
        String facet = req.getParameter((Parameter)StandardParameters.field);
        assert (facet != null);
        IndexMaster master = IndexMaster.getInstance();
        if (master.isIndexable(db, group)) {
            try {
                BasicQuery q = BasicQuery.newBasicQuery((SearchParameter)new TermParameter("pstype", type));
                FieldFacet f = master.computeFieldFacet(db, group, facet, q.toQuery());
                f.toXML(xml);
            }
            catch (IndexException ex) {
                throw new IOException(ex);
            }
        }
    }
}

