/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.url.URLsIndex;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.slf4j.LoggerFactory;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class AutoComplete
implements Generator,
SingleCheck {
    private static final Comparator<Term> COMPARATOR = Comparator.comparing(Term::text);
    public static final int DEFAULT_MAX_TERMS = 20;
    public static final int DEFAULT_SIMILARITY_RATIO = 4;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Member member = req.getMember();
        Group group = req.getGroup();
        if (member != null && group != null) {
            return new ViewMemberCheck(member, (PermissionCheck)new ViewGroupCheck(group));
        }
        if (member != null) {
            return new ViewMemberCheck(member);
        }
        if (group != null) {
            return new ViewGroupCheck(group);
        }
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String[] fields = Strings.split((String)req.getParameter((Parameter)StandardParameters.fields, req.getParameter((Parameter)StandardParameters.field, "pstitle,pscontent")), (char)',');
        String text = req.getParameter((Parameter)StandardParameters.term, "");
        long max = req.getParameter((Parameter)StandardParameters.max_terms, 20L);
        boolean prefixOnly = "true".equals(req.getParameter((Parameter)StandardParameters.prefix_only, "false"));
        boolean urlsOnly = "true".equals(req.getParameter((Parameter)StandardParameters.urls_only, "false"));
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("autocomplete");
        out.field("term", text);
        if (Strings.isEmpty((String)text)) {
            res.setStatus(GeneratorStatus.BAD_REQUEST);
            out.field("no-term", "true");
        } else {
            List<URLsIndex> indexes;
            Catalog catalog = null;
            if (urlsOnly) {
                URLsIndex index = IndexMaster.getInstance().getURLsIndex();
                indexes = Collections.singletonList(index);
                catalog = Catalogs.getCatalog((String)index.getCatalog());
            } else {
                Map<Group, Boolean> groups = SearchUtils.loadGroupsToSearch(req, res);
                String[] luceneIndexes = SearchUtils.loadIndexes(req, res, groups);
                if (luceneIndexes == null) {
                    return;
                }
                indexes = luceneIndexes.stream().map(i -> i).collect(Collectors.toList());
                if (indexes.isEmpty()) {
                    out.field("no-index", "true");
                } else {
                    catalog = SearchUtils.loadCatalog((List<LuceneIndex>)luceneIndexes, req.getGroup());
                }
            }
            ArrayList<String> allfields = new ArrayList<String>();
            if (catalog != null) {
                for (String field : fields) {
                    if (field.isEmpty()) continue;
                    if (field.charAt(field.length() - 1) == '*') {
                        for (String f : catalog.getFieldsByPrefix(field.substring(0, field.length() - 1))) {
                            if (allfields.contains(f)) continue;
                            allfields.add(f);
                        }
                        continue;
                    }
                    if (allfields.contains(field)) continue;
                    allfields.add(field);
                }
            }
            if (!indexes.isEmpty()) {
                IndexMaster master = IndexMaster.getInstance();
                try {
                    List<Term> terms = master.getPrefixTerms(indexes, allfields, text, max);
                    boolean prefix = true;
                    if (terms.isEmpty() && !prefixOnly) {
                        int similarity = Math.floorDiv(text.length(), 4);
                        if (similarity <= 0) {
                            similarity = 1;
                        }
                        terms = master.getSimilarTerms(indexes, allfields, text, similarity, max);
                        prefix = false;
                    }
                    terms.sort(COMPARATOR);
                    out.startCollection("terms", OutputPrinter.CollectionOption.JSON_ONLY);
                    for (Term term : terms) {
                        out.startObject("term");
                        out.field("field", term.field());
                        out.field("text", term.text());
                        out.field("prefix", Boolean.toString(prefix));
                        out.endObject();
                    }
                    out.endCollection();
                }
                catch (IndexException ex) {
                    LoggerFactory.getLogger(AutoComplete.class).error("Failed to perform autocomplete", (Throwable)ex);
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to perform autocomplete: " + ex.getMessage());
                }
            }
        }
        out.endObject();
        out.flush();
    }
}

