/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.util;

import java.util.HashMap;
import java.util.Map;

public final class Superscripts {
    private static final Map<Character, Character> SUPERSCRIPT_MAP = new HashMap<Character, Character>();

    private Superscripts() {
    }

    public static boolean isReplaceable(String s) {
        for (char c : s.toCharArray()) {
            if (Superscripts.hasSuperscript(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSuperscript(char c) {
        return SUPERSCRIPT_MAP.containsKey(Character.valueOf(c));
    }

    public static char toSuperscript(char c) {
        return SUPERSCRIPT_MAP.getOrDefault(Character.valueOf(c), Character.valueOf(c)).charValue();
    }

    public static String toSuperscript(String input) {
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            sb.append(SUPERSCRIPT_MAP.getOrDefault(Character.valueOf(c), Character.valueOf(c)));
        }
        return sb.toString();
    }

    static {
        SUPERSCRIPT_MAP.put(Character.valueOf('0'), Character.valueOf('\u2070'));
        SUPERSCRIPT_MAP.put(Character.valueOf('1'), Character.valueOf('\u00b9'));
        SUPERSCRIPT_MAP.put(Character.valueOf('2'), Character.valueOf('\u00b2'));
        SUPERSCRIPT_MAP.put(Character.valueOf('3'), Character.valueOf('\u00b3'));
        SUPERSCRIPT_MAP.put(Character.valueOf('4'), Character.valueOf('\u2074'));
        SUPERSCRIPT_MAP.put(Character.valueOf('5'), Character.valueOf('\u2075'));
        SUPERSCRIPT_MAP.put(Character.valueOf('6'), Character.valueOf('\u2076'));
        SUPERSCRIPT_MAP.put(Character.valueOf('7'), Character.valueOf('\u2077'));
        SUPERSCRIPT_MAP.put(Character.valueOf('8'), Character.valueOf('\u2078'));
        SUPERSCRIPT_MAP.put(Character.valueOf('9'), Character.valueOf('\u2079'));
        SUPERSCRIPT_MAP.put(Character.valueOf('+'), Character.valueOf('\u207a'));
        SUPERSCRIPT_MAP.put(Character.valueOf('-'), Character.valueOf('\u207b'));
        SUPERSCRIPT_MAP.put(Character.valueOf('='), Character.valueOf('\u207c'));
        SUPERSCRIPT_MAP.put(Character.valueOf('('), Character.valueOf('\u207d'));
        SUPERSCRIPT_MAP.put(Character.valueOf(')'), Character.valueOf('\u207e'));
        SUPERSCRIPT_MAP.put(Character.valueOf('a'), Character.valueOf('\u1d43'));
        SUPERSCRIPT_MAP.put(Character.valueOf('b'), Character.valueOf('\u1d47'));
        SUPERSCRIPT_MAP.put(Character.valueOf('c'), Character.valueOf('\u1d9c'));
        SUPERSCRIPT_MAP.put(Character.valueOf('d'), Character.valueOf('\u1d48'));
        SUPERSCRIPT_MAP.put(Character.valueOf('e'), Character.valueOf('\u1d49'));
        SUPERSCRIPT_MAP.put(Character.valueOf('f'), Character.valueOf('\u1da0'));
        SUPERSCRIPT_MAP.put(Character.valueOf('g'), Character.valueOf('\u1d4d'));
        SUPERSCRIPT_MAP.put(Character.valueOf('h'), Character.valueOf('\u02b0'));
        SUPERSCRIPT_MAP.put(Character.valueOf('i'), Character.valueOf('\u2071'));
        SUPERSCRIPT_MAP.put(Character.valueOf('j'), Character.valueOf('\u02b2'));
        SUPERSCRIPT_MAP.put(Character.valueOf('k'), Character.valueOf('\u1d4f'));
        SUPERSCRIPT_MAP.put(Character.valueOf('l'), Character.valueOf('\u02e1'));
        SUPERSCRIPT_MAP.put(Character.valueOf('m'), Character.valueOf('\u1d50'));
        SUPERSCRIPT_MAP.put(Character.valueOf('n'), Character.valueOf('\u207f'));
        SUPERSCRIPT_MAP.put(Character.valueOf('o'), Character.valueOf('\u1d52'));
        SUPERSCRIPT_MAP.put(Character.valueOf('p'), Character.valueOf('\u1d56'));
        SUPERSCRIPT_MAP.put(Character.valueOf('r'), Character.valueOf('\u02b3'));
        SUPERSCRIPT_MAP.put(Character.valueOf('s'), Character.valueOf('\u02e2'));
        SUPERSCRIPT_MAP.put(Character.valueOf('t'), Character.valueOf('\u1d57'));
        SUPERSCRIPT_MAP.put(Character.valueOf('u'), Character.valueOf('\u1d58'));
        SUPERSCRIPT_MAP.put(Character.valueOf('v'), Character.valueOf('\u1d5b'));
        SUPERSCRIPT_MAP.put(Character.valueOf('w'), Character.valueOf('\u02b7'));
        SUPERSCRIPT_MAP.put(Character.valueOf('x'), Character.valueOf('\u02e3'));
        SUPERSCRIPT_MAP.put(Character.valueOf('y'), Character.valueOf('\u02b8'));
        SUPERSCRIPT_MAP.put(Character.valueOf('z'), Character.valueOf('\u1dbb'));
        SUPERSCRIPT_MAP.put(Character.valueOf('A'), Character.valueOf('\u1d2c'));
        SUPERSCRIPT_MAP.put(Character.valueOf('B'), Character.valueOf('\u1d2e'));
        SUPERSCRIPT_MAP.put(Character.valueOf('D'), Character.valueOf('\u1d30'));
        SUPERSCRIPT_MAP.put(Character.valueOf('E'), Character.valueOf('\u1d31'));
        SUPERSCRIPT_MAP.put(Character.valueOf('G'), Character.valueOf('\u1d33'));
        SUPERSCRIPT_MAP.put(Character.valueOf('H'), Character.valueOf('\u1d34'));
        SUPERSCRIPT_MAP.put(Character.valueOf('I'), Character.valueOf('\u1d35'));
        SUPERSCRIPT_MAP.put(Character.valueOf('J'), Character.valueOf('\u1d36'));
        SUPERSCRIPT_MAP.put(Character.valueOf('K'), Character.valueOf('\u1d37'));
        SUPERSCRIPT_MAP.put(Character.valueOf('L'), Character.valueOf('\u1d38'));
        SUPERSCRIPT_MAP.put(Character.valueOf('M'), Character.valueOf('\u1d39'));
        SUPERSCRIPT_MAP.put(Character.valueOf('N'), Character.valueOf('\u1d3a'));
        SUPERSCRIPT_MAP.put(Character.valueOf('O'), Character.valueOf('\u1d3c'));
        SUPERSCRIPT_MAP.put(Character.valueOf('P'), Character.valueOf('\u1d3e'));
        SUPERSCRIPT_MAP.put(Character.valueOf('R'), Character.valueOf('\u1d3f'));
        SUPERSCRIPT_MAP.put(Character.valueOf('T'), Character.valueOf('\u1d40'));
        SUPERSCRIPT_MAP.put(Character.valueOf('U'), Character.valueOf('\u1d41'));
        SUPERSCRIPT_MAP.put(Character.valueOf('V'), Character.valueOf('\u2c7d'));
        SUPERSCRIPT_MAP.put(Character.valueOf('W'), Character.valueOf('\u1d42'));
    }
}

