/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Reference
extends Element
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT_TYPE = "default";
    public static final String DEFAULT_FRAGMENT = "default";
    private final long _uri;
    private final Type _type;
    private final String _documenttype;
    private final String _targetfragment;
    private final @Nullable Boolean _displaydocument;

    public Reference(int level, String title, String fragment, String originalfrag, Long uri, Type type, @Nullable String documenttype, String targetfrag, Boolean displaydocument) {
        super(level, title, fragment, originalfrag);
        this._uri = uri;
        this._type = type;
        this._documenttype = documenttype;
        this._targetfragment = "default".equals(targetfrag) ? "default" : targetfrag;
        this._displaydocument = displaydocument;
    }

    public Reference(int level, String title, String fragment, String originalfrag, Long uri) {
        this(level, title, fragment, originalfrag, uri, Type.EMBED, "default", "default", Boolean.TRUE);
    }

    public long uri() {
        return this._uri;
    }

    public Type type() {
        return this._type;
    }

    public String documenttype() {
        return this._documenttype;
    }

    public @Nullable Boolean displaydocument() {
        return this._displaydocument;
    }

    public String targetfragment() {
        return this._targetfragment;
    }

    public Reference title(String title) {
        if (title.equals(this.title())) {
            return this;
        }
        return new Reference(this.level(), title, this.fragment(), this.originalFragment(), this._uri, this._type, this._documenttype, this._targetfragment, this._displaydocument);
    }

    @Override
    public void print(Appendable out) {
        try {
            for (int i = 0; i < this.level(); ++i) {
                out.append('>');
            }
            out.append(' ');
            out.append(this.title());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void toXML(@NonNull XMLWriter xml, int level, @Nullable FragmentNumbering number, long treeid, int count) throws IOException {
        this.toXMLNoClose(xml, level, count);
        if (!"".equals(this.title())) {
            xml.attribute("title", this.title());
        }
        xml.closeElement();
    }

    public void toXMLNoClose(@NonNull XMLWriter xml, int level, int count) throws IOException {
        xml.openElement("document-ref");
        xml.attribute("level", this.level());
        if (this._documenttype != null) {
            xml.attribute("documenttype", this._documenttype);
        }
        if (this._uri > 0L) {
            xml.attribute("uriid", Long.toString(this._uri));
        }
        if (!"default".equals(this._targetfragment)) {
            xml.attribute("targetfragment", this._targetfragment);
        }
        xml.attribute("position", count);
    }

    @Override
    public void toXML(@NonNull XMLWriter xml, int level, @Nullable FragmentNumbering number, long treeid, int count, boolean numbered, String prefix, boolean children) throws IOException {
        this.toXML(xml, level, number, treeid, count, this.title(), numbered, prefix, children, "", null, null);
    }

    public void toXML(@NonNull XMLWriter xml, int level, @Nullable FragmentNumbering number, long treeid, int count, String title, boolean numbered, String prefix, boolean children, String labels, OffsetDateTime lastedited, String path) throws IOException {
        this.toXMLNoClose(xml, level, count);
        if (this._displaydocument != null && this._displaydocument.booleanValue()) {
            xml.attribute("title", title);
        } else {
            xml.attribute("title", this.title());
        }
        if (numbered) {
            xml.attribute("numbered", "true");
        }
        if (children) {
            xml.attribute("children", "true");
        }
        if (!"".equals(labels)) {
            xml.attribute("labels", labels);
        }
        if (lastedited != null) {
            xml.attribute("last-edited", lastedited.format(DateTimeFormatter.ISO_DATE_TIME));
        }
        if (path != null) {
            xml.attribute("path", path);
        }
        if (numbered && number != null) {
            FragmentNumbering.Prefix pref = number.getPrefix(treeid, count);
            if (pref != null) {
                xml.attribute("prefix", pref.value);
                xml.attribute("canonical", pref.canonical);
            }
        } else if (!"".equals(prefix)) {
            xml.attribute("prefix", prefix);
        }
        xml.closeElement();
    }

    public static enum Type {
        EMBED,
        TRANSCLUDE;


        public static Type fromString(String value) {
            for (Type n : Type.values()) {
                if (!n.name().toLowerCase().equals(value)) continue;
                return n;
            }
            return EMBED;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

