/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Part<T extends Element>
implements Serializable,
XMLWritable {
    private static final long serialVersionUID = 6L;
    private final T element;
    private final List<Part<?>> parts;

    public Part(T element) {
        this(element, Collections.emptyList());
    }

    public Part(T element, Part<?> ... parts) {
        this.element = element;
        this.parts = Arrays.asList(parts);
    }

    public Part(T element, List<Part<?>> parts) {
        this.element = element;
        this.parts = parts;
    }

    public Part<T> element(T element) {
        return new Part<T>(element, this.parts);
    }

    public @NonNull T element() {
        return this.element;
    }

    public int level() {
        return ((Element)this.element).level();
    }

    public String title() {
        return ((Element)this.element).title();
    }

    public boolean hasTitle() {
        return ((Element)this.element).hasTitle();
    }

    public int size() {
        return this.parts.size();
    }

    public List<Part<?>> parts() {
        return this.parts;
    }

    public boolean isLevelConsistent() {
        return this.isLevelConsistent(((Element)this.element).level());
    }

    boolean isLevelConsistent(int level) {
        if (((Element)this.element).level() != level) {
            return false;
        }
        for (Part<?> p : this.parts) {
            if (p.isLevelConsistent(level + 1)) continue;
            return false;
        }
        return true;
    }

    public static @Nullable Part<Reference> find(Part<?> part, long uri) {
        Object element = part.element();
        if (element instanceof Reference && ((Reference)element).uri() == uri) {
            return part;
        }
        for (Part<?> p : part.parts()) {
            Part<Reference> found = Part.find(p, uri);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void print(Appendable out) {
        try {
            ((Element)this.element()).print(out);
            out.append('\n');
            for (Part<?> part : this.parts()) {
                part.print(out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void toXML(XMLWriter xml) throws IOException {
        this.toXML(xml, this.level(), null, -1L, -1);
    }

    public void toXML(XMLWriter xml, int level, @Nullable FragmentNumbering number, long treeid, int count) throws IOException {
        xml.openElement("part", !this.parts().isEmpty());
        xml.attribute("level", level);
        ((Element)this.element()).toXML(xml, level, number, treeid, count);
        for (Part<?> p : this.parts()) {
            p.toXML(xml, level + 1, number, treeid, count);
        }
        xml.closeElement();
    }
}

