/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Paragraph
extends Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NO_PREFIX = "";
    public static final String NO_BLOCK_LABEL = "";
    private final int index;
    private final boolean numbered;
    private final String prefix;
    private final String blocklabel;

    private Paragraph(int level, String title, String fragment, String originalfrag, int index, boolean numbered, String prefix, String blocklabel) {
        super(level, title, fragment, originalfrag);
        this.index = index;
        this.numbered = numbered;
        this.prefix = prefix;
        this.blocklabel = blocklabel;
    }

    public Paragraph(int level, String fragment, String originalfrag, int index) {
        this(level, "", fragment, originalfrag, index, false, "", "");
    }

    public int index() {
        return this.index;
    }

    public boolean isVisible(PublicationConfig config) {
        return config != null && (config.getTocParaIndents().indexOf(this.level() + ",") != -1 || !"".equals(this.blocklabel()) && config.getTocBlockLabels().indexOf(this.blocklabel() + ",") != -1);
    }

    public String getPrefixedTitle() {
        return !"".equals(this.prefix) ? this.prefix + " " + this.title() : this.title();
    }

    public String prefix() {
        return this.prefix;
    }

    public String blocklabel() {
        return this.blocklabel;
    }

    public boolean numbered() {
        return this.numbered;
    }

    public Paragraph title(String title) {
        if (title.equals(this.title())) {
            return this;
        }
        return new Paragraph(this.level(), title, this.fragment(), this.originalFragment(), this.index, this.numbered, this.prefix, this.blocklabel);
    }

    public Paragraph prefix(String prefix) {
        return new Paragraph(this.level(), this.title(), this.fragment(), this.originalFragment(), this.index, this.numbered, prefix, this.blocklabel);
    }

    public Paragraph blocklabel(String blocklabel) {
        return new Paragraph(this.level(), this.title(), this.fragment(), this.originalFragment(), this.index, this.numbered, this.prefix, blocklabel);
    }

    public Paragraph numbered(boolean numbered) {
        if (this.numbered == numbered) {
            return this;
        }
        return new Paragraph(this.level(), this.title(), this.fragment(), this.originalFragment(), this.index, numbered, this.prefix, this.blocklabel);
    }

    @Override
    public void print(Appendable out) {
        try {
            for (int i = 0; i < this.level(); ++i) {
                out.append("-");
            }
            out.append(' ');
            if (!"".equals(this.prefix())) {
                out.append(this.prefix()).append(' ');
            }
            out.append("para");
            out.append(" [").append(Integer.toString(this.index)).append(']');
            out.append(" @").append(this.fragment());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void toXML(XMLWriter xml, int level, @Nullable FragmentNumbering number, long treeid, int count) throws IOException {
        if (!this.numbered && ("".equals(this.prefix) || this.prefix == null)) {
            return;
        }
        xml.openElement("para-ref", false);
        xml.attribute("level", this.level());
        if (!"".equals(this.title())) {
            xml.attribute("title", this.title());
        }
        xml.attribute("fragment", this.fragment());
        xml.attribute("index", this.index);
        if (this.numbered) {
            xml.attribute("numbered", "true");
        }
        if (!"".equals(this.blocklabel)) {
            xml.attribute("block-label", this.blocklabel);
        }
        if (number != null) {
            FragmentNumbering.Prefix pref = number.getTranscludedPrefix(treeid, count, this.fragment(), this.index, true);
            if (pref != null) {
                xml.attribute("part-level", pref.level);
            }
            if (this.numbered) {
                if (!(pref == null || "".equals(pref.value) && pref.canonical == null)) {
                    xml.attribute("prefix", pref.value);
                    xml.attribute("canonical", pref.canonical);
                }
            } else if (!"".equals(this.prefix)) {
                xml.attribute("prefix", this.prefix);
            }
        }
        xml.closeElement();
    }
}

