/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.Heading;
import org.pageseeder.psml.toc.NumberingGenerator;
import org.pageseeder.psml.toc.Paragraph;
import org.pageseeder.psml.toc.Part;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationNumbering;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.psml.toc.TransclusionEnd;
import org.pageseeder.psml.toc.XRefLoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FragmentNumbering
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentNumbering.class);
    private static final long serialVersionUID = 20180213L;
    public static final String NO_PREFIX = "";
    private final Map<String, Prefix> numbering = new HashMap<String, Prefix>();
    private final Map<String, Prefix> transcludedNumbering = new HashMap<String, Prefix>();

    public FragmentNumbering() {
    }

    public FragmentNumbering(PublicationTree pub, PublicationConfig config) throws XRefLoopException {
        this(pub, config, new ArrayList<Long>(), new HashMap<Long, List<Long>>());
    }

    public FragmentNumbering(PublicationTree pub, PublicationConfig config, List<Long> unusedIds, Map<Long, List<Long>> transclusions) throws XRefLoopException {
        HashMap<Long, Integer> doccount = new HashMap<Long, Integer>();
        DocumentTree root = pub.root();
        if (root != null) {
            this.numbering.put(root.id() + "-1-default", new Prefix(NO_PREFIX, null, 2 - root.level(), null));
            FragmentNumbering.addTransclusionParents(root.id(), -1L, transclusions);
            this.processTree(pub, root.id(), 1, 1, config, this.getNumberingGenerators(config), doccount, 1, new ArrayList<String>(), "default", transclusions);
        }
        ArrayList<Long> allIds = new ArrayList<Long>(pub.ids());
        Iterator<Map.Entry<Long, List<Long>>> entryIt = transclusions.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry<Long, List<Long>> entry = entryIt.next();
            List<Long> value = entry.getValue();
            if (!value.contains(-1L)) continue;
            if (value.size() == 1) {
                entryIt.remove();
            }
            allIds.remove(entry.getKey());
        }
        unusedIds.addAll(allIds);
    }

    private Map<String, NumberingGenerator> getNumberingGenerators(@Nullable PublicationConfig config) {
        HashMap<String, NumberingGenerator> numbers = new HashMap<String, NumberingGenerator>();
        if (config != null) {
            for (PublicationNumbering numbering : config.getNumberingConfigs()) {
                numbers.put(numbering.getLabel(), new NumberingGenerator(numbering));
            }
        }
        return numbers;
    }

    private @Nullable NumberingGenerator getNumberingGenerator(@Nullable PublicationConfig config, Map<String, NumberingGenerator> numbers, DocumentTree tree) {
        PublicationNumbering numbering;
        PublicationNumbering publicationNumbering = numbering = config == null ? null : config.getPublicationNumbering(tree.labels());
        if (numbering == null) {
            return null;
        }
        return numbers.get(numbering.getLabel());
    }

    private void processTree(PublicationTree pub, long id, int level, int treelevel, PublicationConfig config, Map<String, NumberingGenerator> numbers, Map<Long, Integer> doccount, Integer count, List<String> ancestors, String fragment, Map<Long, List<Long>> transclusions) throws XRefLoopException {
        String key = id + "-" + fragment;
        if (ancestors.contains(key)) {
            throw new XRefLoopException("XRef loop detected on URIID " + id);
        }
        ancestors.add(key);
        DocumentTree current = pub.tree(id);
        if (!"default".equals(fragment)) {
            current = current.singleFragmentTree(fragment);
        }
        Location location = new Location(id, count);
        for (Part<?> part : current.parts()) {
            this.processPart(pub, id, level, treelevel, part, config, numbers, doccount, count, ancestors, location, transclusions);
        }
        ancestors.remove(key);
    }

    private void processPart(PublicationTree pub, long id, int level, int treeLevel, Part<?> part, PublicationConfig config, Map<String, NumberingGenerator> numbers, Map<Long, Integer> doccount, Integer count, List<String> ancestors, Location location, Map<Long, List<Long>> transclusions) throws XRefLoopException {
        Object element = part.element();
        Long next = null;
        DocumentTree nextTree = null;
        Integer nextCount = 1;
        NumberingGenerator number = this.getNumberingGenerator(config, numbers, pub.tree(id));
        int nextLevel = level + 1;
        int nextTreeLevel = PublicationConfig.LevelRelativeTo.DOCUMENT.equals((Object)config.getXRefLevelRelativeTo()) ? treeLevel : level;
        String targetFragment = "default";
        Reference.Type refType = Reference.Type.EMBED;
        if (element instanceof Reference) {
            Reference ref = (Reference)element;
            targetFragment = ref.targetfragment();
            refType = ref.type();
            next = ref.uri();
            nextTree = pub.tree(next);
            if (nextTree != null || Reference.Type.TRANSCLUDE.equals((Object)refType)) {
                nextCount = doccount.get(next);
                nextCount = nextCount == null ? 1 : nextCount + 1;
                doccount.put(next, nextCount);
                if (Reference.Type.EMBED.equals((Object)refType)) {
                    NumberingGenerator nextNumber = this.getNumberingGenerator(config, numbers, nextTree);
                    if (PublicationConfig.LevelRelativeTo.DOCUMENT.equals((Object)config.getXRefLevelRelativeTo())) {
                        nextTreeLevel = treeLevel + ref.level();
                        nextLevel = nextTreeLevel + 1;
                    }
                    if ("default".equals(targetFragment)) {
                        this.processReference(ref, nextLevel - 1, nextTree, nextNumber, nextCount);
                    } else {
                        this.numbering.put(nextTree.id() + "-" + nextCount + "-default", new Prefix(NO_PREFIX, null, nextLevel + 1 - nextTree.level(), null));
                    }
                    FragmentNumbering.addTransclusionParents(ref.uri(), -1L, transclusions);
                } else {
                    if (location.transclusions == 0) {
                        location.uriid = ref.uri();
                        location.position = nextCount;
                        location.fragment = NO_PREFIX;
                        location.index = 0;
                        FragmentNumbering.addTransclusionParents(ref.uri(), id, transclusions);
                    }
                    ++location.transclusions;
                }
            }
        } else if (element instanceof Heading) {
            this.processHeading((Heading)element, level, id, number, count, location);
        } else if (element instanceof Paragraph) {
            int paralevel = config.getParaLevelRelativeTo() == PublicationConfig.LevelRelativeTo.DOCUMENT ? treeLevel + 2 - pub.tree(id).level() : (config.getParaLevelRelativeTo() == PublicationConfig.LevelRelativeTo.HEADING ? level : config.getParaLevelRelativeTo().getLevel() + 1);
            this.processParagraph((Paragraph)element, paralevel, id, number, count, location);
        } else if (element instanceof TransclusionEnd) {
            --location.transclusions;
            if (location.transclusions == 0) {
                location.uriid = id;
                location.position = count;
                location.fragment = NO_PREFIX;
                location.index = 0;
            }
        }
        if (nextTree != null && Reference.Type.EMBED.equals((Object)refType)) {
            this.processTree(pub, next, nextLevel, nextTreeLevel, config, numbers, doccount, nextCount, ancestors, targetFragment, transclusions);
        }
        for (Part<?> r : part.parts()) {
            this.processPart(pub, id, level + 1, treeLevel, r, config, numbers, doccount, count, ancestors, location, transclusions);
        }
    }

    private static void addTransclusionParents(long id, long parentid, Map<Long, List<Long>> transclusions) {
        List<Long> parents = transclusions.get(id);
        if (parents == null) {
            parents = new ArrayList<Long>();
            transclusions.put(id, parents);
        }
        if (!parents.contains(parentid)) {
            parents.add(parentid);
        }
    }

    public void processReference(Reference ref, int level, DocumentTree target, NumberingGenerator number, int count) {
        String p = target.prefix();
        Prefix pref = null;
        if (number != null && "default".equals(ref.targetfragment())) {
            if (target.numbered()) {
                pref = number.generateNumbering(level, "heading", target.blocklabel());
            }
            number.restartNumbering(level);
        }
        if (pref == null) {
            pref = new Prefix(p, null, level, null);
        }
        this.numbering.put(target.id() + "-" + count + "-default", new Prefix(pref.value, pref.canonical, level + 2 - target.level(), pref.parentNumber));
        if (NO_PREFIX.equals(pref.value)) {
            return;
        }
        this.numbering.put(target.id() + "-" + count + "-" + target.titlefragment() + "-1", pref);
        this.transcludedNumbering.put(target.id() + "-" + count + "-" + target.titlefragment() + "-1", pref);
    }

    public void processHeading(Heading h, int level, long id, NumberingGenerator number, int count, Location location) {
        String p = h.prefix();
        Prefix pref = null;
        if (h.numbered() && number != null) {
            pref = number.generateNumbering(level, "heading", h.blocklabel());
        } else if (p != null && !NO_PREFIX.equals(p)) {
            pref = new Prefix(p, null, level, null);
        }
        if (number != null) {
            number.restartNumbering(level);
        }
        FragmentNumbering.updateLocation(h, location);
        if (pref == null) {
            return;
        }
        this.transcludedNumbering.put(id + "-" + count + "-" + h.fragment() + "-" + h.index(), pref);
        if (location.transclusions <= 1) {
            this.numbering.put(location.uriid + "-" + location.position + "-" + location.fragment + "-" + location.index, pref);
        }
    }

    private static void updateLocation(Element e, Location location) {
        if (location.transclusions <= 1) {
            if (location.fragment.equals(e.originalFragment())) {
                ++location.index;
            } else {
                location.fragment = e.originalFragment();
                location.index = 1;
            }
        }
    }

    public void processParagraph(Paragraph para, int level, long id, NumberingGenerator number, int count, Location location) {
        int adjusted_level;
        String p = para.prefix();
        Prefix pref = null;
        int n = adjusted_level = level + para.level() < 1 ? 0 : level + para.level() - 1;
        if (para.numbered() && number != null) {
            pref = number.generateNumbering(adjusted_level, "para", para.blocklabel());
            if (pref == null) {
                pref = new Prefix(NO_PREFIX, null, adjusted_level, null);
            }
        } else if (p != null && !NO_PREFIX.equals(p)) {
            pref = new Prefix(p, null, adjusted_level, null);
        }
        if (number != null) {
            number.restartNumbering(adjusted_level);
        }
        FragmentNumbering.updateLocation(para, location);
        if (pref == null) {
            return;
        }
        this.transcludedNumbering.put(id + "-" + count + "-" + para.fragment() + "-" + para.index(), pref);
        if (location.transclusions <= 1) {
            this.numbering.put(location.uriid + "-" + location.position + "-" + location.fragment + "-" + location.index, pref);
        }
    }

    public @Nullable Prefix getPrefix(long uriid, int position) {
        Prefix pref = this.numbering.get(uriid + "-" + position + "-default");
        if (pref == null) {
            LOGGER.debug("Numbering not found for uriid: {}, position: {}, fragment default", (Object)uriid, (Object)position);
        }
        return pref;
    }

    public Prefix getPrefix(long uriid, int position, String fragment, int index) {
        if ("default".equals(fragment)) {
            return this.getPrefix(uriid, position);
        }
        Prefix pref = this.numbering.get(uriid + "-" + position + "-" + fragment + "-" + index);
        if (pref == null) {
            LOGGER.debug("Numbering not found for uriid: {}, position: {}, fragment: {}, index: {}", new Object[]{uriid, position, fragment, index});
        }
        return pref;
    }

    public @Nullable Prefix getTranscludedPrefix(long uriid, int position, String fragment, int index) {
        return this.getTranscludedPrefix(uriid, position, fragment, index, false);
    }

    public @Nullable Prefix getTranscludedPrefix(long uriid, int position, String fragment, int index, boolean undefined) {
        Prefix pref = this.transcludedNumbering.get(uriid + "-" + position + "-" + fragment + "-" + index);
        if (pref != null && pref.value.isEmpty() && pref.canonical == null && !undefined) {
            return null;
        }
        return pref;
    }

    public Map<String, Prefix> getAllPrefixes() {
        return Collections.unmodifiableMap(this.numbering);
    }

    public Map<String, Prefix> getAllTranscludedPrefixes() {
        return Collections.unmodifiableMap(this.transcludedNumbering);
    }

    public static final class Prefix
    implements Serializable {
        private static final long serialVersionUID = 8704232243442685176L;
        public final String value;
        public final @Nullable String canonical;
        public final int level;
        public final @Nullable String parentNumber;

        public Prefix(String val, @Nullable String canonic, int lvl, @Nullable String parent) {
            this.value = val;
            this.canonical = canonic;
            this.level = lvl;
            this.parentNumber = parent;
        }

        public String toString() {
            return (String)(this.parentNumber != null ? this.parentNumber + ">" : FragmentNumbering.NO_PREFIX) + this.value + " L" + this.level + (String)(this.canonical != null ? " (" + this.canonical + ") " : FragmentNumbering.NO_PREFIX);
        }
    }

    private static final class Location {
        private long uriid;
        private int position;
        private String fragment = "";
        private int index = 0;
        private int transclusions = 0;

        private Location(long uriid, int position) {
            this.uriid = uriid;
            this.position = position;
        }
    }
}

