/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class XML {
    private static final int ASCII_LAST_CHAR = 128;
    private static final Encoder UNICODE_ENCODER = new Encoder(){

        @Override
        public void attribute(String value, StringBuilder xml) {
            int upto = value.length();
            for (int i = 0; i < upto; ++i) {
                XML.attributeChar(value.charAt(i), xml);
            }
        }

        @Override
        public void text(char[] ch, int start, int length, StringBuilder xml) {
            int upto = start + length;
            for (int i = start; i < upto; ++i) {
                XML.textChar(ch[i], xml);
            }
        }
    };
    private static final Encoder ASCII_ENCODER = new Encoder(){

        @Override
        public void attribute(String value, StringBuilder xml) {
            int upto = value.length();
            for (int i = 0; i < upto; ++i) {
                char c = value.charAt(i);
                if (c < '\u0080') {
                    XML.attributeChar(value.charAt(i), xml);
                    continue;
                }
                xml.append("&#x");
                xml.append(Integer.toHexString(c));
                xml.append(';');
            }
        }

        @Override
        public void text(char[] ch, int start, int length, StringBuilder xml) {
            int upto = start + length;
            for (int i = start; i < upto; ++i) {
                if (ch[i] < '\u0080') {
                    XML.textChar(ch[i], xml);
                    continue;
                }
                xml.append("&#x");
                xml.append(Integer.toHexString(ch[i]));
                xml.append(';');
            }
        }
    };

    private XML() {
    }

    public static Encoder getEncoder(Charset cs) {
        if (cs.equals(StandardCharsets.UTF_8) || cs.equals(StandardCharsets.UTF_16)) {
            return UNICODE_ENCODER;
        }
        return ASCII_ENCODER;
    }

    public static boolean hasNonASCIIChar(String xml) {
        int upto = xml.length();
        for (int i = 0; i < upto; ++i) {
            if (xml.charAt(i) < '\u0080') continue;
            return true;
        }
        return false;
    }

    public static void toASCII(String unicode, PrintWriter ascii) {
        int upto = unicode.length();
        for (int i = 0; i < upto; ++i) {
            char c = unicode.charAt(i);
            if (c >= '\u0080') {
                ascii.append("&#x");
                ascii.append(Integer.toHexString(c));
                ascii.append(';');
                continue;
            }
            ascii.append(c);
        }
    }

    private static void attributeChar(char c, StringBuilder xml) {
        switch (c) {
            case '&': {
                xml.append("&amp;");
                break;
            }
            case '<': {
                xml.append("&lt;");
                break;
            }
            case '\"': {
                xml.append("&quot;");
                break;
            }
            default: {
                xml.append(c);
            }
        }
    }

    private static void textChar(char c, StringBuilder xml) {
        switch (c) {
            case '&': {
                xml.append("&amp;");
                break;
            }
            case '<': {
                xml.append("&lt;");
                break;
            }
            default: {
                xml.append(c);
            }
        }
    }

    public static interface Encoder {
        public void attribute(String var1, StringBuilder var2);

        public void text(char[] var1, int var2, int var3, StringBuilder var4);
    }
}

