/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.DocumentTemplate;
import org.pageseeder.psml.template.FragmentTemplate;
import org.pageseeder.psml.template.ParameterType;
import org.pageseeder.psml.template.TFragment;
import org.pageseeder.psml.template.Template;
import org.pageseeder.psml.template.TemplateBuilder;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.psml.template.XML;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TemplateFactory {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{\\$[^\\}]+\\}");
    private static final Charset[] SUPPORTED = new Charset[]{StandardCharsets.US_ASCII, StandardCharsets.UTF_8};
    private final Charset charset;
    private @Nullable SAXParser parser;
    private @Nullable String fragment;

    public TemplateFactory() {
        this.charset = StandardCharsets.UTF_8;
    }

    public TemplateFactory(Charset charset) {
        if (!TemplateFactory.isSupported(charset)) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.charset = charset;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public Template parse(File template) throws IOException, TemplateException {
        InputSource source = new InputSource(template.toURI().toASCIIString());
        return this.parse(source);
    }

    public Template parse(Reader template) throws IOException, TemplateException {
        InputSource source = new InputSource(template);
        return this.parse(source);
    }

    public Template parse(InputSource template) throws IOException, TemplateException {
        Handler handler = new Handler(this.charset, this.fragment);
        try {
            SAXParser parser = this.getParser();
            parser.parse(template, (DefaultHandler)handler);
            return handler.getTemplate();
        }
        catch (SAXException ex) {
            throw new TemplateException(ex);
        }
    }

    public static boolean isSupported(Charset cs) {
        for (Charset supported : SUPPORTED) {
            if (!supported.equals(cs)) continue;
            return true;
        }
        return false;
    }

    private SAXParser getParser() {
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                this.parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException ex) {
                throw new UnsupportedOperationException(ex);
            }
            catch (SAXException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }
        return this.parser;
    }

    private static class NSElement {
        final String uri;
        final String name;

        public NSElement(String uri, String name) {
            this.uri = uri;
            this.name = name;
        }

        public boolean isTemplateElement(String name) {
            return "http://pageseeder.com/psml/template".equals(this.uri) && this.name.equals(name);
        }

        public String toString() {
            return "{" + this.uri + "}" + this.name;
        }
    }

    public class Handler
    extends DefaultHandler {
        private boolean includeXMLDeclaration = false;
        private final Charset _charset;
        private final XML.Encoder _encoder;
        private final TemplateBuilder<? extends Template> _builder;
        private final StringBuilder buffer = new StringBuilder();
        private TFragment.Builder _fragment;
        private boolean unclosed = false;
        private int depth = 0;
        private boolean ignore = false;
        private Deque<NSElement> parents = new ArrayDeque<NSElement>();
        private NSElement previous = null;

        public Handler(@Nullable Charset charset, String fragment) {
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            if (!TemplateFactory.isSupported(charset)) {
                throw new IllegalArgumentException("Only supports ASCII and UTF-8");
            }
            this._charset = charset;
            this._builder = fragment != null ? new FragmentTemplate.Builder(charset, fragment) : new DocumentTemplate.Builder(charset);
            this._encoder = XML.getEncoder(charset);
        }

        public void includeXMLDeclaration(boolean yes) {
            this.includeXMLDeclaration = yes;
        }

        public Template getTemplate() {
            return this._builder.build();
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.includeXMLDeclaration) {
                this.buffer.append("<?xml version=\"1.0\" encoding=\"" + this._charset.name() + "\"?>");
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.checkPushData();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            NSElement element;
            this.checkUnclosed();
            if ("http://pageseeder.com/psml/template".equals(uri)) {
                this.startTemplateElement(localName, attributes);
            } else if (localName.endsWith("fragment") && this._fragment != null) {
                this._fragment.setKind(localName);
                String mediatype = attributes.getValue("mediatype");
                if (mediatype != null) {
                    this._fragment.setMediatype(mediatype);
                }
                this.ignore = false;
            } else {
                this.startPSMLElement(qName, attributes);
            }
            this.previous = element = new NSElement(uri, localName);
            this.parents.push(element);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.parents.pop();
            if ("http://pageseeder.com/psml/template".equals(uri)) {
                this.endTemplateElement(localName);
            } else if (localName.endsWith("fragment") && this._fragment != null) {
                this.ignore = true;
            } else {
                this.endPSMLElement(qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.checkUnclosed();
            NSElement element = this.previous;
            if (this.ignore) {
                return;
            }
            if (this.depth <= 1 && element != null && element.isTemplateElement("param")) {
                String characters = new String(ch, start, length);
                characters = characters.trim();
                this._encoder.text(characters.toCharArray(), 0, characters.length(), this.buffer);
            } else {
                this._encoder.text(ch, start, length, this.buffer);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.checkUnclosed();
            this.buffer.append('<').append('?').append(target).append(' ').append(data).append('?').append('>');
        }

        private void startTemplateElement(String localName, Attributes attributes) throws SAXException {
            if ("param".equals(localName)) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("default");
                String type = attributes.getValue("type");
                if (this._fragment != null) {
                    this._fragment.addParameter(name, value, ParameterType.forName(type));
                } else {
                    this._builder.addParameter(name, value, ParameterType.forName(type));
                }
            } else if ("value".equals(localName)) {
                this.checkPushData();
                String name = attributes.getValue("name");
                if (name == null) {
                    this._builder.pushError("a value without a name is pointless");
                } else if (this._fragment != null) {
                    this._fragment.pushValue(name, false);
                } else {
                    this._builder.pushValue(name, false);
                }
            } else if ("fragment".equals(localName)) {
                this.checkPushData();
                String type = attributes.getValue("type");
                if (type == null) {
                    this._builder.pushError("type is required for fragment templates");
                } else {
                    this._fragment = new TFragment.Builder(type);
                }
                this.ignore = true;
            } else if ("fragment-ref".equals(localName)) {
                this.checkPushData();
                String id = attributes.getValue("id");
                String type = attributes.getValue("type");
                this._builder.pushFragmentRef(id, type);
            } else if (!"description".equals(localName)) {
                System.err.println("Found unknown template element: " + localName);
            }
        }

        private void endTemplateElement(String localName) throws SAXException {
            if ("fragment".equals(localName) && this._fragment != null) {
                this.checkPushData();
                TFragment fragment = this._fragment.build();
                this._builder.addFragment(fragment);
                this._fragment = null;
                this.ignore = false;
            }
        }

        private void startPSMLElement(String qName, Attributes attributes) throws SAXException {
            StringBuilder psml = this.buffer;
            ++this.depth;
            psml.append('<').append(qName);
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String data;
                if ("http://pageseeder.com/psml/template".equals(attributes.getURI(i))) continue;
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                psml.append(' ').append(name).append("=\"");
                Matcher m = PLACEHOLDER.matcher(value);
                int from = 0;
                while (m.find()) {
                    if (m.start() != from) {
                        data = value.substring(from, m.start());
                        this._encoder.attribute(data, psml);
                    }
                    this.checkPushData();
                    String placeholder = value.substring(m.start() + 2, m.end() - 1);
                    if (this._fragment != null) {
                        this._fragment.pushValue(placeholder, true);
                    } else {
                        this._builder.pushValue(placeholder, true);
                    }
                    from = m.end();
                }
                if (from != value.length()) {
                    data = value.substring(from, value.length());
                    this._encoder.attribute(data, psml);
                }
                psml.append('\"');
            }
            this.unclosed = true;
        }

        private void endPSMLElement(String qName) throws SAXException {
            --this.depth;
            if (this.unclosed) {
                this.buffer.append('/').append('>');
                this.unclosed = false;
            } else {
                this.buffer.append("</").append(qName).append('>');
            }
        }

        private void checkUnclosed() {
            if (this.unclosed) {
                this.buffer.append('>');
                this.unclosed = false;
            }
        }

        private void checkPushData() {
            if (this.buffer.length() > 0) {
                if (this._fragment != null) {
                    this._fragment.pushData(this.buffer.toString());
                } else {
                    this._builder.pushData(this.buffer.toString());
                }
                this.buffer.setLength(0);
            }
        }
    }
}

