/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.ParameterType;
import org.pageseeder.psml.template.TFragment;
import org.pageseeder.psml.template.Template;
import org.pageseeder.psml.template.TemplateBuilder;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.psml.template.Token;

public final class FragmentTemplate
implements Template {
    private final Charset charset;
    private final TFragment fragment;

    private FragmentTemplate(TFragment fragment, Charset charset) {
        this.fragment = Objects.requireNonNull(fragment);
        this.charset = Objects.requireNonNull(charset);
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public void process(PrintWriter psml, Map<String, String> values) {
        String id = values.get("ps.fragmentid");
        String element = this.fragment.kind();
        psml.append('<').append(element);
        if (id != null) {
            psml.append(" id=\"").append(id).append('\"');
        }
        psml.append(" type=\"").append(this.fragment.type()).append('\"');
        if (this.fragment.mediatype() != null) {
            psml.append(" mediatype=\"").append(this.fragment.mediatype()).append('\"');
        }
        psml.append('>');
        for (Token token : this.fragment.tokens()) {
            token.print(psml, values, this.charset);
        }
        psml.append("</").append(element).append('>');
        psml.flush();
    }

    @Override
    public void process(PrintWriter psml, Map<String, String> values, boolean failOnError) throws TemplateException {
        this.process(psml, values);
    }

    protected static final class Builder
    implements TemplateBuilder<FragmentTemplate> {
        private final Charset charset;
        private final String type;
        private @Nullable TFragment fragment = null;

        public Builder(Charset charset, String type) {
            this.charset = charset;
            this.type = type;
        }

        @Override
        public void addParameter(String name, String fallback, ParameterType type) {
        }

        @Override
        public void pushData(String data) {
        }

        @Override
        public void pushError(String error) {
        }

        @Override
        public void pushFragmentRef(String id, String type) {
        }

        @Override
        public void pushValue(String name, boolean attribute) {
        }

        @Override
        public void addFragment(TFragment fragment) {
            if (fragment.type().equals(this.type)) {
                this.fragment = fragment;
            }
        }

        public void setFragment(TFragment fragment) {
            this.fragment = fragment;
        }

        @Override
        public @Nullable FragmentTemplate build() {
            if (this.fragment != null) {
                return new FragmentTemplate(this.fragment, this.charset);
            }
            return null;
        }
    }
}

