/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.FragmentTemplate;
import org.pageseeder.psml.template.ParameterType;
import org.pageseeder.psml.template.TData;
import org.pageseeder.psml.template.TError;
import org.pageseeder.psml.template.TFragment;
import org.pageseeder.psml.template.TFragmentRef;
import org.pageseeder.psml.template.TValue;
import org.pageseeder.psml.template.Template;
import org.pageseeder.psml.template.TemplateBuilder;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.psml.template.Token;

public final class DocumentTemplate
implements Template {
    private final Charset charset;
    private final List<Token> tokens;
    private final Map<String, TFragment> fragments;

    private DocumentTemplate(List<Token> tokens, Map<String, TFragment> fragments, Charset charset) {
        this.tokens = new ArrayList<Token>(tokens);
        this.fragments = new HashMap<String, TFragment>(fragments);
        this.charset = charset;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public void process(PrintWriter psml, Map<String, String> values) {
        for (Token token : this.tokens) {
            token.print(psml, values, this.charset);
        }
        psml.flush();
    }

    @Override
    public void process(PrintWriter psml, Map<String, String> values, boolean failOnError) throws TemplateException {
        if (failOnError) {
            for (Token token : this.tokens) {
                if (!(token instanceof TError)) continue;
                throw new TemplateException(((TError)token).message());
            }
        }
        this.process(psml, values);
    }

    public Collection<String> getFragments() {
        return new ArrayList<String>(this.fragments.keySet());
    }

    public @Nullable FragmentTemplate getFragmentTemplate(String type) {
        TFragment frag = this.fragments.get(type);
        if (frag == null) {
            return null;
        }
        FragmentTemplate.Builder builder = new FragmentTemplate.Builder(this.charset, frag.type());
        builder.setFragment(frag);
        return builder.build();
    }

    protected static final class Builder
    implements TemplateBuilder<DocumentTemplate> {
        private final Charset charset;
        private final Map<String, ParameterType> types = new HashMap<String, ParameterType>();
        private final Map<String, TFragment> fragments = new HashMap<String, TFragment>();
        private final Map<String, String> defaults = new HashMap<String, String>();
        private final List<Token> tokens = new ArrayList<Token>();

        public Builder(Charset charset) {
            this.charset = charset;
        }

        @Override
        public void addFragment(TFragment fragment) {
            this.fragments.put(fragment.type(), fragment);
        }

        @Override
        public void addParameter(String name, @Nullable String fallback, ParameterType type) {
            this.types.put(name, type);
            if (fallback != null) {
                this.defaults.put(name, fallback);
            }
        }

        @Override
        public void pushValue(String name, boolean attribute) {
            String fallback;
            ParameterType type = this.types.get(name);
            if (type == null) {
                type = ParameterType.TEXT;
            }
            if ((fallback = this.defaults.get(name)) == null) {
                fallback = "";
            }
            this.tokens.add(new TValue(name, fallback, type, attribute));
        }

        @Override
        public void pushError(String error) {
            this.tokens.add(new TError(error));
        }

        @Override
        public void pushFragmentRef(@Nullable String id, @Nullable String type) {
            if (id == null || type == null) {
                this.tokens.add(new TError("Fragment reference must specify both id and type"));
            } else {
                TFragment fragment = this.fragments.get(type);
                if (fragment != null) {
                    this.tokens.add(new TFragmentRef(id, fragment));
                } else {
                    this.tokens.add(new TError("Unknown fragment type '" + type + "'"));
                }
            }
        }

        @Override
        public void pushData(String data) {
            this.tokens.add(new TData(data));
        }

        @Override
        public DocumentTemplate build() {
            return new DocumentTemplate(this.tokens, this.fragments, this.charset);
        }
    }
}

