/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.pageseeder.psml.process.config.IncludeExclude;
import org.pageseeder.psml.process.util.IncludesExcludesMatcher;

public abstract class IncludeExcludeConfig {
    private final List<IncludeExclude> includeExcludes = new ArrayList<IncludeExclude>();
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();

    public void addIncludeExclude(IncludeExclude toAdd) {
        this.includeExcludes.add(toAdd);
    }

    public void addInclude(String name) {
        this.includeExcludes.add(IncludeExclude.createInclude(name));
    }

    public void addExclude(String name) {
        this.includeExcludes.add(IncludeExclude.createExclude(name));
    }

    public IncludeExclude createInclude() {
        IncludeExclude inc = IncludeExclude.createInclude();
        this.includeExcludes.add(inc);
        return inc;
    }

    public IncludeExclude createExclude() {
        IncludeExclude exc = IncludeExclude.createExclude();
        this.includeExcludes.add(exc);
        return exc;
    }

    public void setExcludes(String exc) {
        if (exc != null) {
            this.excludes.addAll(Arrays.asList(exc.split(",")));
        }
    }

    public void setIncludes(String inc) {
        if (inc != null) {
            this.includes.addAll(Arrays.asList(inc.split(",")));
        }
    }

    public void addExcludes(Collection<String> exc) {
        this.excludes.addAll(exc);
    }

    public List<IncludeExclude> getIncludeExcludes() {
        return this.includeExcludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void addIncludes(Collection<String> inc) {
        this.includes.addAll(inc);
    }

    public IncludesExcludesMatcher buildMatcher() {
        IncludesExcludesMatcher matcher = new IncludesExcludesMatcher();
        matcher.addIncludePatterns(this.includes);
        matcher.addExcludePatterns(this.excludes);
        for (IncludeExclude ie : this.includeExcludes) {
            if (ie.isInclude()) {
                matcher.addIncludePattern(ie.getName());
                continue;
            }
            matcher.addExcludePattern(ie.getName());
        }
        if (!matcher.hasPatterns()) {
            return null;
        }
        return matcher;
    }
}

