/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.md.BlockParser;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.process.ImageCache;
import org.pageseeder.psml.process.NumberedTOCGenerator;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.TransclusionHandler;
import org.pageseeder.psml.process.XRefTranscluder;
import org.pageseeder.psml.process.config.Images;
import org.pageseeder.psml.process.config.Strip;
import org.pageseeder.psml.process.math.AsciiMathConverter;
import org.pageseeder.psml.process.math.TexConverter;
import org.pageseeder.psml.process.util.Files;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.DocumentTreeHandler;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLProcessHandler
extends DefaultHandler {
    private static final String CHECK_DEPTH = " (check export depth): ";
    private @Nullable Logger logger = null;
    private final Writer xml;
    private final PSMLProcessHandler parent;
    private final XRefTranscluder transcluder;
    private @Nullable Strip strip = null;
    private boolean failOnError = false;
    private boolean processed = true;
    private boolean convertMarkdown = false;
    private boolean convertAsciiMath = false;
    private boolean convertTex = false;
    private boolean errorImageNotFound = false;
    private boolean warnImageNotFound = true;
    private boolean errorXRefNotFound = false;
    private boolean warnXRefNotFound = true;
    private boolean alternateImageXRefs = false;
    private boolean embedImageMetadata = false;
    private boolean placeholders = false;
    private Images.ImageSrc imageSrc = Images.ImageSrc.LOCATION;
    private @Nullable NumberedTOCGenerator numberingAndTOC = null;
    private @Nullable PublicationConfig publicationConfig = null;
    private @Nullable ImageCache imageCache = null;
    private @Nullable String sitePrefix = null;
    private String parentFolderRelativePath;
    private final File sourceFile;
    private final File psmlRoot;
    private final File binaryRepository;
    private boolean generateTOC = false;
    private @Nullable String fragmentToLoad = null;
    private @Nullable String uriID = null;
    private @Nullable StringBuilder convertContent = null;
    private boolean convertingAsciimath = false;
    private @Nullable Integer uriCount = null;
    private Map<String, Integer> allUriIDs = new HashMap<String, Integer>();
    private Map<String, Map<String, Integer[]>> hierarchyUriFragIDs = new HashMap<String, Map<String, Integer[]>>();
    private @Nullable Map<String, String> publicationMetadata = null;
    private Map<String, String> documentMetadata = new HashMap<String, String>();
    private boolean inEmbedHierarchy = true;
    private boolean includeXMLDeclaration = true;
    private Stack<String> elements = new Stack();
    private boolean ignore = false;
    private boolean inRequiredFragment = true;
    private boolean inTranscludedXRef = false;
    private boolean inAlternateXRef = false;
    private boolean inTranscludedContent = false;
    private boolean stripCurrentXRefElement = false;
    private int level = 0;
    private @Nullable String currentFragment = null;
    private @Nullable String placeholderContent = null;
    private int preXrefLevel = 0;
    private @Nullable String preFragment = null;
    private boolean inPreTranscluded = false;
    private @Nullable String preUriID = null;
    private @Nullable Integer preUriCount = null;
    private boolean preEmbedHierarchy = false;

    public PSMLProcessHandler(Writer out, PSMLProcessHandler parent, File file, File root, File binariesFolder) {
        this.xml = out;
        this.parent = parent;
        this.sourceFile = file;
        this.psmlRoot = root;
        this.binaryRepository = binariesFolder;
        this.parentFolderRelativePath = Files.computeRelativePath(file.getParentFile(), root);
        this.transcluder = new XRefTranscluder(this);
        this.transcluder.addParentFile(file, "default");
    }

    public void setFragment(String fragment) {
        this.fragmentToLoad = fragment;
    }

    public void setAllUriIDs(Map<String, Integer> uriIDs) {
        this.allUriIDs = uriIDs;
    }

    public Map<String, Integer> getAllUriIDs() {
        return this.allUriIDs;
    }

    public void setHierarchyUriFragIDs(Map<String, Map<String, Integer[]>> uriFragIDs) {
        this.hierarchyUriFragIDs = uriFragIDs;
    }

    public Map<String, Map<String, Integer[]>> getHierarchyUriFragIDs() {
        return this.hierarchyUriFragIDs;
    }

    public @Nullable NumberedTOCGenerator getNumberedTOCGenerator() {
        return this.numberingAndTOC;
    }

    public @Nullable PublicationConfig getPublicationConfig() {
        return this.publicationConfig;
    }

    public @Nullable Map<String, String> getPublicationMetadata() {
        return this.publicationMetadata;
    }

    public boolean resolvePlaceholders() {
        return this.placeholders;
    }

    public void setURIID(String uriid) {
        this.uriID = uriid;
    }

    public void setURICount(Integer count) {
        this.uriCount = count;
    }

    public void setLogger(Logger log) {
        this.logger = log;
    }

    public void setFailOnError(boolean failonerror) {
        this.failOnError = failonerror;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setConvertMarkdown(boolean convert) {
        this.convertMarkdown = convert;
    }

    public void setEmbedLinkMetadata(boolean embed) {
        this.transcluder.setTranscludeLinks(embed);
    }

    public void setConvertAsciiMath(boolean convert) {
        this.convertAsciiMath = convert;
    }

    public void setConvertTex(boolean convert) {
        this.convertTex = convert;
    }

    public void setIncludeXMLDeclaration(boolean include) {
        this.includeXMLDeclaration = include;
    }

    public void setInEmbedHierarchy(boolean embed) {
        this.inEmbedHierarchy = embed;
    }

    public void setInTranscludedContent(boolean transclude) {
        this.inTranscludedContent = transclude;
    }

    public void setLevel(int lvl) {
        this.level = lvl;
    }

    public void setXRefsHandling(List<String> xrefTypes, boolean excludeXRefFragment, boolean onlyXRefFrament, boolean errornotfound, boolean warnnotfound) {
        this.transcluder.addXRefsTypes(xrefTypes);
        this.transcluder.setXRefFragmentHandling(excludeXRefFragment, onlyXRefFrament);
        this.errorXRefNotFound = errornotfound;
        this.warnXRefNotFound = warnnotfound;
    }

    public void addUriFragID(@Nullable String uriid, @Nullable String fragid, boolean embed) {
        this.addKeyUriFragID(this.uriCount + "_" + this.uriID, uriid, fragid, embed);
        if (this.parent != null && !this.inAlternateXRef) {
            this.parent.addUriFragID(uriid, fragid, embed);
        }
    }

    public void addKeyUriFragID(String key, @Nullable String uriid, @Nullable String fragid, boolean embed) {
        if (this.inAlternateXRef) {
            return;
        }
        Map<String, Integer[]> subHierarchy = this.hierarchyUriFragIDs.get(key);
        Integer globalCount = this.allUriIDs.get(uriid);
        Integer[] counts = null;
        if (subHierarchy == null) {
            subHierarchy = new HashMap<String, Integer[]>();
            this.hierarchyUriFragIDs.put(key, subHierarchy);
        } else {
            counts = subHierarchy.get(uriid + (String)(fragid == null ? "" : "-" + fragid));
        }
        if (counts == null) {
            counts = new Integer[]{globalCount, 1, embed ? 1 : 0};
            subHierarchy.put(uriid + (String)(fragid == null ? "" : "-" + fragid), counts);
        } else {
            counts[1] = counts[1] + 1;
            if (embed) {
                if (counts[2] == 0) {
                    counts[0] = globalCount;
                }
                counts[2] = counts[2] + 1;
            }
        }
    }

    public XRefTranscluder getTranscluder() {
        return this.transcluder;
    }

    public void setStrip(Strip strip) {
        this.strip = strip;
    }

    public void setPublicationConfig(PublicationConfig config, File root, boolean toc) throws ProcessException {
        XMLStringWriter out = new XMLStringWriter(XML.NamespaceAware.No);
        TransclusionHandler thandler = new TransclusionHandler((XMLWriter)out, "default", true, this);
        XMLUtils.parse(root, (ContentHandler)thandler);
        this.publicationMetadata = thandler.getPublicationMetadata();
        DocumentTreeHandler tochandler = new DocumentTreeHandler();
        XMLUtils.parse(new InputSource(new StringReader(out.toString())), (ContentHandler)tochandler, null, null);
        DocumentTree tree = (DocumentTree)tochandler.get();
        if (tree != null) {
            tree = tree.normalize(config.getTocTitleCollapse());
            this.numberingAndTOC = new NumberedTOCGenerator(new PublicationTree(tree));
            this.publicationConfig = config;
            this.generateTOC = toc;
        }
    }

    public void setImageHandling(@Nullable ImageCache cache, Images.ImageSrc src, boolean errorNotFound, boolean warnNotFound, @Nullable String siteprefix, boolean embedMetadata) {
        if (src != Images.ImageSrc.LOCATION && cache == null) {
            throw new IllegalArgumentException("Required images metadata cache is missing");
        }
        if (src == Images.ImageSrc.PERMALINK && siteprefix == null) {
            throw new IllegalArgumentException("Site prefix missing");
        }
        this.imageSrc = src;
        this.errorImageNotFound = errorNotFound;
        this.warnImageNotFound = warnNotFound;
        this.imageCache = cache;
        this.sitePrefix = siteprefix;
        this.embedImageMetadata = embedMetadata;
        this.transcluder.setTranscludeImages(embedMetadata);
    }

    public void setPlaceholders(boolean resolve) {
        this.placeholders = resolve;
    }

    public void setPublicationMetadata(Map<String, String> metadata) {
        this.publicationMetadata = metadata;
    }

    public void setDocumentMetadata(Map<String, String> metadata) {
        this.documentMetadata = metadata;
    }

    public File getBinaryRepository() {
        return this.binaryRepository;
    }

    public File getPSMLRoot() {
        return this.psmlRoot;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean inAlternateXRef() {
        return this.inAlternateXRef;
    }

    public String getParentFolderRelativePath() {
        return this.parentFolderRelativePath;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public boolean getErrorXRefNotFound() {
        return this.errorXRefNotFound;
    }

    public boolean getWarnXRefNotFound() {
        return this.warnXRefNotFound;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.includeXMLDeclaration) {
            try {
                this.xml.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write XML declaration ", ex);
            }
        }
        if (this.fragmentToLoad != null) {
            this.inRequiredFragment = false;
        }
    }

    @Override
    public void startElement(@Nullable String uri, String localName, String qName, Attributes atts) throws SAXException {
        String relpath;
        boolean isMetadataProperty;
        boolean isFragment;
        String dad;
        boolean noNamespace;
        boolean bl = noNamespace = uri == null || uri.isEmpty();
        if (this.uriID == null && noNamespace && "document".equals(qName)) {
            this.uriID = atts.getValue("id");
            this.uriCount = 1;
            this.allUriIDs.put(this.uriID, 1);
            this.addUriFragID(this.uriID, null, this.inEmbedHierarchy);
        }
        String string = dad = this.elements.isEmpty() ? null : this.elements.peek();
        if ("documentinfo".equals(dad) && "uri".equals(qName) && "true".equals(atts.getValue("external"))) {
            this.parentFolderRelativePath = "";
        }
        if (this.preXrefLevel == 1 && !this.inPreTranscluded) {
            this.inPreTranscluded = true;
            Integer count = this.allUriIDs.get(this.uriID);
            if (count == null) {
                count = 0;
            }
            if (!this.inAlternateXRef) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                this.allUriIDs.put(this.uriID, count);
            }
            this.uriCount = count;
            if (!"default".equals(this.preFragment)) {
                this.addUriFragID(this.uriID, this.preFragment, false);
                this.addKeyUriFragID(this.preUriCount + "_" + this.preUriID, this.uriID, this.preFragment, false);
                this.write("<document-fragment uriid=\"" + XMLUtils.escapeForAttribute(this.uriID) + "\">");
            } else {
                this.addUriFragID(this.uriID, null, false);
                this.addKeyUriFragID(this.preUriCount + "_" + this.preUriID, this.uriID, null, false);
            }
        }
        if (this.fragmentToLoad != null && "document".equals(qName)) {
            this.write("<document-fragment uriid=\"" + XMLUtils.escapeForAttribute(this.uriID) + "\">");
        }
        boolean bl2 = isFragment = noNamespace && this.isFragment(qName);
        if (!this.inRequiredFragment) {
            if (isFragment && this.fragmentToLoad != null && this.fragmentToLoad.equals(atts.getValue("id")) && !this.elements.contains("compare") || noNamespace && this.fragmentToLoad != null && "locator".equals(qName) && this.fragmentToLoad.equals(atts.getValue("fragment"))) {
                this.inRequiredFragment = true;
            } else {
                return;
            }
        }
        boolean isXRef = noNamespace && ("blockxref".equals(qName) || "xref".equals(qName));
        boolean isReverseXRef = noNamespace && "reversexref".equals(qName);
        boolean isImage = noNamespace && "image".equals(qName);
        boolean isLink = noNamespace && "link".equals(qName);
        boolean bl3 = isMetadataProperty = noNamespace && "property".equals(qName) && "properties".equals(this.elements.peek());
        if (this.ignore) {
            return;
        }
        if (noNamespace && this.shouldStripElement(qName)) {
            this.ignore = true;
            return;
        }
        if (isXRef && this.strip != null && this.shouldStripXRef(qName, atts)) {
            return;
        }
        if (this.convertAsciiMath && noNamespace && "inline".equals(qName) && "asciimath".equals(atts.getValue("label")) || this.convertTex && noNamespace && "inline".equals(qName) && "tex".equals(atts.getValue("label"))) {
            this.convertContent = new StringBuilder();
            this.convertingAsciimath = "asciimath".equals(atts.getValue("label"));
            return;
        }
        if (this.convertAsciiMath && noNamespace && "media-fragment".equals(qName) && "text/asciimath".equals(atts.getValue("mediatype")) || this.convertTex && noNamespace && "media-fragment".equals(qName) && "application/x-tex".equals(atts.getValue("mediatype"))) {
            String id = this.uriID == null || !this.transcluder.isTranscluding() ? atts.getValue("id") : this.uriID + "-" + atts.getValue("id");
            this.write("<media-fragment id=\"" + XMLUtils.escapeForAttribute(id) + "\" mediatype=\"application/mathml+xml\">");
            this.convertContent = new StringBuilder();
            this.convertingAsciimath = "text/asciimath".equals(atts.getValue("mediatype"));
            return;
        }
        if (this.placeholders) {
            if (this.placeholderContent != null) {
                return;
            }
            if ("publication".equals(qName) && this.parent == null) {
                this.publicationMetadata = new HashMap<String, String>();
                this.documentMetadata = null;
            } else if (isMetadataProperty && !this.inTranscludedContent && atts.getValue("name") != null && (atts.getValue("datatype") == null || "text".equals(atts.getValue("datatype")) || "date".equals(atts.getValue("datatype")) || "datetime".equals(atts.getValue("datatype"))) && (atts.getValue("count") == null || "1".equals(atts.getValue("count"))) && atts.getValue("multiple") == null) {
                String value;
                String string2 = value = atts.getValue("value") == null ? "" : atts.getValue("value");
                if (this.documentMetadata == null) {
                    this.publicationMetadata.put(atts.getValue("name"), value);
                } else {
                    this.documentMetadata.put(atts.getValue("name"), value);
                }
            } else if ("placeholder".equals(qName) && atts.getValue("name") != null) {
                String name = atts.getValue("name");
                if (this.publicationMetadata != null) {
                    this.placeholderContent = this.publicationMetadata.get(name);
                } else if (this.documentMetadata != null) {
                    this.placeholderContent = this.documentMetadata.get(name);
                }
            }
        }
        if (isFragment && !this.elements.contains("compare")) {
            this.currentFragment = atts.getValue("id");
        }
        this.write("<" + qName);
        int headingLevel = -1;
        String uriid = atts.getValue("uriid");
        for (int i = 0; i < atts.getLength(); ++i) {
            String value;
            boolean rewriteXRefHRef;
            boolean noAttNamespace;
            String name = atts.getQName(i);
            boolean bl4 = noAttNamespace = atts.getURI(i) == null || atts.getURI(i).isEmpty();
            if (noNamespace && noAttNamespace && this.shouldStripAttribute(qName, name)) continue;
            boolean rewriteImageSrc = noAttNamespace && "image".equals(qName) && noNamespace && "src".equals(name);
            boolean bl5 = rewriteXRefHRef = noAttNamespace && "xref".equals(qName) && noNamespace && "href".equals(name) && this.alternateImageXRefs && "alternate".equals(atts.getValue("type")) && atts.getValue("mediatype") != null && atts.getValue("mediatype").startsWith("image/");
            if (rewriteImageSrc || rewriteXRefHRef) {
                try {
                    this.handleImage(atts.getValue(i), uriid, rewriteXRefHRef);
                }
                catch (ProcessException ex) {
                    if (this.failOnError) {
                        throw new SAXException("Failed to rewrite src attribute " + atts.getValue(i) + ": " + ex.getMessage(), ex);
                    }
                    this.logger.warn("Failed to rewrite image src attribute {}: {}", (Object)atts.getValue(i), (Object)ex.getMessage());
                }
                continue;
            }
            if ("fragment".equals(name) && noNamespace && "locator".equals(qName) && this.transcluder.isTranscluding()) {
                value = this.uriID == null ? atts.getValue(i) : this.uriID + "-" + atts.getValue(i);
            } else if ("id".equals(name) && noNamespace && "section".equals(qName) && this.transcluder.isTranscluding()) {
                value = this.uriID == null ? atts.getValue(i) : this.uriID + "-" + atts.getValue(i);
            } else if ("id".equals(name) && isFragment && this.transcluder.isTranscluding()) {
                value = this.uriID == null ? atts.getValue(i) : this.uriID + "-" + atts.getValue(i);
            } else if (this.processed && "level".equals(name) && "document".equals(qName)) {
                value = "processed";
            } else if (this.processed && "href".equals(name) && (isXRef || isReverseXRef)) {
                try {
                    value = URLDecoder.decode(atts.getValue(i), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = null;
                }
            } else if ("level".equals(name) && "heading".equals(qName)) {
                headingLevel = Integer.parseInt(atts.getValue(name));
                if (this.level > 0) {
                    headingLevel += this.level;
                }
                value = String.valueOf(headingLevel);
            } else {
                value = atts.getValue(i);
            }
            this.write(" " + name + "=\"" + XMLUtils.escapeForAttribute(value) + "\"");
        }
        if (this.uriID != null && "document".equals(qName) && atts.getValue("id") == null) {
            this.write(" id=\"" + XMLUtils.escapeForAttribute(this.uriID) + "\"");
        }
        if ((isXRef || isReverseXRef) && !"true".equals(atts.getValue("external")) && !"true".equals(atts.getValue("unresolved")) && (relpath = this.transcluder.findXRefRelativePath(atts.getValue("href"))) != null) {
            this.write(" relpath=\"" + XMLUtils.escapeForAttribute(relpath) + "\"");
        }
        if (this.placeholders && "placeholder".equals(qName) && this.placeholderContent == null) {
            this.write(" unresolved=\"true\"");
        }
        this.write(">");
        this.elements.push(qName);
        if (this.convertMarkdown && noNamespace && "markdown".equals(qName)) {
            this.convertContent = new StringBuilder();
        }
        if (isXRef && this.preXrefLevel > 0) {
            ++this.preXrefLevel;
        }
        if ((isXRef || isImage || isLink) && !this.elements.contains("compare")) {
            this.transcludeXRef(atts, isImage, isLink);
        }
    }

    @Override
    public void endElement(@Nullable String uri, String localName, String qName) throws SAXException {
        boolean isXRef;
        if (this.placeholderContent != null) {
            if ("placeholder".equals(qName)) {
                this.write(XMLUtils.escape(this.placeholderContent));
                this.placeholderContent = null;
            } else {
                return;
            }
        }
        if (this.fragmentToLoad != null && "document".equals(qName)) {
            this.write("</document-fragment>");
        }
        if (!this.inRequiredFragment) {
            return;
        }
        if (this.shouldStripElement(qName)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        this.inTranscludedXRef = false;
        boolean bl = isXRef = !(uri != null && !uri.isEmpty() || !"blockxref".equals(qName) && !"xref".equals(qName));
        if (isXRef) {
            if (this.preXrefLevel == 1) {
                if (this.inPreTranscluded && !"default".equals(this.preFragment)) {
                    this.write("</document-fragment>");
                }
                this.uriID = this.preUriID;
                this.uriCount = this.preUriCount;
                this.inEmbedHierarchy = this.preEmbedHierarchy;
                this.inTranscludedContent = false;
                this.preXrefLevel = 0;
                this.inPreTranscluded = false;
            } else if (this.preXrefLevel > 0) {
                --this.preXrefLevel;
            }
        }
        if (isXRef && this.stripCurrentXRefElement) {
            if ("blockxref".equals(qName)) {
                this.write("</para>");
            }
            this.stripCurrentXRefElement = false;
            return;
        }
        try {
            if ((this.convertAsciiMath || this.convertTex) && (uri == null || uri.isEmpty()) && "inline".equals(qName) && this.convertContent != null) {
                this.write("<xref frag=\"media\" type=\"math\" config=\"mathml\"><media-fragment id=\"media\" mediatype=\"application/mathml+xml\">");
                this.write(this.convertingAsciimath ? AsciiMathConverter.convert(this.convertContent.toString()) : TexConverter.convert(this.convertContent.toString()));
                this.write("</media-fragment></xref>");
                this.convertContent = null;
                return;
            }
            if ((this.convertAsciiMath || this.convertTex) && (uri == null || uri.isEmpty()) && "media-fragment".equals(qName) && this.convertContent != null) {
                this.write(this.convertingAsciimath ? AsciiMathConverter.convert(this.convertContent.toString()) : TexConverter.convert(this.convertContent.toString()));
                this.write("</media-fragment>");
                this.convertContent = null;
                if (this.fragmentToLoad != null) {
                    this.inRequiredFragment = false;
                }
                return;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("File " + this.sourceFile.getName() + ": " + ex.getMessage());
        }
        if (this.convertMarkdown && (uri == null || uri.isEmpty()) && "markdown".equals(qName) && this.convertContent != null) {
            this.write(this.markdownToPSML(this.convertContent.toString()));
            this.convertContent = null;
        }
        this.elements.pop();
        this.write("</" + qName + ">");
        if (this.isFragment(qName) && !this.elements.contains("compare")) {
            this.currentFragment = null;
            if (this.fragmentToLoad != null) {
                this.inRequiredFragment = false;
            }
        } else if ("locator".equals(qName) && this.fragmentToLoad != null) {
            this.inRequiredFragment = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignore || !this.inRequiredFragment || this.inTranscludedXRef || this.placeholderContent != null) {
            return;
        }
        if ((this.convertAsciiMath || this.convertMarkdown || this.convertTex) && this.convertContent != null) {
            this.convertContent.append(ch, start, length);
        } else {
            this.write(XMLUtils.escape(new String(ch, start, length)));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new SAXException("Failed to flush XML writer ", ex);
        }
    }

    protected PSMLProcessHandler cloneForTransclusion(File toParse, String uriid, String fragment, int lvl, boolean fromImage, boolean embed, boolean transclude, boolean alternate) {
        Integer count = this.allUriIDs.get(uriid);
        if (count == null) {
            count = 0;
        }
        if (!alternate && !this.inAlternateXRef) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.allUriIDs.put(uriid, count);
        }
        PSMLProcessHandler handler = new PSMLProcessHandler(this.xml, this, toParse, this.psmlRoot, this.binaryRepository);
        handler.setLevel(lvl + (this.numberingAndTOC == null ? this.level : 0));
        handler.transcluder.addParentFile(this.sourceFile, this.currentFragment);
        handler.transcluder.addParentFile(this.sourceFile, "default");
        handler.setIncludeXMLDeclaration(false);
        handler.setImageHandling(this.imageCache, this.imageSrc, this.errorImageNotFound, this.warnImageNotFound, this.sitePrefix, this.embedImageMetadata);
        handler.setStrip(this.strip);
        handler.setLogger(this.logger);
        handler.setFailOnError(this.failOnError);
        handler.setProcessed(this.processed);
        handler.setXRefsHandling(this.transcluder.xrefsTranscludeTypes, this.transcluder.excludeXRefFragment, this.transcluder.onlyXRefFrament, this.errorXRefNotFound, this.warnXRefNotFound);
        handler.alternateImageXRefs = fromImage;
        handler.inAlternateXRef = alternate;
        handler.setURIID(uriid);
        handler.setURICount(count);
        handler.generateTOC = this.generateTOC;
        handler.setAllUriIDs(this.allUriIDs);
        handler.setHierarchyUriFragIDs(this.hierarchyUriFragIDs);
        handler.setInEmbedHierarchy(embed);
        handler.setInTranscludedContent(transclude);
        handler.numberingAndTOC = this.numberingAndTOC;
        handler.publicationConfig = this.publicationConfig;
        handler.setConvertMarkdown(this.convertMarkdown);
        handler.setConvertAsciiMath(this.convertAsciiMath);
        handler.setConvertTex(this.convertTex);
        handler.setPlaceholders(this.placeholders);
        handler.setPublicationMetadata(this.publicationMetadata);
        if (transclude) {
            handler.setDocumentMetadata(this.documentMetadata);
        }
        if (fragment != null && !"default".equals(fragment)) {
            handler.setFragment(fragment);
            handler.addUriFragID(uriid, fragment, embed);
        } else {
            handler.addUriFragID(uriid, null, embed);
        }
        return handler;
    }

    public void writeFileContents(File f) throws ProcessException {
        try (FileInputStream in = new FileInputStream(f);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                String s = new String(buffer, 0, read, StandardCharsets.UTF_8);
                if (s.charAt(0) == '\ufeff') {
                    s = s.substring(1);
                }
                if ("<?xml ".equals(s.substring(0, 6))) {
                    s = s.substring(s.indexOf(">") + 1);
                }
                this.xml.write(s);
            }
        }
        catch (IOException ex) {
            if (this.failOnError) {
                throw new ProcessException("Failed to write contents of file " + f.getName() + ": " + ex.getMessage(), ex);
            }
            this.logger.warn("Failed to write contents of file {}: {}", (Object)f.getName(), (Object)ex.getMessage());
        }
    }

    public void write(String str) throws SAXException {
        try {
            this.xml.write(str);
        }
        catch (IOException e) {
            throw new SAXException("Failed to write XMl content to the writer", e);
        }
    }

    private boolean shouldStripXRef(String qName, Attributes atts) throws SAXException {
        if (this.strip.stripAllXRefs() || this.strip.stripUnresolvedXRefs() && "true".equals(atts.getValue("unresolved"))) {
            if ("blockxref".equals(qName)) {
                this.write("<para>");
            }
            this.stripCurrentXRefElement = true;
            return true;
        }
        if (this.strip.stripNotFoundXRefs() && !"true".equals(atts.getValue("external")) && !"true".equals(atts.getValue("unresolved")) && this.transcluder.isNotFoundXRef(atts.getValue("href"))) {
            String href = atts.getValue("href");
            PSMLProcessHandler.handleError("XRef target not found in URI " + this.uriID + (String)(href != null ? CHECK_DEPTH + href : ""), this.failOnError, this.logger, this.errorXRefNotFound, this.warnXRefNotFound);
            if ("blockxref".equals(qName)) {
                this.write("<para>");
            }
            this.stripCurrentXRefElement = true;
            return true;
        }
        return false;
    }

    private void transcludeXRef(Attributes atts, boolean image, boolean link) throws SAXException {
        String type = atts.getValue("type");
        if ("transclude".equals(type) && this.inTranscludedContent) {
            return;
        }
        String href = atts.getValue(image ? "src" : "href");
        try {
            boolean isInXRefFragment = false;
            if (!image && !link) {
                for (int i = this.elements.size() - 1; i >= 0; --i) {
                    String elem = (String)this.elements.elementAt(i);
                    if (!this.isFragment(elem)) continue;
                    isInXRefFragment = "xref-fragment".equals(elem);
                    break;
                }
            }
            String uriid = atts.getValue("uriid");
            if (this.transcluder.transcludeXRef(atts, isInXRefFragment, image, link, this.inEmbedHierarchy, this.convertTex)) {
                this.inTranscludedXRef = !link;
            } else if (this.preXrefLevel == 0 && !image && !link && uriid != null && ("transclude".equals(type) || "math".equals(type))) {
                this.preXrefLevel = 1;
                this.preFragment = atts.getValue("frag");
                this.preUriID = this.uriID;
                this.preUriCount = this.uriCount;
                this.preEmbedHierarchy = this.inEmbedHierarchy;
                this.uriID = uriid;
                this.inEmbedHierarchy = false;
                this.inTranscludedContent = true;
            }
        }
        catch (XRefTranscluder.InfiniteLoopException ex) {
            String tgt;
            String src;
            File root_src = this.sourceFile;
            PSMLProcessHandler parent = this.parent;
            while (parent != null) {
                root_src = parent.sourceFile;
                parent = parent.parent;
            }
            try {
                src = this.sourceFile.getCanonicalPath().substring(this.psmlRoot.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
                tgt = new File(this.sourceFile.getParent(), href).getCanonicalPath().substring(this.psmlRoot.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
            }
            catch (IOException e) {
                src = this.sourceFile.getName();
                tgt = href;
            }
            String error = "Reference loop detected when resolving xref" + (String)(atts.getValue("urititle") == null ? "" : " " + atts.getValue("urititle")) + " from " + src + " (URIID " + this.uriID + ") to " + tgt + (String)(atts.getValue("uriid") == null ? "" : " (URIID " + atts.getValue("uriid") + ").");
            if (this.failOnError) {
                throw new SAXException(error);
            }
            this.logger.error(error);
        }
        catch (XRefTranscluder.TooDeepException ex) {
            String tgt;
            String src;
            try {
                src = this.sourceFile.getCanonicalPath().substring(this.psmlRoot.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
                tgt = new File(this.sourceFile.getParent(), href).getCanonicalPath().substring(this.psmlRoot.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
            }
            catch (IOException e) {
                src = this.sourceFile.getName();
                tgt = href;
            }
            throw new SAXException("Transclusion/embed depth is too big (max is 50) for XRef from " + src + " to " + tgt + ".");
        }
        catch (XRefTranscluder.XRefNotFoundException ex) {
            PSMLProcessHandler.handleError("XRef target not found in URI " + this.uriID + (String)(href != null ? CHECK_DEPTH + href : ""), this.failOnError, this.logger, this.errorXRefNotFound, this.warnXRefNotFound);
        }
        catch (ProcessException ex) {
            if (this.failOnError) {
                throw new SAXException("Failed to resolve XRef reference " + href + ": " + ex.getMessage(), ex);
            }
            this.logger.warn("Failed to resolve XRef reference {}: {}", (Object)href, (Object)ex.getMessage());
        }
    }

    public static void handleError(String message, boolean fail, Logger log, boolean error, boolean warn) throws SAXException {
        if (error && fail) {
            throw new SAXException(message);
        }
        if (error) {
            log.error(message);
        } else if (warn) {
            log.warn(message);
        }
    }

    public boolean isFragment(String element) {
        return "fragment".equals(element) || "media-fragment".equals(element) || "xref-fragment".equals(element) || "properties-fragment".equals(element);
    }

    private boolean shouldStripElement(String elemName) {
        if (this.strip == null) {
            return false;
        }
        if (this.strip.stripDocumentInfo() && "documentinfo".equals(elemName)) {
            return true;
        }
        if (this.strip.stripFragmentInfo() && "fragmentinfo".equals(elemName)) {
            return true;
        }
        String dad = this.elements.isEmpty() ? null : this.elements.pop();
        String granddad = this.elements.isEmpty() ? null : this.elements.peek();
        this.elements.push(dad);
        if ((this.strip.stripReverseXRefs() || this.strip.stripAllXRefs()) && "reversexrefs".equals(elemName) && ("documentinfo".equals(dad) || "locator".equals(dad))) {
            return true;
        }
        if ("documentinfo".equals(granddad) && "uri".equals(dad)) {
            if (this.strip.stripDocumentInfoDescription() && "description".equals(elemName)) {
                return true;
            }
            if (this.strip.stripDocumentInfoLabels() && "labels".equals(elemName)) {
                return true;
            }
            if (this.strip.stripDocumentInfoTitle() && "displaytitle".equals(elemName)) {
                return true;
            }
        } else if ("documentinfo".equals(dad)) {
            if (this.strip.stripDocumentInfoPublication() && "publication".equals(elemName)) {
                return true;
            }
            if (this.strip.stripDocumentInfoVersions() && "versions".equals(elemName)) {
                return true;
            }
        } else if ("locator".equals(dad) && this.strip.stripFragmentInfoLabels() && "labels".equals(elemName)) {
            return true;
        }
        return false;
    }

    private boolean shouldStripAttribute(String elemName, String attName) {
        String dad;
        if (this.strip == null) {
            return false;
        }
        if ((this.strip.stripXRefsDocID() && "docid".equals(attName) || this.strip.stripXRefsURIID() && "uriid".equals(attName)) && ("xref".equals(elemName) || "blockxref".equals(elemName))) {
            return true;
        }
        if ("image".equals(elemName)) {
            if (this.strip.stripImagesURIID() && "uriid".equals(attName)) {
                return true;
            }
            if (this.strip.stripImagesDocID() && "docid".equals(attName)) {
                return true;
            }
        }
        String string = dad = this.elements.isEmpty() ? null : this.elements.peek();
        if ("documentinfo".equals(dad) && "uri".equals(elemName)) {
            if (this.strip.stripDocumentInfoDocID() && "docid".equals(attName)) {
                return true;
            }
            if (this.strip.stripDocumentInfoTitle() && "title".equals(attName)) {
                return true;
            }
        }
        return false;
    }

    private void handleImage(String src, @Nullable String uriid, boolean alternateXRef) throws ProcessException, SAXException {
        this.logger.debug("Handling image {} ({})", (Object)src, (Object)uriid);
        Object finalSrc = URLDecoder.decode(src, StandardCharsets.UTF_8);
        this.logger.debug("Decoded src is {}", finalSrc);
        Object relativePath = this.cleanUpParentFolder() + "/" + (String)finalSrc;
        this.logger.debug("Image file relative path is {}", relativePath);
        File imageFile = new File(this.binaryRepository, (String)relativePath);
        if (!imageFile.exists() || !imageFile.isFile()) {
            PSMLProcessHandler.handleError("Image not found in URI " + this.uriID + " with src " + src + " and URI ID " + uriid, this.failOnError, this.logger, this.errorImageNotFound, this.warnImageNotFound);
        }
        if (uriid == null) {
            this.logger.warn("Unresolved image in URI {} with src {}", (Object)this.uriID, (Object)src);
        }
        if ((relativePath = Files.computeRelativePath(imageFile, this.binaryRepository)) == null) {
            this.logger.debug("Could not compute relative path for image src {} ({})", finalSrc, (Object)uriid);
        } else if (this.imageSrc != Images.ImageSrc.LOCATION) {
            String suffix = null;
            if (uriid != null) {
                suffix = this.imageCache.getImageNewPath((String)relativePath, this.imageSrc, uriid);
            } else if (this.imageCache != null) {
                suffix = this.imageCache.getImageNewPath((String)relativePath, this.imageSrc);
            }
            if (suffix != null) {
                finalSrc = (String)(this.imageSrc == Images.ImageSrc.PERMALINK ? this.sitePrefix + "/uri/" : "") + suffix;
            }
            this.logger.debug("Rewriting image src {} to {}", relativePath, finalSrc);
        } else {
            if (this.imageCache != null) {
                this.imageCache.cacheImagePath((String)relativePath);
            }
            this.write(" " + (alternateXRef ? "xhref" : "href") + "=\"" + XMLUtils.escapeForAttribute((String)relativePath) + "\"");
        }
        if (!this.processed && this.imageSrc != Images.ImageSrc.FILENAMEENCODE) {
            finalSrc = PSMLProcessHandler.URLEncodeFilepath((String)finalSrc);
        }
        this.write(" " + (alternateXRef ? "href" : "src") + "=\"" + XMLUtils.escapeForAttribute((String)finalSrc) + "\"");
    }

    public static String URLEncodeFilepath(String filepath) {
        StringBuilder path = new StringBuilder();
        String fp = filepath;
        while (fp.indexOf(47) != -1) {
            path.append(URLEncoder.encode(fp.substring(0, fp.indexOf(47)), StandardCharsets.UTF_8)).append('/');
            fp = fp.substring(1 + fp.indexOf(47));
        }
        return path.append(URLEncoder.encode(fp, StandardCharsets.UTF_8)).toString().replace("+", "%20");
    }

    private String markdownToPSML(String markdown) {
        BlockParser parser = new BlockParser();
        XMLStringWriter result = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            List<PSMLElement> psml = parser.parse(Arrays.asList(markdown.split("\n")));
            for (PSMLElement elem : psml) {
                elem.toXML((XMLWriter)result);
            }
        }
        catch (IOException ex) {
            this.logger.warn("Failed to convert markdown to PSML", (Throwable)ex);
        }
        return result.toString();
    }

    public String cleanUpParentFolder() {
        return this.parentFolderRelativePath.replaceFirst("^META-INF", "");
    }
}

