/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.Heading;
import org.pageseeder.psml.toc.Paragraph;
import org.pageseeder.psml.toc.Part;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.psml.toc.Toc;
import org.pageseeder.psml.toc.TransclusionEnd;
import org.pageseeder.xmlwriter.XMLWriter;

public class NumberedTOCGenerator {
    private PublicationTree publicationTree;
    private @Nullable FragmentNumbering fragmentNumbering = null;
    private final Map<Long, DocumentTree> addTrees = new HashMap<Long, DocumentTree>();
    private boolean afterTocElement = false;
    private int openElements = 0;

    public NumberedTOCGenerator(PublicationTree tree) {
        this.publicationTree = tree;
    }

    public void setFragmentNumbering(FragmentNumbering numbering) {
        this.fragmentNumbering = numbering;
    }

    public PublicationTree publicationTree() {
        return this.publicationTree;
    }

    public FragmentNumbering fragmentNumbering() {
        return this.fragmentNumbering;
    }

    public void addTree(DocumentTree tree) {
        this.addTrees.put(tree.id(), tree);
    }

    public void updatePublication() {
        this.publicationTree = this.publicationTree.modify(Collections.emptyList(), this.addTrees, this.publicationTree.root().id());
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("toc-tree", true);
        this.afterTocElement = false;
        this.openElements = 0;
        DocumentTree root = this.publicationTree.root();
        if (root != null) {
            xml.attribute("title", root.title());
            HashMap<Long, Integer> doccount = new HashMap<Long, Integer>();
            this.toXML(xml, root.id(), 1, doccount, 1, new ArrayList<String>(), "default");
        }
        xml.closeElement();
    }

    private void toXML(XMLWriter xml, long id, int level, Map<Long, Integer> doccount, Integer count, List<String> ancestors, String fragment) throws IOException {
        String key = id + "-" + fragment;
        if (ancestors.contains(key)) {
            throw new IllegalStateException("XRef loop detected on URIID-fragment " + key);
        }
        ancestors.add(key);
        DocumentTree current = this.publicationTree.tree(id);
        if (!"default".equals(fragment)) {
            current = current.singleFragmentTree(fragment);
        }
        for (Part<?> part : current.parts()) {
            this.toXML(xml, id, level, part, doccount, count, ancestors);
        }
        ancestors.remove(key);
    }

    private void toXML(XMLWriter xml, long id, int level, Part<?> part, Map<Long, Integer> doccount, Integer count, List<String> ancestors) throws IOException {
        Object element = part.element();
        if (element instanceof Paragraph || element instanceof TransclusionEnd) {
            return;
        }
        if (element instanceof Toc) {
            this.afterTocElement = true;
            return;
        }
        boolean toNext = false;
        Long next = null;
        DocumentTree nextTree = null;
        String targetFragment = "default";
        Reference.Type refType = Reference.Type.EMBED;
        if (element instanceof Reference) {
            Reference ref = (Reference)element;
            targetFragment = ref.targetfragment();
            refType = ref.type();
            next = ref.uri();
            nextTree = this.publicationTree.tree(next);
            toNext = nextTree != null && Reference.Type.EMBED.equals((Object)refType);
        }
        Integer nextcount = null;
        if (toNext || Reference.Type.TRANSCLUDE.equals((Object)refType)) {
            if (nextTree != null) {
                nextcount = doccount.get(next);
                nextcount = nextcount == null ? 1 : nextcount + 1;
                doccount.put(next, nextcount);
            }
            if (Reference.Type.EMBED.equals((Object)refType)) {
                if ("default".equals(targetFragment)) {
                    this.referenceToXML(xml, level, (Reference)element, next, nextcount, nextTree, !part.parts().isEmpty() || toNext);
                } else {
                    this.partToXML(xml, level, !part.parts().isEmpty() || toNext);
                }
            }
        } else if (element instanceof Heading) {
            this.headingToXML(xml, level, (Heading)element, id, count, !part.parts().isEmpty());
        } else {
            this.partToXML(xml, level, !part.parts().isEmpty());
        }
        if (toNext) {
            this.toXML(xml, (long)next, level + 1, doccount, nextcount, ancestors, targetFragment);
        }
        for (Part<?> r : part.parts()) {
            this.toXML(xml, id, level + 1, r, doccount, count, ancestors);
        }
        if (!Reference.Type.TRANSCLUDE.equals((Object)refType) && this.openElements > 0) {
            --this.openElements;
            xml.closeElement();
        }
    }

    public void partToXML(XMLWriter xml, int level, boolean children) throws IOException {
        if (!this.afterTocElement) {
            return;
        }
        ++this.openElements;
        xml.openElement("toc-part", children);
        xml.attribute("level", level);
    }

    public void referenceToXML(XMLWriter xml, int level, Reference ref, long treeid, int count, DocumentTree target, boolean children) throws IOException {
        if (!this.afterTocElement) {
            return;
        }
        ++this.openElements;
        xml.openElement("toc-part", children);
        xml.attribute("level", level);
        if (ref.displaydocument() != null && ref.displaydocument().booleanValue()) {
            xml.attribute("title", target.title());
        } else {
            xml.attribute("title", ref.title());
        }
        if (target.numbered() && this.fragmentNumbering != null) {
            FragmentNumbering.Prefix pref = this.fragmentNumbering.getPrefix(treeid, count);
            if (pref != null) {
                xml.attribute("prefix", pref.value);
                xml.attribute("canonical", pref.canonical);
            }
        } else if (!"".equals(target.prefix())) {
            xml.attribute("prefix", target.prefix());
        }
        if (!"".equals(target.titlefragment())) {
            xml.attribute("idref", treeid + "-" + count + "-" + target.titlefragment() + "-1");
        }
    }

    public void headingToXML(XMLWriter xml, int level, Heading head, long treeid, int count, boolean children) throws IOException {
        if (!this.afterTocElement) {
            return;
        }
        ++this.openElements;
        xml.openElement("toc-part", children);
        xml.attribute("level", level);
        if (!"".equals(head.title())) {
            xml.attribute("title", head.title());
        }
        if (head.numbered() && this.fragmentNumbering != null) {
            FragmentNumbering.Prefix pref = this.fragmentNumbering.getTranscludedPrefix(treeid, count, head.fragment(), head.index());
            if (pref != null) {
                xml.attribute("prefix", pref.value);
                xml.attribute("canonical", pref.canonical);
            }
        } else if (!"".equals(head.prefix())) {
            xml.attribute("prefix", head.prefix());
        }
        xml.attribute("idref", treeid + "-" + count + "-" + head.fragment() + "-" + head.index());
    }
}

