/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.config.ManifestDocument;
import org.pageseeder.psml.process.util.IncludesExcludesMatcher;
import org.slf4j.Logger;

public final class ManifestCreator {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Pattern PSML_URIID = Pattern.compile("<document[^>]+id=\"(\\d+)\"");
    private final @Nullable ManifestDocument manifestDoc;
    private @Nullable Logger logger = null;

    public ManifestCreator(@Nullable ManifestDocument xr) {
        if (xr != null && xr.getFilename() == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        this.manifestDoc = xr;
    }

    public void setLog(Logger log) {
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable File createManifest(Map<String, File> psmlFiles, File destinationFolder) throws ProcessException {
        ArrayList<Object> toInclude;
        boolean matching;
        if (this.manifestDoc == null) {
            return null;
        }
        String manifestFileName = this.manifestDoc.getFilename() + ".psml";
        this.logger.info("Manifest-Doc: Creating manifest file {}", (Object)manifestFileName);
        IncludesExcludesMatcher matcher = this.manifestDoc.buildMatcher();
        boolean bl = matching = matcher != null && matcher.hasPatterns();
        if (matching) {
            toInclude = new ArrayList();
            for (String path : psmlFiles.keySet()) {
                if (!matcher.matches(path)) continue;
                toInclude.add(path);
            }
        } else {
            toInclude = new ArrayList<String>(psmlFiles.keySet());
        }
        if (toInclude.isEmpty()) {
            this.logger.warn("Manifest file is not created as there are no files to point to");
            return null;
        }
        Collections.sort(toInclude, new FileNameComparator(psmlFiles));
        File manifest = new File(destinationFolder, manifestFileName);
        if (manifest.exists()) {
            throw new ProcessException("Manifest file already exists, it will be overwritten");
        }
        File dad = manifest.getParentFile();
        if (!dad.exists()) {
            dad.mkdirs();
        }
        if (!dad.exists()) {
            throw new ProcessException("Failed to create manifest parent folder " + dad.getAbsolutePath());
        }
        try {
            if (!manifest.createNewFile()) {
                throw new ProcessException("Failed to create manifest file " + manifest.getAbsolutePath());
            }
            try (FileOutputStream manifestStream = new FileOutputStream(manifest);){
                manifestStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n".getBytes(UTF8));
                manifestStream.write("<document id=\"0\" type=\"manifest\" level=\"portable\">\n".getBytes(UTF8));
                manifestStream.write("  <section id=\"xrefs\">\n".getBytes(UTF8));
                manifestStream.write("    <xref-fragment id=\"xrefs\">\n".getBytes(UTF8));
                for (String string : toInclude) {
                    File file = psmlFiles.get(string);
                    String uriid = null;
                    try (BufferedReader in = Files.newBufferedReader(file.toPath(), UTF8);){
                        String content;
                        Matcher m;
                        char[] buffer = new char[200];
                        int charsRead = in.read(buffer);
                        if (charsRead != -1 && (m = PSML_URIID.matcher(content = new String(buffer, 0, charsRead))).find()) {
                            uriid = m.group(1);
                        }
                    }
                    catch (IOException ex) {
                        this.logger.error("Failed to read PSML file " + string, (Throwable)ex);
                    }
                    manifestStream.write("      <blockxref type=\"embed\"".getBytes(UTF8));
                    manifestStream.write((" href=\"" + string + "\"").getBytes(UTF8));
                    manifestStream.write(" frag=\"default\"".getBytes(UTF8));
                    manifestStream.write(" reverselink=\"false\"".getBytes(UTF8));
                    if (uriid != null) {
                        manifestStream.write((" uriid=\"" + uriid + "\"").getBytes(UTF8));
                    }
                    manifestStream.write((">" + file.getName() + "</blockxref>\n").getBytes(UTF8));
                }
                manifestStream.write("    </xref-fragment>\n".getBytes(UTF8));
                manifestStream.write("  </section>\n".getBytes(UTF8));
                manifestStream.write("</document>\n".getBytes(UTF8));
            }
        }
        catch (IOException ex) {
            this.logger.error("Failed to write manifest file", (Throwable)ex);
            throw new ProcessException("Failed to write to manifest file: " + ex.getMessage(), ex);
        }
        this.logger.info("Manifest-Doc: Complete");
        return manifest;
    }

    private static class FileNameComparator
    implements Comparator<String> {
        private final Map<String, File> psmlFiles;

        public FileNameComparator(Map<String, File> all) {
            this.psmlFiles = all;
        }

        @Override
        public int compare(String path1, String path2) {
            File file1 = this.psmlFiles.get(path1);
            File file2 = this.psmlFiles.get(path2);
            if (file1 == null || file2 == null) {
                throw new IllegalArgumentException("Invalid path has no file");
            }
            return file1.getName().compareTo(file2.getName());
        }
    }
}

