/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pageseeder.psml.html.HTMLElement;
import org.pageseeder.psml.html.HTMLNode;
import org.pageseeder.psml.html.HTMLText;
import org.pageseeder.psml.md.InlineParser;

public class HTMLInlineParser {
    private static final String DOUBLE_EMPHASIS = "(\\*\\*(.*?)\\*\\*)";
    private static final String EMPHASIS = "(\\*(.*?)\\*)";
    private static final String DOUBLE_UNDERSCORE = "(__(.*?)__)";
    private static final String UNDERSCORE = "(\\b_(.*?)_\\b)";
    private static final String CODE_ESCAPE = "(``\\s?(.*?)\\s?``)";
    private static final String CODE = "(`(.*?)`)";
    private static final String IMAGE = "(\\!\\[(.*?)\\]\\((.*?)\\))";
    private static final String REF = "(\\[(.*?)\\]\\((.*?)\\))";
    private static final String LINK = "(<((https?://|mailto:)(.*?))>)";
    private static final String LINK_AUTO = "(https?://\\S+[\\w/+=@\\-])";
    private static final Pattern TOKENS = Pattern.compile("(\\*\\*(.*?)\\*\\*)|(__(.*?)__)|(\\*(.*?)\\*)|(\\b_(.*?)_\\b)|(``\\s?(.*?)\\s?``)|(`(.*?)`)|(\\!\\[(.*?)\\]\\((.*?)\\))|(\\[(.*?)\\]\\((.*?)\\))|(<((https?://|mailto:)(.*?))>)|(https?://\\S+[\\w/+=@\\-])");

    public List<HTMLNode> parse(String content) {
        return this.parse(content, false);
    }

    private List<HTMLNode> parse(String content, boolean inLink) {
        String text;
        ArrayList<HTMLNode> nodes = new ArrayList<HTMLNode>();
        Matcher m = TOKENS.matcher(content);
        int previousEnd = 0;
        while (m.find()) {
            String url;
            String text2;
            HTMLElement link;
            HTMLElement monospace;
            String code;
            HTMLElement element;
            if (m.start() > previousEnd) {
                text = content.substring(previousEnd, m.start());
                if (text.endsWith("\\")) {
                    nodes.add(new HTMLText(InlineParser.unescape(text + content.substring(m.start(), m.end()))));
                    previousEnd = m.end();
                    continue;
                }
                nodes.add(new HTMLText(InlineParser.unescape(text)));
            }
            previousEnd = m.end();
            if (m.group(1) != null) {
                element = new HTMLElement(HTMLElement.Name.STRONG);
                element.addNodes(this.parse(m.group(2)));
                nodes.add(element);
            } else if (m.group(3) != null) {
                element = new HTMLElement(HTMLElement.Name.STRONG);
                element.addNodes(this.parse(m.group(4)));
                nodes.add(element);
            }
            if (m.group(5) != null) {
                element = new HTMLElement(HTMLElement.Name.EM);
                element.addNodes(this.parse(m.group(6)));
                nodes.add(element);
                continue;
            }
            if (m.group(7) != null) {
                element = new HTMLElement(HTMLElement.Name.EM);
                element.addNodes(this.parse(m.group(8)));
                nodes.add(element);
                continue;
            }
            if (m.group(9) != null) {
                code = m.group(10);
                monospace = new HTMLElement(HTMLElement.Name.CODE);
                if (!code.isEmpty()) {
                    monospace.addNode(new HTMLText(code));
                }
                nodes.add(monospace);
                continue;
            }
            if (m.group(11) != null) {
                code = m.group(12);
                monospace = new HTMLElement(HTMLElement.Name.CODE);
                if (!code.isEmpty()) {
                    monospace.addNode(new HTMLText(code));
                }
                nodes.add(monospace);
                continue;
            }
            if (m.group(13) != null && !inLink) {
                String alt = m.group(14);
                String src = m.group(15);
                if (src.startsWith("http")) {
                    link = new HTMLElement(HTMLElement.Name.A);
                    link.setAttribute("href", InlineParser.unescape(src));
                    link.addNodes(this.parse(alt, true));
                    nodes.add(link);
                    continue;
                }
                HTMLElement image = new HTMLElement(HTMLElement.Name.IMG);
                image.setAttribute("alt", InlineParser.unescape(alt));
                image.setAttribute("src", InlineParser.unescape(src));
                nodes.add(image);
                continue;
            }
            if (m.group(16) != null && !inLink) {
                String ref = m.group(18);
                text2 = m.group(17);
                link = new HTMLElement(HTMLElement.Name.A);
                link.setAttribute("href", InlineParser.unescape(ref));
                link.addNodes(this.parse(text2, true));
                nodes.add(link);
                continue;
            }
            if (m.group(19) != null && !inLink) {
                url = m.group(20);
                text2 = m.group(22);
                link = new HTMLElement(HTMLElement.Name.A);
                link.setAttribute("href", InlineParser.unescape(url));
                link.addNode(new HTMLText(InlineParser.unescape(text2)));
                nodes.add(link);
                continue;
            }
            if (m.group(23) != null && !inLink) {
                url = m.group(23);
                HTMLElement link2 = new HTMLElement(HTMLElement.Name.A);
                link2.setAttribute("href", InlineParser.unescape(url));
                link2.addNode(new HTMLText(InlineParser.unescape(url)));
                nodes.add(link2);
                continue;
            }
            if (!inLink) continue;
            nodes.add(new HTMLText(InlineParser.unescape(content)));
        }
        if (previousEnd < content.length()) {
            text = content.substring(previousEnd);
            nodes.add(new HTMLText(InlineParser.unescape(text)));
        }
        return nodes;
    }
}

