/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import org.pageseeder.psml.md.MarkdownInputOptions;

public class Configuration {
    private int lineBreakThreshold = 66;
    private boolean isDocumentMode = false;
    private boolean newFragmentPerHeading = false;

    public void setFragmentMode(boolean isFragmentMode) {
        this.isDocumentMode = !isFragmentMode;
    }

    public boolean isFragment() {
        return !this.isDocumentMode;
    }

    public boolean isDocumentMode() {
        return this.isDocumentMode;
    }

    public void setLineBreakThreshold(int lineBreakThreshold) {
        this.lineBreakThreshold = lineBreakThreshold;
    }

    public int getLineBreakThreshold() {
        return this.lineBreakThreshold;
    }

    public void setNewFragmentPerHeading(boolean newFragmentPerHeading) {
        this.newFragmentPerHeading = newFragmentPerHeading;
    }

    public boolean isNewFragmentPerHeading() {
        return this.newFragmentPerHeading;
    }

    public MarkdownInputOptions toMarkdownInputOptions() {
        return new MarkdownInputOptions(this.lineBreakThreshold, this.isDocumentMode, this.newFragmentPerHeading);
    }

    static Configuration fromMarkdownInputOptions(MarkdownInputOptions options) {
        Configuration config = new Configuration();
        config.lineBreakThreshold = options.getLineBreakThreshold();
        config.isDocumentMode = options.isDocument();
        config.newFragmentPerHeading = options.isNewFragmentPerHeading();
        return config;
    }
}

