/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.md.Configuration;
import org.pageseeder.psml.md.InlineParser;
import org.pageseeder.psml.md.MarkdownInputOptions;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.model.PSMLNode;
import org.pageseeder.psml.util.DiagnosticCollector;
import org.pageseeder.psml.util.NilDiagnosticCollector;

public class BlockParser {
    private MarkdownInputOptions options;

    public BlockParser() {
        this.options = MarkdownInputOptions.defaultFragmentOptions();
    }

    public BlockParser(MarkdownInputOptions options) {
        this.options = options;
    }

    public List<PSMLElement> parse(List<String> lines) {
        return BlockParser.parse(lines, this.options);
    }

    public List<PSMLElement> parse(List<String> lines, DiagnosticCollector collector) {
        return BlockParser.parse(lines, this.options, collector);
    }

    public MarkdownInputOptions getOptions() {
        return this.options;
    }

    public void setOptions(MarkdownInputOptions options) {
        this.options = options;
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    public void setConfiguration(Configuration configuration) {
        this.options = configuration.toMarkdownInputOptions();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    public Configuration getConfiguration() {
        return Configuration.fromMarkdownInputOptions(this.options);
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    public List<PSMLElement> parse(List<String> lines, Configuration config) {
        return BlockParser.parse(lines, config.toMarkdownInputOptions());
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    public void processLine(String line, @Nullable String next, State state, Configuration config) {
        BlockParser.processLine(line, next, state, config.toMarkdownInputOptions());
    }

    public static List<PSMLElement> parse(List<String> lines, MarkdownInputOptions options) {
        return BlockParser.parse(lines, options, new NilDiagnosticCollector());
    }

    private static List<PSMLElement> parse(List<String> lines, MarkdownInputOptions options, DiagnosticCollector collector) {
        State state = new State(collector);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            String next = i < lines.size() - 1 ? lines.get(i + 1) : null;
            BlockParser.processLine(line, next, state, options);
        }
        state.commitAll();
        return state.elements;
    }

    public static void processLine(String line, @Nullable String next, State state, MarkdownInputOptions options) {
        ++state.line;
        if (line.matches("\\s?(==+|--+)\\s*")) {
            if (options.isDocument() && !state.isDescendantOf(PSMLElement.Name.SECTION)) {
                state.commitAll();
            }
        } else if (line.matches("\\s*\\*\\s?\\*\\s?\\*[\\s*]*")) {
            if (options.isDocument()) {
                state.ensureFragment();
                state.newFragment();
            }
        } else if (line.matches("\\s*") && !state.isCodeFenced()) {
            state.commitUpToBlockOrFragment();
        } else if (line.matches("\\s*(-|\\+|\\*|\\d+\\.)\\s.+")) {
            BlockParser.processListItem(line, state, options);
        } else if (state.isInList()) {
            if (options.isDocument()) {
                state.ensureFragment();
            }
            if (!state.context.isEmpty() && state.text != null) {
                state.append(line.trim());
            }
        } else if (line.matches("\\s{4}.*") && !state.isCodeFenced()) {
            if (options.isDocument()) {
                state.ensureFragment();
            }
            if (!state.isElement(PSMLElement.Name.PREFORMAT)) {
                state.commitUpToBlockOrFragment();
                state.push(PSMLElement.Name.PREFORMAT, line.substring(4));
            } else {
                state.append(line.substring(4));
            }
        } else if (line.startsWith("```")) {
            BlockParser.processFencedCodeBoundary(line, state, options);
        } else if (line.startsWith("~~~")) {
            BlockParser.processFencedBlockBoundary(line, state, options);
        } else if (line.matches("\\s*>+\\s*.*") && !state.isElement(PSMLElement.Name.PREFORMAT)) {
            BlockParser.processQuotedContent(line, state, options);
        } else if (line.startsWith("|") && !state.isElement(PSMLElement.Name.PREFORMAT)) {
            BlockParser.processTableRow(line, next, state, options);
        } else if (options.isDocument() && !state.isDescendantOf(PSMLElement.Name.SECTION) && line.matches("^[^:]+:\\s.*")) {
            BlockParser.processMetadataProperty(line, state, options);
        } else {
            if (options.isDocument()) {
                state.ensureFragment();
            }
            if (state.isElement(PSMLElement.Name.PREFORMAT)) {
                state.append(line);
            } else {
                Pattern headingPattern = Pattern.compile("^\\s*(#{1,6})\\s+(.*?)(#{1,6})?$");
                Matcher m = headingPattern.matcher(line);
                if (m.matches()) {
                    PSMLElement section;
                    state.commitUpToBlockOrFragment();
                    String level = Integer.toString(m.group(1).length());
                    String text = m.group(2).trim();
                    if (options.isNewFragmentPerHeading()) {
                        state.ensureFragment();
                        state.newFragment();
                    }
                    if (options.isDocument() && !state.isEmpty() && !"1".equals(level)) {
                        state.newFragment();
                    }
                    PSMLElement heading = new PSMLElement(PSMLElement.Name.HEADING);
                    heading.setAttribute("level", level);
                    state.push(heading, text);
                    state.commit();
                    if (options.isDocument() && (section = state.ancestor(PSMLElement.Name.SECTION)) != null && "title".equals(section.getAttribute("id"))) {
                        state.commitUpto(PSMLElement.Name.DOCUMENT);
                    }
                } else {
                    boolean isTitle = false;
                    PSMLElement element = new PSMLElement(PSMLElement.Name.PARA);
                    if (next != null) {
                        if (next.matches("\\s*==+\\s*")) {
                            PSMLElement section;
                            if (options.isDocument() && !state.isEmpty()) {
                                state.newSection();
                            }
                            element = new PSMLElement(PSMLElement.Name.HEADING);
                            element.setAttribute("level", "1");
                            if (options.isDocument() && (section = state.ancestor(PSMLElement.Name.SECTION)) != null && "title".equals(section.getAttribute("id"))) {
                                isTitle = true;
                            }
                        } else if (next.matches("\\s*--+\\s*")) {
                            if (options.isDocument() && !state.isEmpty()) {
                                state.newFragment();
                            }
                            element = new PSMLElement(PSMLElement.Name.HEADING);
                            element.setAttribute("level", "2");
                        }
                    }
                    if (!state.isElement(element.getElement())) {
                        state.commitUpToBlockOrFragment();
                        state.push(element, line.trim());
                    } else {
                        if (state.lineBreak) {
                            state.lineBreak();
                        }
                        state.append(line.trim());
                    }
                    boolean bl = state.lineBreak = line.length() < options.getLineBreakThreshold();
                    if (isTitle) {
                        state.commitUpto(PSMLElement.Name.DOCUMENT);
                    }
                }
            }
        }
    }

    private static void processListItem(String line, State state, MarkdownInputOptions options) {
        Pattern x;
        Matcher m;
        if (options.isDocument()) {
            state.ensureFragment();
        }
        if ((m = (x = Pattern.compile("^\\s*(-|\\+|\\*|\\d+\\.)\\s+(.+)$")).matcher(line)).matches()) {
            String no = m.group(1);
            if (state.isInList()) {
                state.commit();
            } else {
                PSMLElement list;
                state.commitUpToBlockOrFragment();
                if (no.matches("\\d+\\.")) {
                    list = new PSMLElement(PSMLElement.Name.NLIST);
                    String initial = no.substring(0, no.length() - 1);
                    if (!"1".equals(initial)) {
                        list.setAttribute("start", initial);
                    }
                } else {
                    list = new PSMLElement(PSMLElement.Name.LIST);
                }
                state.push(list);
            }
            state.push(PSMLElement.Name.ITEM, m.group(2).trim());
        }
    }

    private static void processQuotedContent(String line, State state, MarkdownInputOptions options) {
        if (options.isDocument()) {
            state.ensureFragment();
        }
        String text = line.substring(line.indexOf(62) + 1).replaceFirst("^\\s+", "");
        PSMLElement current = state.current();
        if (current != null && current.isElement(PSMLElement.Name.BLOCK)) {
            PSMLElement lastElement;
            PSMLNode last;
            List<PSMLNode> children = current.getNodes();
            PSMLNode pSMLNode = last = children.isEmpty() ? null : children.get(children.size() - 1);
            if (last instanceof PSMLElement && (lastElement = (PSMLElement)last).isElement(PSMLElement.Name.PARA)) {
                if (text.matches("\\s*")) {
                    current.addNode(new PSMLElement(PSMLElement.Name.PARA));
                } else {
                    lastElement.addText((lastElement.getText().isEmpty() ? "" : " ") + text);
                }
            }
        } else {
            state.commitUpToBlockOrFragment();
            PSMLElement block = new PSMLElement(PSMLElement.Name.BLOCK);
            block.setAttribute("label", "quoted");
            PSMLElement p = new PSMLElement(PSMLElement.Name.PARA);
            p.setText(text);
            block.addNode(p);
            state.push(block);
        }
    }

    private static void processTableRow(String line, @Nullable String next, State state, MarkdownInputOptions options) {
        if (options.isDocument()) {
            state.ensureFragment();
        }
        assert (line.startsWith("|"));
        String[] columns = line.trim().substring(1).split("\\|");
        boolean inTable = state.isDescendantOf(PSMLElement.Name.TABLE);
        boolean isHeaderRow = false;
        if (!inTable && next != null && next.startsWith("|") && next.trim().matches("^\\|([\\s:-]+\\|){" + columns.length + "}")) {
            String[] cols;
            state.commitUpToBlockOrFragment();
            PSMLElement table = new PSMLElement(PSMLElement.Name.TABLE);
            String[] stringArray = cols = next.trim().substring(1).split("\\|");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col = stringArray[i];
                String align = BlockParser.toColAlign(col);
                PSMLElement colElement = new PSMLElement(PSMLElement.Name.COL);
                if (align != null) {
                    colElement.setAttribute("align", align);
                }
                table.addNode(colElement);
            }
            state.push(table);
            inTable = true;
            isHeaderRow = true;
        }
        if (inTable) {
            if (!line.trim().matches("^\\|([\\s:-]+\\|){" + columns.length + "}")) {
                PSMLElement row = new PSMLElement(PSMLElement.Name.ROW);
                if (isHeaderRow) {
                    row.setAttribute("part", "header");
                }
                state.push(row);
                for (String col : columns) {
                    String text = col.trim();
                    if (isHeaderRow && text.matches("^\\*\\*(.*)\\*\\*$")) {
                        text = text.substring(2, text.length() - 2);
                    }
                    state.push(PSMLElement.Name.CELL, text);
                    state.commit();
                }
                state.commit();
            }
        } else {
            state.push(PSMLElement.Name.PARA, line.trim());
        }
    }

    private static void processMetadataProperty(String line, State state, MarkdownInputOptions options) {
        int colon = line.indexOf(58);
        String title = line.substring(0, colon).trim();
        String name = title.toLowerCase().replaceAll("[^a-z0-9_-]", "_");
        String value = line.substring(colon + 2).trim();
        if (!state.isDescendantOf(PSMLElement.Name.METADATA) && name.toLowerCase().matches("^(type|title|description|docid)$")) {
            PSMLElement uri;
            if (!state.isDescendantOf(PSMLElement.Name.DOCUMENTINFO)) {
                state.push(PSMLElement.Name.DOCUMENTINFO);
                state.push(PSMLElement.Name.URI);
            }
            if ((uri = state.current()) != null && uri.isElement(PSMLElement.Name.URI)) {
                if ("type".equals(name)) {
                    uri.setAttribute("documenttype", value.replaceAll("\\W", "_"));
                } else if ("docid".equals(name)) {
                    uri.setAttribute(name, value.replaceAll("[^A-Za-z0-9_-]", "_"));
                } else if ("title".equals(name)) {
                    PSMLElement displayTitle = new PSMLElement(PSMLElement.Name.DISPLAYTITLE);
                    displayTitle.setText(value);
                    uri.addNode(displayTitle);
                } else if ("description".equals(name)) {
                    PSMLElement description = new PSMLElement(PSMLElement.Name.DESCRIPTION);
                    description.setText(value);
                    uri.addNode(description);
                }
            }
        } else {
            if (!state.isDescendantOf(PSMLElement.Name.METADATA)) {
                state.commitAll();
                state.push(PSMLElement.Name.METADATA);
                state.push(PSMLElement.Name.PROPERTIES);
            }
            PSMLElement property = new PSMLElement(PSMLElement.Name.PROPERTY);
            property.setAttribute("title", title);
            property.setAttribute("name", name);
            if (value.startsWith("[") && value.endsWith("]")) {
                String[] values;
                property.setAttribute("multiple", "true");
                for (String v : values = value.substring(1, value.length() - 1).split("\\s*,\\s*")) {
                    property.addNode(new PSMLElement(PSMLElement.Name.VALUE).setText(v.trim()));
                }
            } else {
                property.setAttribute("value", value);
            }
            state.push(property);
            state.commit();
        }
    }

    private static void processFencedCodeBoundary(String line, State state, MarkdownInputOptions options) {
        assert (line.startsWith("```"));
        if (options.isDocument()) {
            state.ensureFragment();
        }
        if (state.isElement(PSMLElement.Name.PREFORMAT)) {
            state.setCodeFence(false);
            state.append("");
            state.commitUpToBlockOrFragment();
        } else {
            String language;
            state.commitUpToBlockOrFragment();
            PSMLElement pre = new PSMLElement(PSMLElement.Name.PREFORMAT);
            if (line.length() > 3 && !(language = line.substring(3).trim()).isEmpty()) {
                pre.setAttribute("role", "lang-" + language);
            }
            state.push(pre, "");
            state.setCodeFence(true);
        }
    }

    private static void processFencedBlockBoundary(String line, State state, MarkdownInputOptions options) {
        assert (line.startsWith("~~~"));
        if (options.isDocument()) {
            state.ensureFragment();
        }
        String label = line.substring(3).trim();
        if (state.isDescendantOf(PSMLElement.Name.BLOCK) && label.isEmpty()) {
            state.commitUpto(PSMLElement.Name.BLOCK);
            state.commit();
            --state.fencedLabel;
        } else {
            state.commitUpto(PSMLElement.Name.BLOCK);
            ++state.fencedLabel;
            PSMLElement block = new PSMLElement(PSMLElement.Name.BLOCK);
            if (line.length() > 3) {
                if (!label.isEmpty()) {
                    block.setAttribute("label", label.replaceAll("[^a-zA-Z0-9_-]", "_"));
                } else {
                    state.warn("No label given for fenced block");
                }
            }
            state.push(block);
        }
    }

    private static @Nullable String toColAlign(String col) {
        String colSpec = col.trim();
        boolean startWithColon = colSpec.startsWith(":");
        boolean endsWithColon = colSpec.endsWith(":");
        if (startWithColon && endsWithColon) {
            return "center";
        }
        if (startWithColon) {
            return "left";
        }
        if (endsWithColon) {
            return "right";
        }
        return null;
    }

    public static final class State {
        private final DiagnosticCollector collector;
        private final List<PSMLElement> elements = new ArrayList<PSMLElement>();
        private final InlineParser inline = new InlineParser();
        private final List<PSMLElement> context = new ArrayList<PSMLElement>(4);
        private final String[] sectionIds = new String[]{"title", "content"};
        private int line = 0;
        private int sectionPosition = 0;
        private int fragmentId = 0;
        private @Nullable StringBuilder text = null;
        private boolean lineBreak = false;
        private boolean codeFence = false;
        private int fencedLabel = 0;

        public State() {
            this.collector = new NilDiagnosticCollector();
        }

        public State(DiagnosticCollector collector) {
            this.collector = collector;
        }

        public void warn(String message) {
            this.collector.warn(message + " at line " + this.line);
        }

        public boolean isCodeFenced() {
            return this.codeFence;
        }

        public boolean isLabelFenced() {
            return this.fencedLabel > 0;
        }

        public void setCodeFence(boolean fence) {
            this.codeFence = fence;
        }

        public boolean isInList() {
            int size = this.context.size();
            PSMLElement current = size > 0 ? this.context.get(size - 1) : null;
            PSMLElement parent = size > 1 ? this.context.get(size - 2) : null;
            boolean isCurrentList = current != null && (current.isElement(PSMLElement.Name.LIST) || current.isElement(PSMLElement.Name.NLIST));
            boolean isParentList = parent != null && (parent.isElement(PSMLElement.Name.LIST) || parent.isElement(PSMLElement.Name.NLIST));
            return isCurrentList || isParentList;
        }

        public @Nullable PSMLElement current() {
            if (this.context.isEmpty()) {
                return null;
            }
            return this.context.get(this.context.size() - 1);
        }

        public boolean isEmpty() {
            PSMLElement element = this.current();
            return element == null || element.isEmpty();
        }

        public @Nullable PSMLElement ancestor(PSMLElement.Name name) {
            int size = this.context.size();
            if (size == 0) {
                return null;
            }
            for (int i = size - 1; i >= 0; --i) {
                PSMLElement element = this.context.get(i);
                if (element.getElement() != name) continue;
                return element;
            }
            return null;
        }

        public boolean isElement(PSMLElement.Name name) {
            PSMLElement current = this.current();
            return current != null && current.isElement(name);
        }

        public boolean isDescendantOf(PSMLElement.Name name) {
            return this.ancestor(name) != null;
        }

        public void newSection() {
            if (this.sectionPosition < this.sectionIds.length) {
                this.commitAll();
                PSMLElement section = new PSMLElement(PSMLElement.Name.SECTION);
                String sectionId = this.sectionIds[this.sectionPosition];
                section.setAttribute("id", sectionId);
                this.push(section);
                ++this.sectionPosition;
            }
        }

        public void newFragment() {
            this.commitUpto(PSMLElement.Name.SECTION);
            PSMLElement fragment = new PSMLElement(PSMLElement.Name.FRAGMENT);
            fragment.setAttribute("id", ++this.fragmentId);
            this.push(fragment);
        }

        public void ensureFragment() {
            if (!this.isDescendantOf(PSMLElement.Name.SECTION)) {
                this.newSection();
            }
            if (!this.isDescendantOf(PSMLElement.Name.FRAGMENT)) {
                this.newFragment();
            }
        }

        public void push(PSMLElement.Name name, String text) {
            this.push(new PSMLElement(name), text);
        }

        public void push(PSMLElement.Name name) {
            this.push(new PSMLElement(name));
        }

        public void push(PSMLElement element) {
            this.context.add(element);
            this.text = null;
        }

        public void push(PSMLElement element, String text) {
            this.context.add(element);
            this.text = new StringBuilder(text);
        }

        public void append(String text) {
            if (this.text == null) {
                throw new NullPointerException("Failed to add text " + text);
            }
            this.text.append('\n').append(text);
        }

        public void commitAll() {
            this.lineBreak = false;
            this.commitText();
            int size = this.context.size();
            while (size > 0) {
                PSMLElement current = this.context.remove(size - 1);
                if (size > 1) {
                    PSMLElement parent = this.context.get(size - 2);
                    parent.addNode(current);
                } else {
                    this.elements.add(current);
                }
                size = this.context.size();
            }
        }

        public void commitUpToBlockOrFragment() {
            this.commitUpto(this.fencedLabel > 0 && this.isDescendantOf(PSMLElement.Name.BLOCK) ? PSMLElement.Name.BLOCK : PSMLElement.Name.FRAGMENT);
        }

        public void commitUpto(PSMLElement.Name name) {
            this.lineBreak = false;
            this.commitText();
            int size = this.context.size();
            while (size > 0 && !this.isElement(name)) {
                PSMLElement current = this.context.remove(size - 1);
                if (size > 1) {
                    PSMLElement parent = this.context.get(size - 2);
                    parent.addNode(current);
                } else {
                    this.elements.add(current);
                }
                size = this.context.size();
            }
        }

        public void commit() {
            this.commitText();
            int size = this.context.size();
            if (size > 0) {
                PSMLElement current = this.context.remove(size - 1);
                if (size > 1) {
                    PSMLElement parent = this.context.get(size - 2);
                    parent.addNode(current);
                } else {
                    this.elements.add(current);
                }
            }
        }

        public void commitText() {
            PSMLElement current = this.current();
            if (this.text != null && current != null) {
                List<PSMLNode> nodes = this.inline.parse(this.text.toString());
                current.addNodes(nodes);
                this.text = null;
            }
        }

        public void lineBreak() {
            this.commitText();
            PSMLElement current = this.current();
            if (current != null) {
                current.addNode(new PSMLElement(PSMLElement.Name.BR));
            }
            this.text = new StringBuilder();
        }
    }
}

