/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.action.OperationsBuffer;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.algorithm.MyersGreedyAlgorithm;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.PostXMLFixer;
import org.pageseeder.diffx.similarity.Similarity;
import org.pageseeder.diffx.similarity.SimilarityWagnerFischerAlgorithm;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLElement;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.diffx.token.impl.XMLStartElement;

@Deprecated(forRemoval=true)
public class GasherbrumIIIAlgorithm
implements DiffAlgorithm<XMLToken> {
    private static final Set<String> BLOCKS = Set.of("heading", "item", "para", "preformat", "row");
    public static final float DEFAULT_SIMILARITY_THRESHOLD = 0.5f;
    private final float similarityThreshold;
    private boolean hasError = false;

    public GasherbrumIIIAlgorithm() {
        this.similarityThreshold = 0.5f;
    }

    public GasherbrumIIIAlgorithm(float similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public void diff(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler) {
        List<XMLToken> gFrom = this.fold(from);
        List<XMLToken> gTo = this.fold(to);
        OperationsBuffer<XMLToken> buffer = this.diffBySimilarity(gFrom, gTo);
        PostXMLFixer fixer = new PostXMLFixer(handler);
        fixer.start();
        this.diffAndUnfold(gFrom, gTo, buffer, (DiffHandler<XMLToken>)fixer);
        fixer.end();
        this.hasError = fixer.hasError();
    }

    boolean hasError() {
        return this.hasError;
    }

    private OperationsBuffer<XMLToken> diffBySimilarity(List<XMLToken> from, List<XMLToken> to) {
        SimilarityWagnerFischerAlgorithm algorithm = new SimilarityWagnerFischerAlgorithm((Similarity)new XMLTokenSimilarityFunction(), this.similarityThreshold);
        OperationsBuffer buffer = new OperationsBuffer();
        algorithm.diff(from, to, (DiffHandler)buffer);
        return buffer;
    }

    private void diffAndUnfold(List<XMLToken> from, List<XMLToken> to, OperationsBuffer<XMLToken> path, DiffHandler<XMLToken> handler) {
        int i = 0;
        int j = 0;
        for (Operation operation : path.getOperations()) {
            Operator operator = operation.operator();
            XMLToken token = (XMLToken)operation.token();
            if (token.getType() == XMLTokenType.ELEMENT) {
                if (operator == Operator.MATCH) {
                    XMLElement fromElement = (XMLElement)from.get(i);
                    XMLElement toElement = (XMLElement)to.get(j);
                    this.diffElement(fromElement, toElement, operator, handler);
                } else {
                    for (XMLToken t : ((XMLElement)token).tokens()) {
                        handler.handle(operator, (Object)t);
                    }
                }
            } else {
                handler.handle(operator, (Object)token);
            }
            if (operator == Operator.MATCH || operator == Operator.INS) {
                ++j;
            }
            if (operator != Operator.MATCH && operator != Operator.DEL) continue;
            ++i;
        }
    }

    void diffElement(XMLElement from, XMLElement to, Operator operator, DiffHandler<XMLToken> handler) {
        boolean recurse = GasherbrumIIIAlgorithm.childHasBlock(from, to);
        if (recurse) {
            handler.handle(operator, (Object)from.getStart());
            this.diff(from.getContent(), to.getContent(), handler);
            handler.handle(operator, (Object)from.getEnd());
        } else {
            MatrixXMLAlgorithm matrix = new MatrixXMLAlgorithm();
            matrix.diff(from.tokens(), to.tokens(), handler);
        }
    }

    private List<XMLToken> fold(List<? extends XMLToken> in) {
        ArrayDeque<XMLToken> stack = new ArrayDeque<XMLToken>();
        ArrayList<XMLToken> out = new ArrayList<XMLToken>();
        ArrayList<XMLToken> children = null;
        for (XMLToken xMLToken : in) {
            if (children != null) {
                if (xMLToken.getType() == XMLTokenType.END_ELEMENT && BLOCKS.contains(xMLToken.getName()) && stack.size() == 1 && ((XMLToken)stack.peek()).getName().equals(xMLToken.getName())) {
                    XMLStartElement start = (XMLStartElement)stack.pop();
                    XMLEndElement end = (XMLEndElement)xMLToken;
                    out.add((XMLToken)new XMLElement((StartElementToken)start, (EndElementToken)end, children));
                    children = null;
                    continue;
                }
                if (xMLToken.getType() == XMLTokenType.START_ELEMENT) {
                    stack.push(xMLToken);
                } else if (xMLToken.getType() == XMLTokenType.END_ELEMENT) {
                    stack.pop();
                }
                children.add(xMLToken);
                continue;
            }
            if (xMLToken.getType() == XMLTokenType.START_ELEMENT && BLOCKS.contains(xMLToken.getName())) {
                children = new ArrayList<XMLToken>();
                stack.push(xMLToken);
                continue;
            }
            out.add(xMLToken);
        }
        return out;
    }

    private static boolean childHasBlock(XMLElement from, XMLElement to) {
        if (from.getContent().size() > 2 && to.getContent().size() > 2) {
            return GasherbrumIIIAlgorithm.childHasBlock(from) || GasherbrumIIIAlgorithm.childHasBlock(to);
        }
        return false;
    }

    private static boolean childHasBlock(XMLElement element) {
        for (XMLToken t : element.getContent()) {
            if (t.getType() != XMLTokenType.START_ELEMENT || !BLOCKS.contains(t.getName())) continue;
            return true;
        }
        return false;
    }

    private static class EditCounter
    implements DiffHandler<XMLToken> {
        int edits = 0;
        int tokens = 0;

        private EditCounter() {
        }

        public void handle(Operator operator, XMLToken token) {
            if (token.getType() == XMLTokenType.TEXT) {
                if (operator == Operator.MATCH) {
                    this.tokens += 2;
                } else {
                    ++this.edits;
                    ++this.tokens;
                }
            }
        }

        float editScore() {
            if (this.tokens == 0) {
                return 0.5f;
            }
            if (this.edits == 0) {
                return 1.0f;
            }
            return 1.0f - (float)this.edits / (float)this.tokens;
        }

        float lengthBonus() {
            return (float)Math.log(1.0 + (double)this.tokens - (double)this.edits) / 10.0f;
        }

        float score() {
            return this.editScore() + this.lengthBonus();
        }
    }

    private static class XMLTokenSimilarityFunction
    implements Similarity<XMLToken> {
        private XMLTokenSimilarityFunction() {
        }

        public float score(XMLToken a, XMLToken b) {
            if (a.getType() == XMLTokenType.ELEMENT && b.getType() == XMLTokenType.ELEMENT) {
                return this.scoreForElement((XMLElement)a, (XMLElement)b);
            }
            return a.equals(b) ? 1.0f : 0.0f;
        }

        public float scoreForElement(XMLElement a, XMLElement b) {
            boolean sameElementName = a.getStart().equals((XMLToken)b.getStart());
            if (!sameElementName) {
                return 0.0f;
            }
            if (a.getContent().isEmpty() && b.getContent().isEmpty()) {
                return 1.0f;
            }
            MyersGreedyAlgorithm alg = new MyersGreedyAlgorithm();
            EditCounter counter = new EditCounter();
            alg.diff(a.getContent(), b.getContent(), (DiffHandler)counter);
            return counter.score();
        }
    }
}

