/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.psml.diff.CellNormalizer;
import org.pageseeder.psml.diff.ListNormalizer;

public final class ElementDenormalizer
extends DiffFilter<XMLToken>
implements DiffHandler<XMLToken> {
    private final List<Operation<XMLToken>> buffer = new ArrayList<Operation<XMLToken>>();
    private final Deque<StartElementToken> elementsToClose = new ArrayDeque<StartElementToken>();
    private final Deque<Integer> elementsToCloseLevel = new ArrayDeque<Integer>();
    private int level = 0;

    public ElementDenormalizer(DiffHandler<XMLToken> handler) {
        super(handler);
    }

    public void handle(Operator operator, XMLToken token) {
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            ++this.level;
        } else if (token.getType() == XMLTokenType.END_ELEMENT) {
            --this.level;
            if (!this.elementsToCloseLevel.isEmpty() && this.level == this.elementsToCloseLevel.peek()) {
                this.elementsToCloseLevel.pop();
                this.target.handle(operator, (Object)new XMLEndElement(this.elementsToClose.pop()));
                return;
            }
        }
        if (token.equals((XMLToken)CellNormalizer.CELL_START) || token.equals((XMLToken)ListNormalizer.LIST_START)) {
            this.buffer.add((Operation<XMLToken>)new Operation(operator, (Object)token));
            return;
        }
        if (!this.buffer.isEmpty()) {
            if (token.getType() == XMLTokenType.ATTRIBUTE) {
                this.handleAttribute(operator, token);
                return;
            }
            this.flushBuffer();
        }
        this.target.handle(operator, (Object)token);
    }

    public void end() {
        this.flushBuffer();
        this.target.end();
    }

    private void handleAttribute(Operator operator, XMLToken attribute) {
        if (operator == Operator.INS || operator == Operator.MATCH) {
            XMLToken element = (XMLToken)this.buffer.get(0).token();
            if (element.equals((XMLToken)CellNormalizer.CELL_START) && "hcell".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                this.buffer.set(0, (Operation<XMLToken>)new Operation(this.buffer.get(0).operator(), (Object)CellNormalizer.HCELL_START));
                this.elementsToClose.push(CellNormalizer.HCELL_START);
                this.elementsToCloseLevel.push(this.level - 1);
            } else if (element.equals((XMLToken)ListNormalizer.LIST_START) && "nlist".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                this.buffer.set(0, (Operation<XMLToken>)new Operation(this.buffer.get(0).operator(), (Object)ListNormalizer.NLIST_START));
                this.elementsToClose.push(ListNormalizer.NLIST_START);
                this.elementsToCloseLevel.push(this.level - 1);
            }
        }
        this.buffer.add((Operation<XMLToken>)new Operation(operator, (Object)attribute));
    }

    private void flushBuffer() {
        for (Operation<XMLToken> operation : this.buffer) {
            this.target.handle(operation.operator(), (Object)((XMLToken)operation.token()));
        }
        this.buffer.clear();
    }
}

