/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.psml.diff.PSMLDiffer;
import org.pageseeder.psml.process.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DiffHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiffHandler.class);
    private final Writer xml;
    private final Map<String, String> compareFragments;
    private final PSMLDiffer differ;
    private final Deque<String> elements = new ArrayDeque<String>();
    private @Nullable String fragmentId = null;
    private @Nullable Writer fragmentContent = null;

    public DiffHandler(Writer out, Map<String, String> comparefragments, PSMLDiffer diff) {
        this.xml = out;
        this.compareFragments = comparefragments;
        this.differ = diff;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isFragment(qName) && "content".equals(this.elements.peek())) {
            this.fragmentId = atts.getValue("id");
            this.fragmentContent = new StringWriter();
        }
        try {
            this.xml.write("<" + qName);
            if (this.fragmentContent != null) {
                this.fragmentContent.write("<" + qName);
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + qName, ex);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getQName(i);
            String value = atts.getValue(i);
            try {
                this.xml.write(" " + name + "=\"" + XMLUtils.escapeForAttribute(value) + "\"");
                if (this.fragmentContent == null) continue;
                this.fragmentContent.write(" " + name + "=\"" + XMLUtils.escapeForAttribute(value) + "\"");
                continue;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to add attribute \"" + atts.getQName(i) + "\" to element " + qName, ex);
            }
        }
        try {
            this.xml.write(">");
            if (this.fragmentContent != null) {
                this.fragmentContent.write(">");
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + qName, ex);
        }
        this.elements.push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.pop();
        try {
            this.xml.write("</" + qName + ">");
            if ("content".equals(qName) && this.fragmentId != null) {
                assert (this.fragmentContent != null);
                String current = this.compareFragments.get(this.fragmentId);
                if (current != null) {
                    try {
                        StringWriter diff = new StringWriter();
                        this.differ.diff(new StringReader(current), new StringReader(this.fragmentContent.toString()), (Writer)diff);
                        String diffx = diff.toString();
                        if (diffx.startsWith("<?")) {
                            diffx = diffx.substring(diffx.indexOf(62) + 1);
                        }
                        this.xml.write("\n<diff>");
                        this.xml.write(diffx);
                        this.xml.write("</diff>\n");
                    }
                    catch (DiffException ex) {
                        LOGGER.error("Failed to diff content: {}", (Object)ex.getMessage());
                    }
                    catch (IOException ex) {
                        throw new SAXException("Failed to write <diff> element: " + ex.getMessage(), ex);
                    }
                }
                this.fragmentId = null;
                this.fragmentContent = null;
            }
            if (this.fragmentContent != null) {
                this.fragmentContent.write("</" + qName + ">");
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + qName, ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xml.write(XMLUtils.escape(new String(ch, start, length)));
            if (this.fragmentContent != null) {
                this.fragmentContent.write(XMLUtils.escape(new String(ch, start, length)));
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }

    private boolean isFragment(String qName) {
        return "fragment".equals(qName) || "media-fragment".equals(qName) || "xref-fragment".equals(qName) || "properties-fragment".equals(qName);
    }
}

